/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.ws.RealWebSocket;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Exchange {
    final Call call;
    final ExchangeCodec codec;
    private boolean duplex;
    final EventListener eventListener;
    final ExchangeFinder finder;
    final Transmitter transmitter;

    public Exchange(Transmitter transmitter, Call call, EventListener eventListener, ExchangeFinder exchangeFinder, ExchangeCodec exchangeCodec) {
        this.transmitter = transmitter;
        this.call = call;
        this.eventListener = eventListener;
        this.finder = exchangeFinder;
        this.codec = exchangeCodec;
    }

    @Nullable
    IOException bodyComplete(long l, boolean bl, boolean bl2, @Nullable IOException iOException) {
        if (iOException != null) {
            this.trackFailure(iOException);
        }
        if (bl2) {
            if (iOException != null) {
                this.eventListener.requestFailed(this.call, iOException);
            } else {
                this.eventListener.requestBodyEnd(this.call, l);
            }
        }
        if (bl) {
            if (iOException != null) {
                this.eventListener.responseFailed(this.call, iOException);
            } else {
                this.eventListener.responseBodyEnd(this.call, l);
            }
        }
        return this.transmitter.exchangeMessageDone(this, bl2, bl, iOException);
    }

    public void cancel() {
        this.codec.cancel();
    }

    public RealConnection connection() {
        return this.codec.connection();
    }

    public Sink createRequestBody(Request request, boolean bl) throws IOException {
        this.duplex = bl;
        long l = request.body().contentLength();
        this.eventListener.requestBodyStart(this.call);
        return new RequestBodySink(this.codec.createRequestBody(request, l), l);
    }

    public void detachWithViolence() {
        this.codec.cancel();
        this.transmitter.exchangeMessageDone(this, true, true, null);
    }

    public void finishRequest() throws IOException {
        try {
            this.codec.finishRequest();
            return;
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public void flushRequest() throws IOException {
        try {
            this.codec.flushRequest();
            return;
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public boolean isDuplex() {
        return this.duplex;
    }

    public RealWebSocket.Streams newWebSocketStreams() throws SocketException {
        this.transmitter.timeoutEarlyExit();
        return this.codec.connection().newWebSocketStreams(this);
    }

    public void noNewExchangesOnConnection() {
        this.codec.connection().noNewExchanges();
    }

    public void noRequestBody() {
        this.transmitter.exchangeMessageDone(this, true, false, null);
    }

    public ResponseBody openResponseBody(Response closeable) throws IOException {
        try {
            this.eventListener.responseBodyStart(this.call);
            String string2 = closeable.header("Content-Type");
            long l = this.codec.reportedContentLength((Response)closeable);
            closeable = this.codec.openResponseBodySource((Response)closeable);
            ResponseBodySource responseBodySource = new ResponseBodySource((Source)closeable, l);
            closeable = new RealResponseBody(string2, l, Okio.buffer(responseBodySource));
            return closeable;
        }
        catch (IOException iOException) {
            this.eventListener.responseFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    @Nullable
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Response.Builder builder;
        block3: {
            try {
                builder = this.codec.readResponseHeaders(bl);
                if (builder == null) break block3;
            }
            catch (IOException iOException) {
                this.eventListener.responseFailed(this.call, iOException);
                this.trackFailure(iOException);
                throw iOException;
            }
            Internal.instance.initExchange(builder, this);
        }
        return builder;
    }

    public void responseHeadersEnd(Response response) {
        this.eventListener.responseHeadersEnd(this.call, response);
    }

    public void responseHeadersStart() {
        this.eventListener.responseHeadersStart(this.call);
    }

    public void timeoutEarlyExit() {
        this.transmitter.timeoutEarlyExit();
    }

    void trackFailure(IOException iOException) {
        this.finder.trackFailure();
        this.codec.connection().trackFailure(iOException);
    }

    public Headers trailers() throws IOException {
        return this.codec.trailers();
    }

    public void webSocketUpgradeFailed() {
        this.bodyComplete(-1L, true, true, null);
    }

    public void writeRequestHeaders(Request request) throws IOException {
        try {
            this.eventListener.requestHeadersStart(this.call);
            this.codec.writeRequestHeaders(request);
            this.eventListener.requestHeadersEnd(this.call, request);
            return;
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    private final class RequestBodySink
    extends ForwardingSink {
        private long bytesReceived;
        private boolean closed;
        private boolean completed;
        private long contentLength;

        RequestBodySink(Sink sink, long l) {
            super(sink);
            this.contentLength = l;
        }

        @Nullable
        private IOException complete(@Nullable IOException iOException) {
            if (this.completed) {
                return iOException;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, false, true, iOException);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            long l = this.contentLength;
            if (l != -1L && this.bytesReceived != l) {
                throw new ProtocolException("unexpected end of stream");
            }
            try {
                super.close();
                this.complete(null);
                return;
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
                return;
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Override
        public void write(Buffer object, long l) throws IOException {
            if (!this.closed) {
                long l2 = this.contentLength;
                if (l2 != -1L && this.bytesReceived + l > l2) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("expected ");
                    ((StringBuilder)object).append(this.contentLength);
                    ((StringBuilder)object).append(" bytes but received ");
                    ((StringBuilder)object).append(this.bytesReceived + l);
                    throw new ProtocolException(((StringBuilder)object).toString());
                }
                try {
                    super.write((Buffer)object, l);
                    this.bytesReceived += l;
                    return;
                }
                catch (IOException iOException) {
                    throw this.complete(iOException);
                }
            }
            throw new IllegalStateException("closed");
        }
    }

    final class ResponseBodySource
    extends ForwardingSource {
        private long bytesReceived;
        private boolean closed;
        private boolean completed;
        private final long contentLength;

        ResponseBodySource(Source source, long l) {
            super(source);
            this.contentLength = l;
            if (l == 0L) {
                this.complete(null);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                this.complete(null);
                return;
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Nullable
        IOException complete(@Nullable IOException iOException) {
            if (this.completed) {
                return iOException;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, true, false, iOException);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long read(Buffer object, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            try {
                long l2 = this.delegate().read((Buffer)object, l);
                if (l2 == -1L) {
                    this.complete(null);
                    return -1L;
                }
                l = this.bytesReceived + l2;
                long l3 = this.contentLength;
                if (l3 != -1L && l > l3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("expected ");
                    stringBuilder.append(this.contentLength);
                    stringBuilder.append(" bytes but received ");
                    stringBuilder.append(l);
                    object = new ProtocolException(stringBuilder.toString());
                    throw object;
                }
                this.bytesReceived = l;
                if (l == l3) {
                    this.complete(null);
                }
                return l2;
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }
    }
}

