/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;

final class ExchangeFinder {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private final Address address;
    private final Call call;
    private RealConnection connectingConnection;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private boolean hasStreamFailure;
    private Route nextRouteToTry;
    private RouteSelector.Selection routeSelection;
    private final RouteSelector routeSelector;
    private final Transmitter transmitter;

    ExchangeFinder(Transmitter transmitter, RealConnectionPool realConnectionPool, Address address, Call call, EventListener eventListener) {
        this.transmitter = transmitter;
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = call;
        this.eventListener = eventListener;
        this.routeSelector = new RouteSelector(address, realConnectionPool.routeDatabase, call, eventListener);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RealConnection findConnection(int var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) throws IOException {
        var6_6 = this.connectionPool;
        synchronized (var6_6) {
            if (this.transmitter.isCanceled()) {
                var8_9 = new IOException("Canceled");
                throw var8_9;
            }
            this.hasStreamFailure = false;
            var7_7 = this.transmitter.connection;
            var8_8 = this.transmitter.connection;
            var9_10 = null;
            var10_11 = var8_8 != null && this.transmitter.connection.noNewExchanges != false ? this.transmitter.releaseConnectionNoEvents() : null;
            if (this.transmitter.connection != null) {
                var11_12 = this.transmitter.connection;
                var7_7 = null;
            } else {
                var11_12 = null;
            }
            if (var11_12 != null) ** GOTO lbl-1000
            if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, null, false)) {
                var11_12 = this.transmitter.connection;
                var8_8 = null;
                var12_13 = true;
            } else {
                var8_8 = this.nextRouteToTry;
                if (var8_8 != null) {
                    this.nextRouteToTry = null;
                } else if (this.retryCurrentRoute()) {
                    var8_8 = this.transmitter.connection.route();
                } else lbl-1000:
                // 2 sources

                {
                    var8_8 = null;
                }
                var12_13 = false;
            }
        }
        Util.closeQuietly((Socket)var10_11);
        if (var7_7 != null) {
            this.eventListener.connectionReleased(this.call, (Connection)var7_7);
        }
        if (var12_13) {
            this.eventListener.connectionAcquired(this.call, (Connection)var11_12);
        }
        if (var11_12 != null) {
            return var11_12;
        }
        if (!(var8_8 != null || (var10_11 = this.routeSelection) != null && var10_11.hasNext())) {
            this.routeSelection = this.routeSelector.next();
            var13_14 = true;
        } else {
            var13_14 = false;
        }
        var6_6 = this.connectionPool;
        synchronized (var6_6) {
            if (this.transmitter.isCanceled()) {
                var8_8 = new IOException("Canceled");
                throw var8_8;
            }
            if (var13_14) {
                var10_11 = var7_7 = this.routeSelection.getAll();
                if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, (List<Route>)var7_7, false)) {
                    var11_12 = this.transmitter.connection;
                    var12_13 = true;
                    var10_11 = var7_7;
                }
            } else {
                var10_11 = null;
            }
            var7_7 = var8_8;
            if (!var12_13) {
                var11_12 = var8_8;
                if (var8_8 == null) {
                    var11_12 = this.routeSelection.next();
                }
                this.connectingConnection = var8_8 = new RealConnection(this.connectionPool, (Route)var11_12);
                var7_7 = var11_12;
                var11_12 = var8_8;
            }
            ** if (!var12_13) goto lbl67
        }
lbl-1000:
        // 1 sources

        {
            this.eventListener.connectionAcquired(this.call, (Connection)var11_12);
            return var11_12;
        }
lbl67:
        // 1 sources

        var11_12.connect(var1_1, var2_2, var3_3, var4_4, var5_5, this.call, this.eventListener);
        this.connectionPool.routeDatabase.connected(var11_12.route());
        var6_6 = this.connectionPool;
        synchronized (var6_6) {
            this.connectingConnection = null;
            if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, (List<Route>)var10_11, true)) {
                var11_12.noNewExchanges = true;
                var8_8 = var11_12.socket();
                var11_12 = this.transmitter.connection;
                this.nextRouteToTry = var7_7;
            } else {
                this.connectionPool.put((RealConnection)var11_12);
                this.transmitter.acquireConnectionNoEvents((RealConnection)var11_12);
                var8_8 = var9_10;
            }
        }
        Util.closeQuietly((Socket)var8_8);
        this.eventListener.connectionAcquired(this.call, (Connection)var11_12);
        return var11_12;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private RealConnection findHealthyConnection(int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws IOException {
        while (true) {
            RealConnection realConnection = this.findConnection(n, n2, n3, n4, bl);
            RealConnectionPool realConnectionPool = this.connectionPool;
            // MONITORENTER : realConnectionPool
            if (realConnection.successCount == 0 && !realConnection.isMultiplexed()) {
                // MONITOREXIT : realConnectionPool
                return realConnection;
            }
            // MONITOREXIT : realConnectionPool
            if (realConnection.isHealthy(bl2)) return realConnection;
            realConnection.noNewExchanges();
        }
    }

    private boolean retryCurrentRoute() {
        boolean bl = this.transmitter.connection != null && this.transmitter.connection.routeFailureCount == 0 && Util.sameConnection(this.transmitter.connection.route().address().url(), this.address.url());
        return bl;
    }

    RealConnection connectingConnection() {
        return this.connectingConnection;
    }

    public ExchangeCodec find(OkHttpClient object, Interceptor.Chain chain, boolean bl) {
        int n = chain.connectTimeoutMillis();
        int n2 = chain.readTimeoutMillis();
        int n3 = chain.writeTimeoutMillis();
        int n4 = ((OkHttpClient)object).pingIntervalMillis();
        boolean bl2 = ((OkHttpClient)object).retryOnConnectionFailure();
        try {
            object = this.findHealthyConnection(n, n2, n3, n4, bl2, bl).newCodec((OkHttpClient)object, chain);
            return object;
        }
        catch (IOException iOException) {
            this.trackFailure();
            throw new RouteException(iOException);
        }
        catch (RouteException routeException) {
            this.trackFailure();
            throw routeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasRouteToTry() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            Object object = this.nextRouteToTry;
            boolean bl = true;
            if (object != null) {
                return true;
            }
            if (this.retryCurrentRoute()) {
                this.nextRouteToTry = this.transmitter.connection.route();
                return true;
            }
            object = this.routeSelection;
            if (object != null) {
                boolean bl2 = bl;
                if (((RouteSelector.Selection)object).hasNext()) return bl2;
            }
            if (!this.routeSelector.hasNext()) return false;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasStreamFailure() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            return this.hasStreamFailure;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void trackFailure() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.hasStreamFailure = true;
            return;
        }
    }
}

