/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.Version;
import okhttp3.internal.connection.ConnectionSpecSelector;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2ExchangeCodec;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.internal.ws.RealWebSocket;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;

public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private int allocationLimit = 1;
    public final RealConnectionPool connectionPool;
    private Handshake handshake;
    private Http2Connection http2Connection;
    long idleAtNanos;
    boolean noNewExchanges;
    private Protocol protocol;
    private Socket rawSocket;
    private int refusedStreamCount;
    private final Route route;
    int routeFailureCount;
    private BufferedSink sink;
    private Socket socket;
    private BufferedSource source;
    int successCount;
    final List<Reference<Transmitter>> transmitters = new ArrayList<Reference<Transmitter>>();

    public RealConnection(RealConnectionPool realConnectionPool, Route route) {
        this.idleAtNanos = Long.MAX_VALUE;
        this.connectionPool = realConnectionPool;
        this.route = route;
    }

    private void connectSocket(int n, int n2, Call call, EventListener object) throws IOException {
        NullPointerException nullPointerException2;
        block4: {
            Proxy proxy = this.route.proxy();
            Object object2 = this.route.address();
            object2 = proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.HTTP ? new Socket(proxy) : ((Address)object2).socketFactory().createSocket();
            this.rawSocket = object2;
            ((EventListener)object).connectStart(call, this.route.socketAddress(), proxy);
            this.rawSocket.setSoTimeout(n2);
            try {
                Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n);
            }
            catch (ConnectException connectException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Failed to connect to ");
                ((StringBuilder)object).append(this.route.socketAddress());
                object = new ConnectException(((StringBuilder)object).toString());
                ((Throwable)object).initCause(connectException);
                throw object;
            }
            try {
                this.source = Okio.buffer(Okio.source(this.rawSocket));
                this.sink = Okio.buffer(Okio.sink(this.rawSocket));
            }
            catch (NullPointerException nullPointerException2) {
                if (NPE_THROW_WITH_NULL.equals(nullPointerException2.getMessage())) break block4;
            }
            return;
        }
        throw new IOException(nullPointerException2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectTls(ConnectionSpecSelector object) throws IOException {
        void var1_4;
        Object object2;
        block14: {
            Serializable serializable;
            Object object3;
            block15: {
                Address address = this.route.address();
                object3 = address.sslSocketFactory();
                object2 = null;
                ConnectionSpec connectionSpec = null;
                serializable = null;
                try {
                    object3 = (SSLSocket)((SSLSocketFactory)object3).createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
                }
                catch (Throwable throwable) {
                    break block14;
                }
                catch (AssertionError assertionError) {
                    object = connectionSpec;
                    break block15;
                }
                try {
                    connectionSpec = ((ConnectionSpecSelector)object).configureSecureSocket((SSLSocket)object3);
                    if (connectionSpec.supportsTlsExtensions()) {
                        Platform.get().configureTlsExtensions((SSLSocket)object3, address.url().host(), address.protocols());
                    }
                    ((SSLSocket)object3).startHandshake();
                    object = ((SSLSocket)object3).getSession();
                    object2 = Handshake.get((SSLSession)object);
                    if (!address.hostnameVerifier().verify(address.url().host(), (SSLSession)object)) {
                        object = ((Handshake)object2).peerCertificates();
                        boolean bl = object.isEmpty();
                        if (!bl) {
                            object2 = (X509Certificate)object.get(0);
                            serializable = new StringBuilder();
                            ((StringBuilder)serializable).append("Hostname ");
                            ((StringBuilder)serializable).append(address.url().host());
                            ((StringBuilder)serializable).append(" not verified:\n    certificate: ");
                            ((StringBuilder)serializable).append(CertificatePinner.pin((Certificate)object2));
                            ((StringBuilder)serializable).append("\n    DN: ");
                            ((StringBuilder)serializable).append(((X509Certificate)object2).getSubjectDN().getName());
                            ((StringBuilder)serializable).append("\n    subjectAltNames: ");
                            ((StringBuilder)serializable).append(OkHostnameVerifier.allSubjectAltNames((X509Certificate)object2));
                            object = new SSLPeerUnverifiedException(((StringBuilder)serializable).toString());
                            throw object;
                        }
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Hostname ");
                        ((StringBuilder)object2).append(address.url().host());
                        ((StringBuilder)object2).append(" not verified (no certificates)");
                        object = new SSLPeerUnverifiedException(((StringBuilder)object2).toString());
                        throw object;
                    }
                    address.certificatePinner().check(address.url().host(), ((Handshake)object2).peerCertificates());
                    object = serializable;
                    if (connectionSpec.supportsTlsExtensions()) {
                        object = Platform.get().getSelectedProtocol((SSLSocket)object3);
                    }
                    this.socket = object3;
                    this.source = Okio.buffer(Okio.source((Socket)object3));
                    this.sink = Okio.buffer(Okio.sink(this.socket));
                    this.handshake = object2;
                    object = object != null ? Protocol.get((String)object) : Protocol.HTTP_1_1;
                    this.protocol = object;
                    if (object3 != null) {
                        Platform.get().afterHandshake((SSLSocket)object3);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    object2 = object3;
                    break block14;
                }
                catch (AssertionError assertionError) {
                    object = object3;
                    object3 = assertionError;
                }
            }
            object2 = object;
            {
                if (Util.isAndroidGetsocknameError((AssertionError)object3)) {
                    object2 = object;
                    object2 = object;
                    serializable = new IOException((Throwable)object3);
                    object2 = object;
                    throw serializable;
                }
                object2 = object;
                throw object3;
            }
        }
        if (object2 != null) {
            Platform.get().afterHandshake((SSLSocket)object2);
        }
        Util.closeQuietly((Socket)object2);
        throw var1_4;
    }

    private void connectTunnel(int n, int n2, int n3, Call call, EventListener eventListener) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        for (int i = 0; i < 21; ++i) {
            this.connectSocket(n, n2, call, eventListener);
            request = this.createTunnel(n2, n3, request, httpUrl);
            if (request == null) break;
            Util.closeQuietly(this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), null);
        }
    }

    private Request createTunnel(int n, int n2, Request object, HttpUrl object2) throws IOException {
        block2: {
            Object object3;
            block3: {
                block4: {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("CONNECT ");
                    ((StringBuilder)object3).append(Util.hostHeader((HttpUrl)object2, true));
                    ((StringBuilder)object3).append(" HTTP/1.1");
                    object2 = ((StringBuilder)object3).toString();
                    do {
                        Http1ExchangeCodec http1ExchangeCodec = new Http1ExchangeCodec(null, null, this.source, this.sink);
                        this.source.timeout().timeout(n, TimeUnit.MILLISECONDS);
                        this.sink.timeout().timeout(n2, TimeUnit.MILLISECONDS);
                        http1ExchangeCodec.writeRequest(((Request)object).headers(), (String)object2);
                        http1ExchangeCodec.finishRequest();
                        object3 = http1ExchangeCodec.readResponseHeaders(false).request((Request)object).build();
                        http1ExchangeCodec.skipConnectBody((Response)object3);
                        int n3 = ((Response)object3).code();
                        if (n3 == 200) break block2;
                        if (n3 != 407) break block3;
                        object = this.route.address().proxyAuthenticator().authenticate(this.route, (Response)object3);
                        if (object == null) break block4;
                    } while (!"close".equalsIgnoreCase(((Response)object3).header("Connection")));
                    return object;
                }
                throw new IOException("Failed to authenticate with proxy");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unexpected response code for CONNECT: ");
            ((StringBuilder)object).append(((Response)object3).code());
            throw new IOException(((StringBuilder)object).toString());
        }
        if (this.source.getBuffer().exhausted() && this.sink.buffer().exhausted()) {
            return null;
        }
        throw new IOException("TLS tunnel buffered too many bytes!");
    }

    private Request createTunnelRequest() throws IOException {
        Object object = new Request.Builder().url(this.route.address().url()).method("CONNECT", null).header("Host", Util.hostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
        Object object2 = new Response.Builder().request((Request)object).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        object2 = this.route.address().proxyAuthenticator().authenticate(this.route, (Response)object2);
        if (object2 != null) {
            object = object2;
        }
        return object;
    }

    private void establishProtocol(ConnectionSpecSelector connectionSpecSelector, int n, Call call, EventListener eventListener) throws IOException {
        if (this.route.address().sslSocketFactory() == null) {
            if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                this.socket = this.rawSocket;
                this.protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                this.startHttp2(n);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        eventListener.secureConnectStart(call);
        this.connectTls(connectionSpecSelector);
        eventListener.secureConnectEnd(call, this.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(n);
        }
    }

    private boolean routeMatchesAny(List<Route> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Route route = list.get(i);
            if (route.proxy().type() != Proxy.Type.DIRECT || this.route.proxy().type() != Proxy.Type.DIRECT || !this.route.socketAddress().equals(route.socketAddress())) continue;
            return true;
        }
        return false;
    }

    private void startHttp2(int n) throws IOException {
        Http2Connection http2Connection;
        this.socket.setSoTimeout(0);
        this.http2Connection = http2Connection = new Http2Connection.Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).listener(this).pingIntervalMillis(n).build();
        http2Connection.start();
    }

    static RealConnection testConnection(RealConnectionPool object, Route route, Socket socket, long l) {
        object = new RealConnection((RealConnectionPool)object, route);
        ((RealConnection)object).socket = socket;
        ((RealConnection)object).idleAtNanos = l;
        return object;
    }

    public void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n, int n2, int n3, int n4, boolean bl, Call object, EventListener object2) {
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        Object object3 = this.route.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector((List<ConnectionSpec>)object3);
        if (this.route.address().sslSocketFactory() == null) {
            if (!object3.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            object3 = this.route.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted((String)object3)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("CLEARTEXT communication to ");
                ((StringBuilder)object).append((String)object3);
                ((StringBuilder)object).append(" not permitted by network security policy");
                throw new RouteException(new UnknownServiceException(((StringBuilder)object).toString()));
            }
        } else if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new RouteException(new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        }
        RouteException routeException = null;
        do {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            try {
                                if (!this.route.requiresTunnel()) break block18;
                                this.connectTunnel(n, n2, n3, (Call)object, (EventListener)object2);
                                object3 = this.rawSocket;
                                if (object3 != null) break block19;
                                break block20;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                                break block21;
                            }
                        }
                        try {
                            this.connectSocket(n, n2, (Call)object, (EventListener)object2);
                        }
                        catch (IOException iOException) {
                            break block21;
                        }
                    }
                    try {
                        this.establishProtocol(connectionSpecSelector, n4, (Call)object, (EventListener)object2);
                        ((EventListener)object2).connectEnd((Call)object, this.route.socketAddress(), this.route.proxy(), this.protocol);
                    }
                    catch (IOException iOException) {
                        break block21;
                    }
                }
                if (this.route.requiresTunnel() && this.rawSocket == null) {
                    throw new RouteException(new ProtocolException("Too many tunnel connections attempted: 21"));
                }
                if (this.http2Connection != null) {
                    object2 = this.connectionPool;
                    synchronized (object2) {
                        this.allocationLimit = this.http2Connection.maxConcurrentStreams();
                    }
                }
                return;
            }
            Util.closeQuietly(this.socket);
            Util.closeQuietly(this.rawSocket);
            this.socket = null;
            this.rawSocket = null;
            this.source = null;
            this.sink = null;
            this.handshake = null;
            this.protocol = null;
            this.http2Connection = null;
            ((EventListener)object2).connectFailed((Call)object, this.route.socketAddress(), this.route.proxy(), null, (IOException)object3);
            if (routeException == null) {
                routeException = new RouteException((IOException)object3);
                continue;
            }
            routeException.addConnectException((IOException)object3);
        } while (bl && connectionSpecSelector.connectionFailed((IOException)object3));
        throw routeException;
    }

    @Override
    public Handshake handshake() {
        return this.handshake;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isEligible(Address address, @Nullable List<Route> list) {
        if (this.transmitters.size() >= this.allocationLimit) return false;
        if (this.noNewExchanges) {
            return false;
        }
        if (!Internal.instance.equalsNonHost(this.route.address(), address)) {
            return false;
        }
        if (address.url().host().equals(this.route().address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (list == null) return false;
        if (!this.routeMatchesAny(list)) {
            return false;
        }
        if (address.hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
            return true;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHealthy(boolean bl) {
        int n;
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return http2Connection.isHealthy(System.nanoTime());
        }
        if (!bl) return true;
        try {
            n = this.socket.getSoTimeout();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        try {
            this.socket.setSoTimeout(1);
            bl = this.source.exhausted();
            if (!bl) return true;
            return false;
        }
        finally {
            this.socket.setSoTimeout(n);
        }
    }

    public boolean isMultiplexed() {
        boolean bl = this.http2Connection != null;
        return bl;
    }

    ExchangeCodec newCodec(OkHttpClient okHttpClient, Interceptor.Chain chain) throws SocketException {
        if (this.http2Connection != null) {
            return new Http2ExchangeCodec(okHttpClient, this, chain, this.http2Connection);
        }
        this.socket.setSoTimeout(chain.readTimeoutMillis());
        this.source.timeout().timeout(chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.sink.timeout().timeout(chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        return new Http1ExchangeCodec(okHttpClient, this, this.source, this.sink);
    }

    RealWebSocket.Streams newWebSocketStreams(final Exchange exchange) throws SocketException {
        this.socket.setSoTimeout(0);
        this.noNewExchanges();
        return new RealWebSocket.Streams(true, this.source, this.sink){

            @Override
            public void close() throws IOException {
                exchange.bodyComplete(-1L, true, true, null);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void noNewExchanges() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.noNewExchanges = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onSettings(Http2Connection http2Connection) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.allocationLimit = http2Connection.maxConcurrentStreams();
            return;
        }
    }

    @Override
    public void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.REFUSED_STREAM, null);
    }

    @Override
    public Protocol protocol() {
        return this.protocol;
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public Socket socket() {
        return this.socket;
    }

    public boolean supportsUrl(HttpUrl httpUrl) {
        int n = httpUrl.port();
        int n2 = this.route.address().url().port();
        boolean bl = false;
        if (n != n2) {
            return false;
        }
        if (!httpUrl.host().equals(this.route.address().url().host())) {
            boolean bl2 = bl;
            if (this.handshake != null) {
                bl2 = bl;
                if (OkHostnameVerifier.INSTANCE.verify(httpUrl.host(), (X509Certificate)this.handshake.peerCertificates().get(0))) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connection{");
        stringBuilder.append(this.route.address().url().host());
        stringBuilder.append(":");
        stringBuilder.append(this.route.address().url().port());
        stringBuilder.append(", proxy=");
        stringBuilder.append(this.route.proxy());
        stringBuilder.append(" hostAddress=");
        stringBuilder.append(this.route.socketAddress());
        stringBuilder.append(" cipherSuite=");
        Object object = this.handshake;
        object = object != null ? ((Handshake)object).cipherSuite() : "none";
        stringBuilder.append(object);
        stringBuilder.append(" protocol=");
        stringBuilder.append((Object)this.protocol);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void trackFailure(@Nullable IOException object) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            block10: {
                block9: {
                    if (!(object instanceof StreamResetException)) break block9;
                    object = ((StreamResetException)object).errorCode;
                    if (object == ErrorCode.REFUSED_STREAM) {
                        int n;
                        this.refusedStreamCount = n = this.refusedStreamCount + 1;
                        if (n > 1) {
                            this.noNewExchanges = true;
                            ++this.routeFailureCount;
                        }
                        break block10;
                    } else if (object != ErrorCode.CANCEL) {
                        this.noNewExchanges = true;
                        ++this.routeFailureCount;
                    }
                    break block10;
                }
                if (!this.isMultiplexed() || object instanceof ConnectionShutdownException) {
                    this.noNewExchanges = true;
                    if (this.successCount == 0) {
                        if (object != null) {
                            this.connectionPool.connectFailed(this.route, (IOException)object);
                        }
                        ++this.routeFailureCount;
                    }
                }
            }
            return;
        }
    }
}

