/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Address;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool$$ExternalSyntheticLambda0;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.platform.Platform;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RealConnectionPool {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final Executor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final Runnable cleanupRunnable = new RealConnectionPool$$ExternalSyntheticLambda0(this);
    boolean cleanupRunning;
    private final Deque<RealConnection> connections = new ArrayDeque<RealConnection>();
    private final long keepAliveDurationNs;
    private final int maxIdleConnections;
    final RouteDatabase routeDatabase = new RouteDatabase();

    public RealConnectionPool(int n, long l, TimeUnit object) {
        this.maxIdleConnections = n;
        this.keepAliveDurationNs = ((TimeUnit)((Object)object)).toNanos(l);
        if (l > 0L) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("keepAliveDuration <= 0: ");
        ((StringBuilder)object).append(l);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        List<Reference<Transmitter>> list = realConnection.transmitters;
        int n = 0;
        while (n < list.size()) {
            Transmitter.TransmitterReference transmitterReference = list.get(n);
            if (transmitterReference.get() != null) {
                ++n;
                continue;
            }
            transmitterReference = transmitterReference;
            CharSequence charSequence = new StringBuilder();
            charSequence.append("A connection to ");
            charSequence.append(realConnection.route().address().url());
            charSequence.append(" was leaked. Did you forget to close a response body?");
            charSequence = charSequence.toString();
            Platform.get().logCloseableLeak((String)charSequence, transmitterReference.callStackTrace);
            list.remove(n);
            realConnection.noNewExchanges = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long cleanup(long l) {
        RealConnection realConnection;
        synchronized (this) {
            Iterator<RealConnection> iterator2 = this.connections.iterator();
            realConnection = null;
            long l2 = Long.MIN_VALUE;
            int n = 0;
            int n2 = 0;
            while (iterator2.hasNext()) {
                RealConnection realConnection2 = iterator2.next();
                if (this.pruneAndGetAllocationCount(realConnection2, l) > 0) {
                    ++n2;
                    continue;
                }
                int n3 = n + 1;
                long l3 = l - realConnection2.idleAtNanos;
                n = n3;
                if (l3 <= l2) continue;
                realConnection = realConnection2;
                l2 = l3;
                n = n3;
            }
            l = this.keepAliveDurationNs;
            if (l2 < l && n <= this.maxIdleConnections) {
                if (n > 0) {
                    return l - l2;
                }
                if (n2 > 0) {
                    return l;
                }
                this.cleanupRunning = false;
                return -1L;
            }
            this.connections.remove(realConnection);
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }

    public void connectFailed(Route route, IOException iOException) {
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            Address address = route.address();
            address.proxySelector().connectFailed(address.url().uri(), route.proxy().address(), iOException);
        }
        this.routeDatabase.failed(route);
    }

    boolean connectionBecameIdle(RealConnection realConnection) {
        if (!realConnection.noNewExchanges && this.maxIdleConnections != 0) {
            this.notifyAll();
            return false;
        }
        this.connections.remove(realConnection);
        return true;
    }

    public int connectionCount() {
        synchronized (this) {
            int n = this.connections.size();
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evictAll() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        synchronized (this) {
            Iterator<RealConnection> iterator2 = this.connections.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (!((RealConnection)object).transmitters.isEmpty()) continue;
                ((RealConnection)object).noNewExchanges = true;
                arrayList.add(object);
                iterator2.remove();
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Util.closeQuietly(((RealConnection)object.next()).socket());
        }
        return;
    }

    public int idleConnectionCount() {
        synchronized (this) {
            int n = 0;
            Iterator<RealConnection> iterator2 = this.connections.iterator();
            while (iterator2.hasNext()) {
                boolean bl = iterator2.next().transmitters.isEmpty();
                if (!bl) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public /* synthetic */ void lambda$new$0$okhttp3-internal-connection-RealConnectionPool() {
        long l;
        while ((l = this.cleanup(System.nanoTime())) != -1L) {
            if (l <= 0L) continue;
            long l2 = l / 1000000L;
            synchronized (this) {
                int n = (int)(l - 1000000L * l2);
                try {
                    try {
                        this.wait(l2, n);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
        return;
    }

    void put(RealConnection realConnection) {
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    boolean transmitterAcquirePooledConnection(Address address, Transmitter transmitter, @Nullable List<Route> list, boolean bl) {
        for (RealConnection realConnection : this.connections) {
            if (bl && !realConnection.isMultiplexed() || !realConnection.isEligible(address, list)) continue;
            transmitter.acquireConnectionNoEvents(realConnection);
            return true;
        }
        return false;
    }
}

