/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteDatabase;

final class RouteSelector {
    private final Address address;
    private final Call call;
    private final EventListener eventListener;
    private List<InetSocketAddress> inetSocketAddresses;
    private int nextProxyIndex;
    private final List<Route> postponedRoutes;
    private List<Proxy> proxies = Collections.emptyList();
    private final RouteDatabase routeDatabase;

    RouteSelector(Address address, RouteDatabase routeDatabase, Call call, EventListener eventListener) {
        this.inetSocketAddresses = Collections.emptyList();
        this.postponedRoutes = new ArrayList<Route>();
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.call = call;
        this.eventListener = eventListener;
        this.resetNextProxy(address.url(), address.proxy());
    }

    static String getHostString(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return inetSocketAddress.getHostName();
        }
        return inetAddress.getHostAddress();
    }

    private boolean hasNextProxy() {
        boolean bl = this.nextProxyIndex < this.proxies.size();
        return bl;
    }

    private Proxy nextProxy() throws IOException {
        if (this.hasNextProxy()) {
            Object object = this.proxies;
            int n = this.nextProxyIndex;
            this.nextProxyIndex = n + 1;
            object = object.get(n);
            this.resetNextInetSocketAddress((Proxy)object);
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("No route to ");
        stringBuilder.append(this.address.url().host());
        stringBuilder.append("; exhausted proxy configurations: ");
        stringBuilder.append(this.proxies);
        throw new SocketException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetNextInetSocketAddress(Proxy object) throws IOException {
        int n;
        Object object2;
        this.inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (((Proxy)object).type() != Proxy.Type.DIRECT && ((Proxy)object).type() != Proxy.Type.SOCKS) {
            object2 = ((Proxy)object).address();
            if (!(object2 instanceof InetSocketAddress)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Proxy.address() is not an InetSocketAddress: ");
                ((StringBuilder)object).append(object2.getClass());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object2;
            object2 = RouteSelector.getHostString(inetSocketAddress);
            n = inetSocketAddress.getPort();
        } else {
            object2 = this.address.url().host();
            n = this.address.url().port();
        }
        if (n >= 1 && n <= 65535) {
            if (((Proxy)object).type() == Proxy.Type.SOCKS) {
                this.inetSocketAddresses.add(InetSocketAddress.createUnresolved((String)object2, n));
                return;
            }
            this.eventListener.dnsStart(this.call, (String)object2);
            object = this.address.dns().lookup((String)object2);
            if (object.isEmpty()) {
                object = new StringBuilder();
                ((StringBuilder)object).append(this.address.dns());
                ((StringBuilder)object).append(" returned no addresses for ");
                ((StringBuilder)object).append((String)object2);
                throw new UnknownHostException(((StringBuilder)object).toString());
            }
            this.eventListener.dnsEnd(this.call, (String)object2, (List<InetAddress>)object);
            int n2 = 0;
            int n3 = object.size();
            while (n2 < n3) {
                object2 = (InetAddress)object.get(n2);
                this.inetSocketAddresses.add(new InetSocketAddress((InetAddress)object2, n));
                ++n2;
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No route to ");
        ((StringBuilder)object).append((String)object2);
        ((StringBuilder)object).append(":");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("; port is out of range");
        throw new SocketException(((StringBuilder)object).toString());
    }

    private void resetNextProxy(HttpUrl list, Proxy proxy) {
        if (proxy != null) {
            this.proxies = Collections.singletonList(proxy);
        } else {
            list = this.address.proxySelector().select(((HttpUrl)((Object)list)).uri());
            list = list != null && !list.isEmpty() ? Util.immutableList(list) : Util.immutableList(Proxy.NO_PROXY);
            this.proxies = list;
        }
        this.nextProxyIndex = 0;
    }

    public boolean hasNext() {
        boolean bl = this.hasNextProxy() || !this.postponedRoutes.isEmpty();
        return bl;
    }

    public Selection next() throws IOException {
        if (this.hasNext()) {
            ArrayList<Route> arrayList = new ArrayList<Route>();
            while (this.hasNextProxy()) {
                Proxy proxy = this.nextProxy();
                int n = this.inetSocketAddresses.size();
                for (int i = 0; i < n; ++i) {
                    Route route = new Route(this.address, proxy, this.inetSocketAddresses.get(i));
                    if (this.routeDatabase.shouldPostpone(route)) {
                        this.postponedRoutes.add(route);
                        continue;
                    }
                    arrayList.add(route);
                }
                if (arrayList.isEmpty()) continue;
            }
            if (arrayList.isEmpty()) {
                arrayList.addAll(this.postponedRoutes);
                this.postponedRoutes.clear();
            }
            return new Selection(arrayList);
        }
        throw new NoSuchElementException();
    }

    public static final class Selection {
        private int nextRouteIndex = 0;
        private final List<Route> routes;

        Selection(List<Route> list) {
            this.routes = list;
        }

        public List<Route> getAll() {
            return new ArrayList<Route>(this.routes);
        }

        public boolean hasNext() {
            boolean bl = this.nextRouteIndex < this.routes.size();
            return bl;
        }

        public Route next() {
            if (this.hasNext()) {
                List<Route> list = this.routes;
                int n = this.nextRouteIndex;
                this.nextRouteIndex = n + 1;
                return list.get(n);
            }
            throw new NoSuchElementException();
        }
    }
}

