/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import okio.Timeout;

public final class Transmitter {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private final Call call;
    @Nullable
    private Object callStackTrace;
    private boolean canceled;
    private final OkHttpClient client;
    public RealConnection connection;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    @Nullable
    private Exchange exchange;
    private ExchangeFinder exchangeFinder;
    private boolean exchangeRequestDone;
    private boolean exchangeResponseDone;
    private boolean noMoreExchanges;
    private Request request;
    private final AsyncTimeout timeout;
    private boolean timeoutEarlyExit;

    public Transmitter(OkHttpClient okHttpClient, Call call) {
        AsyncTimeout asyncTimeout;
        this.timeout = asyncTimeout = new AsyncTimeout(){

            @Override
            protected void timedOut() {
                Transmitter.this.cancel();
            }
        };
        this.client = okHttpClient;
        this.connectionPool = Internal.instance.realConnectionPool(okHttpClient.connectionPool());
        this.call = call;
        this.eventListener = okHttpClient.eventListenerFactory().create(call);
        asyncTimeout.timeout(okHttpClient.callTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    private Address createAddress(HttpUrl httpUrl) {
        Object object;
        Object object2;
        SSLSocketFactory sSLSocketFactory;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            object2 = this.client.hostnameVerifier();
            object = this.client.certificatePinner();
        } else {
            sSLSocketFactory = null;
            object = object2 = sSLSocketFactory;
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, (HostnameVerifier)object2, (CertificatePinner)object, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private IOException maybeReleaseConnection(@Nullable IOException exception, boolean bl) {
        boolean bl2;
        boolean bl3;
        Object object;
        RealConnection realConnection;
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (bl && this.exchange != null) {
                exception = new IllegalStateException("cannot release connection while it is in use");
                throw exception;
            }
            realConnection = this.connection;
            object = realConnection != null && this.exchange == null && (bl || this.noMoreExchanges) ? this.releaseConnectionNoEvents() : null;
            if (this.connection != null) {
                realConnection = null;
            }
            bl = this.noMoreExchanges;
            bl3 = true;
            bl2 = bl && this.exchange == null;
        }
        Util.closeQuietly((Socket)object);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
        object = exception;
        if (!bl2) return object;
        bl2 = exception != null ? bl3 : false;
        object = this.timeoutExit((IOException)exception);
        if (bl2) {
            this.eventListener.callFailed(this.call, (IOException)object);
            return object;
        }
        this.eventListener.callEnd(this.call);
        return object;
    }

    @Nullable
    private IOException timeoutExit(@Nullable IOException iOException) {
        if (this.timeoutEarlyExit) {
            return iOException;
        }
        if (!this.timeout.exit()) {
            return iOException;
        }
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    void acquireConnectionNoEvents(RealConnection realConnection) {
        if (this.connection == null) {
            this.connection = realConnection;
            realConnection.transmitters.add(new TransmitterReference(this, this.callStackTrace));
            return;
        }
        throw new IllegalStateException();
    }

    public void callStart() {
        this.callStackTrace = Platform.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this.call);
    }

    public boolean canRetry() {
        boolean bl = this.exchangeFinder.hasStreamFailure() && this.exchangeFinder.hasRouteToTry();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void cancel() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        // MONITORENTER : realConnectionPool
        this.canceled = true;
        Exchange exchange = this.exchange;
        Object object = this.exchangeFinder;
        object = object != null && ((ExchangeFinder)object).connectingConnection() != null ? this.exchangeFinder.connectingConnection() : this.connection;
        // MONITOREXIT : realConnectionPool
        if (exchange != null) {
            exchange.cancel();
            return;
        }
        if (object == null) return;
        ((RealConnection)object).cancel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exchangeDoneDueToException() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (!this.noMoreExchanges) {
                this.exchange = null;
                return;
            }
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    IOException exchangeMessageDone(Exchange object, boolean bl, boolean bl2, @Nullable IOException iOException) {
        boolean bl3;
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            Exchange exchange = this.exchange;
            if (object != exchange) {
                return iOException;
            }
            boolean bl4 = true;
            if (bl) {
                bl3 = this.exchangeRequestDone ^ true;
                this.exchangeRequestDone = true;
            } else {
                bl3 = false;
            }
            boolean bl5 = bl3;
            if (bl2) {
                if (!this.exchangeResponseDone) {
                    bl3 = true;
                }
                this.exchangeResponseDone = true;
                bl5 = bl3;
            }
            if (this.exchangeRequestDone && this.exchangeResponseDone && bl5) {
                object = exchange.connection();
                ++((RealConnection)object).successCount;
                this.exchange = null;
                bl3 = bl4;
            } else {
                bl3 = false;
            }
        }
        object = iOException;
        if (!bl3) return object;
        return this.maybeReleaseConnection(iOException, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasExchange() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (this.exchange == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCanceled() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            return this.canceled;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Exchange newExchange(Interceptor.Chain object, boolean bl) {
        Object object2 = this.connectionPool;
        synchronized (object2) {
            if (this.noMoreExchanges) {
                object = new IllegalStateException("released");
                throw object;
            }
            if (this.exchange == null) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                object = this.exchangeFinder.find(this.client, (Interceptor.Chain)object, bl);
                object2 = new Exchange(this, this.call, this.eventListener, this.exchangeFinder, (ExchangeCodec)object);
                object = this.connectionPool;
                synchronized (object) {
                    this.exchange = object2;
                    this.exchangeRequestDone = false;
                    this.exchangeResponseDone = false;
                    return object2;
                }
            }
            object = new IllegalStateException("cannot make a new request because the previous response is still open: please call response.close()");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IOException noMoreExchanges(@Nullable IOException iOException) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.noMoreExchanges = true;
            return this.maybeReleaseConnection(iOException, false);
        }
    }

    public void prepareToConnect(Request request) {
        Request request2 = this.request;
        if (request2 != null) {
            if (Util.sameConnection(request2.url(), request.url()) && this.exchangeFinder.hasRouteToTry()) {
                return;
            }
            if (this.exchange == null) {
                if (this.exchangeFinder != null) {
                    this.maybeReleaseConnection(null, true);
                    this.exchangeFinder = null;
                }
            } else {
                throw new IllegalStateException();
            }
        }
        this.request = request;
        this.exchangeFinder = new ExchangeFinder(this, this.connectionPool, this.createAddress(request.url()), this.call, this.eventListener);
    }

    @Nullable
    Socket releaseConnectionNoEvents() {
        int n;
        block5: {
            int n2 = this.connection.transmitters.size();
            for (n = 0; n < n2; ++n) {
                if (this.connection.transmitters.get(n).get() != this) {
                    continue;
                }
                break block5;
            }
            n = -1;
        }
        if (n != -1) {
            RealConnection realConnection = this.connection;
            realConnection.transmitters.remove(n);
            Socket socket = null;
            this.connection = null;
            Socket socket2 = socket;
            if (realConnection.transmitters.isEmpty()) {
                realConnection.idleAtNanos = System.nanoTime();
                socket2 = socket;
                if (this.connectionPool.connectionBecameIdle(realConnection)) {
                    socket2 = realConnection.socket();
                }
            }
            return socket2;
        }
        throw new IllegalStateException();
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public void timeoutEarlyExit() {
        if (!this.timeoutEarlyExit) {
            this.timeoutEarlyExit = true;
            this.timeout.exit();
            return;
        }
        throw new IllegalStateException();
    }

    public void timeoutEnter() {
        this.timeout.enter();
    }

    static final class TransmitterReference
    extends WeakReference<Transmitter> {
        final Object callStackTrace;

        TransmitterReference(Transmitter transmitter, Object object) {
            super(transmitter);
            this.callStackTrace = object;
        }
    }
}

