/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.ByteString;

public final class HttpHeaders {
    private static final ByteString QUOTED_STRING_DELIMITERS = ByteString.encodeUtf8("\"\\");
    private static final ByteString TOKEN_DELIMITERS = ByteString.encodeUtf8("\t ,=");

    private HttpHeaders() {
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n = response.code();
        if ((n < 100 || n >= 200) && n != 204 && n != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
        {
        }
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    /*
     * Exception decompiling
     */
    private static void parseChallengeHeader(List<Challenge> var0, Buffer var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Challenge> parseChallenges(Headers headers, String string2) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        for (int i = 0; i < headers.size(); ++i) {
            if (!string2.equalsIgnoreCase(headers.name(i))) continue;
            HttpHeaders.parseChallengeHeader(arrayList, new Buffer().writeUtf8(headers.value(i)));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseSeconds(String string2, int n) {
        try {
            long l = Long.parseLong(string2);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l >= 0L) return (int)l;
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private static String readQuotedString(Buffer buffer) {
        if (buffer.readByte() == 34) {
            Buffer buffer2 = new Buffer();
            while (true) {
                long l;
                if ((l = buffer.indexOfElement(QUOTED_STRING_DELIMITERS)) == -1L) {
                    return null;
                }
                if (buffer.getByte(l) == 34) {
                    buffer2.write(buffer, l);
                    buffer.readByte();
                    return buffer2.readUtf8();
                }
                if (buffer.size() == l + 1L) {
                    return null;
                }
                buffer2.write(buffer, l);
                buffer.readByte();
                buffer2.write(buffer, 1L);
            }
        }
        throw new IllegalArgumentException();
    }

    private static String readToken(Buffer object) {
        long l;
        block6: {
            try {
                long l2;
                l = l2 = ((Buffer)object).indexOfElement(TOKEN_DELIMITERS);
                if (l2 != -1L) break block6;
            }
            catch (EOFException eOFException) {
                throw new AssertionError();
            }
            l = ((Buffer)object).size();
        }
        if (l != 0L) {
            object = ((Buffer)object).readUtf8(l);
        } else {
            object = null;
        }
        return object;
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers object) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        if ((object = Cookie.parseAll(httpUrl, (Headers)object)).isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, (List<Cookie>)object);
    }

    private static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    private static int skipAll(Buffer buffer, byte by) {
        int n = 0;
        while (!buffer.exhausted() && buffer.getByte(0L) == by) {
            ++n;
            buffer.readByte();
        }
        return n;
    }

    public static int skipUntil(String string2, int n, String string3) {
        while (n < string2.length() && string3.indexOf(string2.charAt(n)) == -1) {
            ++n;
        }
        return n;
    }

    public static int skipWhitespace(String string2, int n) {
        char c;
        while (n < string2.length() && ((c = string2.charAt(n)) == ' ' || c == '\t')) {
            ++n;
        }
        return n;
    }

    private static boolean skipWhitespaceAndCommas(Buffer buffer) {
        boolean bl = false;
        while (!buffer.exhausted()) {
            byte by = buffer.getByte(0L);
            if (by == 44) {
                buffer.readByte();
                bl = true;
                continue;
            }
            if (by != 32 && by != 9) break;
            buffer.readByte();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long stringToLong(String string2) {
        long l = -1L;
        if (string2 == null) {
            return -1L;
        }
        try {
            long l2 = Long.parseLong(string2);
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n = headers.size();
        block0: for (int i = 0; i < n; ++i) {
            if (!"Vary".equalsIgnoreCase(headers.name(i))) continue;
            String[] stringArray = headers.value(i);
            Set<String> set2 = set;
            if (set.isEmpty()) {
                set2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            stringArray = stringArray.split(",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (true) {
                set = set2;
                if (n3 >= n2) continue block0;
                set2.add(stringArray[n3].trim());
                ++n3;
            }
        }
        return set;
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Headers varyHeaders(Headers headers, Headers object) {
        Set<String> set = HttpHeaders.varyFields((Headers)object);
        if (set.isEmpty()) {
            return Util.EMPTY_HEADERS;
        }
        object = new Headers.Builder();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string2 = headers.name(i);
            if (!set.contains(string2)) continue;
            ((Headers.Builder)object).add(string2, headers.value(i));
        }
        return ((Headers.Builder)object).build();
    }

    public static Headers varyHeaders(Response response) {
        return HttpHeaders.varyHeaders(response.networkResponse().request().headers(), response.headers());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean varyMatches(Response object2, Headers headers, Request request) {
        for (String string2 : HttpHeaders.varyFields((Response)object2)) {
            void var2_4;
            void var1_3;
            if (Objects.equals(var1_3.values(string2), var2_4.headers(string2))) continue;
            return false;
        }
        return true;
    }
}

