/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.Transmitter;

public final class RealInterceptorChain
implements Interceptor.Chain {
    private final Call call;
    private int calls;
    private final int connectTimeout;
    @Nullable
    private final Exchange exchange;
    private final int index;
    private final List<Interceptor> interceptors;
    private final int readTimeout;
    private final Request request;
    private final Transmitter transmitter;
    private final int writeTimeout;

    public RealInterceptorChain(List<Interceptor> list, Transmitter transmitter, @Nullable Exchange exchange, int n, Request request, Call call, int n2, int n3, int n4) {
        this.interceptors = list;
        this.transmitter = transmitter;
        this.exchange = exchange;
        this.index = n;
        this.request = request;
        this.call = call;
        this.connectTimeout = n2;
        this.readTimeout = n3;
        this.writeTimeout = n4;
    }

    @Override
    public Call call() {
        return this.call;
    }

    @Override
    public int connectTimeoutMillis() {
        return this.connectTimeout;
    }

    @Override
    @Nullable
    public Connection connection() {
        Object object = this.exchange;
        object = object != null ? ((Exchange)object).connection() : null;
        return object;
    }

    public Exchange exchange() {
        Exchange exchange = this.exchange;
        if (exchange != null) {
            return exchange;
        }
        throw new IllegalStateException();
    }

    @Override
    public Response proceed(Request request) throws IOException {
        return this.proceed(request, this.transmitter, this.exchange);
    }

    public Response proceed(Request object, Transmitter object2, @Nullable Exchange exchange) throws IOException {
        if (this.index < this.interceptors.size()) {
            ++this.calls;
            Object object3 = this.exchange;
            if (object3 != null && !((Exchange)object3).connection().supportsUrl(((Request)object).url())) {
                object = new StringBuilder();
                ((StringBuilder)object).append("network interceptor ");
                ((StringBuilder)object).append(this.interceptors.get(this.index - 1));
                ((StringBuilder)object).append(" must retain the same host and port");
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
            if (this.exchange != null && this.calls > 1) {
                object = new StringBuilder();
                ((StringBuilder)object).append("network interceptor ");
                ((StringBuilder)object).append(this.interceptors.get(this.index - 1));
                ((StringBuilder)object).append(" must call proceed() exactly once");
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
            object2 = new RealInterceptorChain(this.interceptors, (Transmitter)object2, exchange, this.index + 1, (Request)object, this.call, this.connectTimeout, this.readTimeout, this.writeTimeout);
            object = this.interceptors.get(this.index);
            object3 = object.intercept((Interceptor.Chain)object2);
            if (exchange != null && this.index + 1 < this.interceptors.size() && ((RealInterceptorChain)object2).calls != 1) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("network interceptor ");
                ((StringBuilder)object2).append(object);
                ((StringBuilder)object2).append(" must call proceed() exactly once");
                throw new IllegalStateException(((StringBuilder)object2).toString());
            }
            if (object3 != null) {
                if (((Response)object3).body() != null) {
                    return object3;
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("interceptor ");
                ((StringBuilder)object2).append(object);
                ((StringBuilder)object2).append(" returned a response with no body");
                throw new IllegalStateException(((StringBuilder)object2).toString());
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("interceptor ");
            ((StringBuilder)object2).append(object);
            ((StringBuilder)object2).append(" returned null");
            throw new NullPointerException(((StringBuilder)object2).toString());
        }
        throw new AssertionError();
    }

    @Override
    public int readTimeoutMillis() {
        return this.readTimeout;
    }

    @Override
    public Request request() {
        return this.request;
    }

    public Transmitter transmitter() {
        return this.transmitter;
    }

    @Override
    public Interceptor.Chain withConnectTimeout(int n, TimeUnit timeUnit) {
        n = Util.checkDuration("timeout", n, timeUnit);
        return new RealInterceptorChain(this.interceptors, this.transmitter, this.exchange, this.index, this.request, this.call, n, this.readTimeout, this.writeTimeout);
    }

    @Override
    public Interceptor.Chain withReadTimeout(int n, TimeUnit timeUnit) {
        n = Util.checkDuration("timeout", n, timeUnit);
        return new RealInterceptorChain(this.interceptors, this.transmitter, this.exchange, this.index, this.request, this.call, this.connectTimeout, n, this.writeTimeout);
    }

    @Override
    public Interceptor.Chain withWriteTimeout(int n, TimeUnit timeUnit) {
        n = Util.checkDuration("timeout", n, timeUnit);
        return new RealInterceptorChain(this.interceptors, this.transmitter, this.exchange, this.index, this.request, this.call, this.connectTimeout, this.readTimeout, n);
    }

    @Override
    public int writeTimeoutMillis() {
        return this.writeTimeout;
    }
}

