/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.HttpMethod;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    private Request followUpRequest(Response response, @Nullable Route object) throws IOException {
        block23: {
            Proxy proxy;
            String string2;
            block29: {
                block24: {
                    block25: {
                        block26: {
                            block27: {
                                block28: {
                                    if (response == null) break block23;
                                    int n = response.code();
                                    string2 = response.request().method();
                                    proxy = null;
                                    if (n == 307 || n == 308) break block24;
                                    if (n == 401) break block25;
                                    if (n == 503) break block26;
                                    if (n == 407) break block27;
                                    if (n == 408) break block28;
                                    switch (n) {
                                        default: {
                                            return null;
                                        }
                                        case 300: 
                                        case 301: 
                                        case 302: 
                                        case 303: {
                                            if (this.client.followRedirects()) break block29;
                                        }
                                    }
                                }
                                if (!this.client.retryOnConnectionFailure()) {
                                    return null;
                                }
                                object = response.request().body();
                                if (object != null && ((RequestBody)object).isOneShot()) {
                                    return null;
                                }
                                if (response.priorResponse() != null && response.priorResponse().code() == 408) {
                                    return null;
                                }
                                if (this.retryAfter(response, 0) > 0) {
                                    return null;
                                }
                                return response.request();
                            }
                            proxy = object != null ? ((Route)object).proxy() : this.client.proxy();
                            if (proxy.type() == Proxy.Type.HTTP) {
                                return this.client.proxyAuthenticator().authenticate((Route)object, response);
                            }
                            throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                        }
                        if (response.priorResponse() != null && response.priorResponse().code() == 503) {
                            return null;
                        }
                        if (this.retryAfter(response, Integer.MAX_VALUE) == 0) {
                            return response.request();
                        }
                        return null;
                    }
                    return this.client.authenticator().authenticate((Route)object, response);
                }
                if (!string2.equals("GET") && !string2.equals("HEAD")) {
                    return null;
                }
                if (this.client.followRedirects()) break block29;
                return null;
            }
            if ((object = response.header("Location")) == null) {
                return null;
            }
            HttpUrl httpUrl = response.request().url().resolve((String)object);
            if (httpUrl == null) {
                return null;
            }
            if (!httpUrl.scheme().equals(response.request().url().scheme()) && !this.client.followSslRedirects()) {
                return null;
            }
            Request.Builder builder = response.request().newBuilder();
            if (HttpMethod.permitsRequestBody(string2)) {
                boolean bl = HttpMethod.redirectsWithBody(string2);
                if (HttpMethod.redirectsToGet(string2)) {
                    builder.method("GET", null);
                } else {
                    object = proxy;
                    if (bl) {
                        object = response.request().body();
                    }
                    builder.method(string2, (RequestBody)object);
                }
                if (!bl) {
                    builder.removeHeader("Transfer-Encoding");
                    builder.removeHeader("Content-Length");
                    builder.removeHeader("Content-Type");
                }
            }
            if (!Util.sameConnection(response.request().url(), httpUrl)) {
                builder.removeHeader("Authorization");
            }
            return builder.url(httpUrl).build();
        }
        throw new IllegalStateException();
    }

    private boolean isRecoverable(IOException iOException, boolean bl) {
        boolean bl2 = iOException instanceof ProtocolException;
        boolean bl3 = false;
        if (bl2) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            bl2 = bl3;
            if (iOException instanceof SocketTimeoutException) {
                bl2 = bl3;
                if (!bl) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private boolean recover(IOException iOException, Transmitter transmitter, boolean bl, Request request) {
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && this.requestIsOneShot(iOException, request)) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl)) {
            return false;
        }
        return transmitter.canRetry();
    }

    private boolean requestIsOneShot(IOException iOException, Request object) {
        boolean bl = (object = ((Request)object).body()) != null && ((RequestBody)object).isOneShot() || iOException instanceof FileNotFoundException;
        return bl;
    }

    private int retryAfter(Response object, int n) {
        if ((object = ((Response)object).header("Retry-After")) == null) {
            return n;
        }
        if (((String)object).matches("\\d+")) {
            return Integer.valueOf((String)object);
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response intercept(Interceptor.Chain var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 239->246)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

