/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http1ExchangeCodec
implements ExchangeCodec {
    private static final int HEADER_LIMIT = 262144;
    private static final int STATE_CLOSED = 6;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private final OkHttpClient client;
    private long headerLimit = 262144L;
    private final RealConnection realConnection;
    private final BufferedSink sink;
    private final BufferedSource source;
    private int state = 0;
    private Headers trailers;

    public Http1ExchangeCodec(OkHttpClient okHttpClient, RealConnection realConnection, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.client = okHttpClient;
        this.realConnection = realConnection;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    static /* synthetic */ int access$402(Http1ExchangeCodec http1ExchangeCodec, int n) {
        http1ExchangeCodec.state = n;
        return n;
    }

    static /* synthetic */ Headers access$802(Http1ExchangeCodec http1ExchangeCodec, Headers headers) {
        http1ExchangeCodec.trailers = headers;
        return headers;
    }

    private void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    private Sink newChunkedSink() {
        if (this.state == 1) {
            this.state = 2;
            return new ChunkedSink();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private Source newChunkedSource(HttpUrl object) {
        if (this.state == 4) {
            this.state = 5;
            return new ChunkedSource((HttpUrl)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("state: ");
        ((StringBuilder)object).append(this.state);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    private Source newFixedLengthSource(long l) {
        if (this.state == 4) {
            this.state = 5;
            return new FixedLengthSource(l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private Sink newKnownLengthSink() {
        if (this.state == 1) {
            this.state = 2;
            return new KnownLengthSink();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private Source newUnknownLengthSource() {
        if (this.state == 4) {
            this.state = 5;
            this.realConnection.noNewExchanges();
            return new UnknownLengthSource();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private String readHeaderLine() throws IOException {
        String string2 = this.source.readUtf8LineStrict(this.headerLimit);
        this.headerLimit -= (long)string2.length();
        return string2;
    }

    private Headers readHeaders() throws IOException {
        String string2;
        Headers.Builder builder = new Headers.Builder();
        while ((string2 = this.readHeaderLine()).length() != 0) {
            Internal.instance.addLenient(builder, string2);
        }
        return builder.build();
    }

    @Override
    public void cancel() {
        RealConnection realConnection = this.realConnection;
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    @Override
    public RealConnection connection() {
        return this.realConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long l) throws IOException {
        if (request.body() != null && request.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l != -1L) {
            return this.newKnownLengthSink();
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    @Override
    public void flushRequest() throws IOException {
        this.sink.flush();
    }

    public boolean isClosed() {
        boolean bl = this.state == 6;
        return bl;
    }

    @Override
    public Source openResponseBodySource(Response response) {
        if (!HttpHeaders.hasBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return this.newChunkedSource(response.request().url());
        }
        long l = HttpHeaders.contentLength(response);
        if (l != -1L) {
            return this.newFixedLengthSource(l);
        }
        return this.newUnknownLengthSource();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Response.Builder builder;
        block7: {
            Object object;
            block6: {
                int n = this.state;
                if (n != 1 && n != 3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("state: ");
                    stringBuilder.append(this.state);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                try {
                    object = StatusLine.parse(this.readHeaderLine());
                    builder = new Response.Builder();
                    builder = builder.protocol(((StatusLine)object).protocol).code(((StatusLine)object).code).message(((StatusLine)object).message).headers(this.readHeaders());
                    if (!bl) break block6;
                }
                catch (EOFException eOFException) {
                    object = this.realConnection;
                    object = object != null ? ((RealConnection)object).route().address().url().redact() : "unknown";
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("unexpected end of stream on ");
                    stringBuilder.append((String)object);
                    throw new IOException(stringBuilder.toString(), eOFException);
                }
                if (((StatusLine)object).code != 100) break block6;
                return null;
            }
            if (((StatusLine)object).code != 100) break block7;
            this.state = 3;
            return builder;
        }
        this.state = 4;
        return builder;
    }

    @Override
    public long reportedContentLength(Response response) {
        if (!HttpHeaders.hasBody(response)) {
            return 0L;
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return -1L;
        }
        return HttpHeaders.contentLength(response);
    }

    public void skipConnectBody(Response closeable) throws IOException {
        long l = HttpHeaders.contentLength((Response)closeable);
        if (l == -1L) {
            return;
        }
        closeable = this.newFixedLengthSource(l);
        Util.skipAll((Source)closeable, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        closeable.close();
    }

    @Override
    public Headers trailers() {
        if (this.state == 6) {
            Headers headers = this.trailers;
            if (headers == null) {
                headers = Util.EMPTY_HEADERS;
            }
            return headers;
        }
        throw new IllegalStateException("too early; can't read the trailers yet");
    }

    public void writeRequest(Headers object, String string2) throws IOException {
        if (this.state == 0) {
            this.sink.writeUtf8(string2).writeUtf8("\r\n");
            int n = ((Headers)object).size();
            for (int i = 0; i < n; ++i) {
                this.sink.writeUtf8(((Headers)object).name(i)).writeUtf8(": ").writeUtf8(((Headers)object).value(i)).writeUtf8("\r\n");
            }
            this.sink.writeUtf8("\r\n");
            this.state = 1;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("state: ");
        ((StringBuilder)object).append(this.state);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        String string2 = RequestLine.get(request, this.realConnection.route().proxy().type());
        this.writeRequest(request.headers(), string2);
    }

    private abstract class AbstractSource
    implements Source {
        protected boolean closed;
        protected final ForwardingTimeout timeout;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.source.timeout());
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            try {
                l = Http1ExchangeCodec.this.source.read(buffer, l);
                return l;
            }
            catch (IOException iOException) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                this.responseBodyComplete();
                throw iOException;
            }
        }

        final void responseBodyComplete() {
            if (Http1ExchangeCodec.this.state == 6) {
                return;
            }
            if (Http1ExchangeCodec.this.state == 5) {
                Http1ExchangeCodec.this.detachTimeout(this.timeout);
                Http1ExchangeCodec.access$402(Http1ExchangeCodec.this, 6);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("state: ");
            stringBuilder.append(Http1ExchangeCodec.this.state);
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }

    private final class ChunkedSink
    implements Sink {
        private boolean closed;
        private final ForwardingTimeout timeout;

        ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        public void close() throws IOException {
            synchronized (this) {
                block4: {
                    boolean bl = this.closed;
                    if (!bl) break block4;
                    return;
                }
                this.closed = true;
                Http1ExchangeCodec.this.sink.writeUtf8("0\r\n\r\n");
                Http1ExchangeCodec.this.detachTimeout(this.timeout);
                Http1ExchangeCodec.access$402(Http1ExchangeCodec.this, 3);
                return;
            }
        }

        @Override
        public void flush() throws IOException {
            synchronized (this) {
                block4: {
                    boolean bl = this.closed;
                    if (!bl) break block4;
                    return;
                }
                Http1ExchangeCodec.this.sink.flush();
                return;
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (!this.closed) {
                if (l == 0L) {
                    return;
                }
                Http1ExchangeCodec.this.sink.writeHexadecimalUnsignedLong(l);
                Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
                Http1ExchangeCodec.this.sink.write(buffer, l);
                Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
                return;
            }
            throw new IllegalStateException("closed");
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private long bytesRemainingInChunk = -1L;
        private boolean hasMoreChunks = true;
        private final HttpUrl url;

        ChunkedSource(HttpUrl httpUrl) {
            this.url = httpUrl;
        }

        private void readChunkSize() throws IOException {
            Object object;
            block4: {
                block5: {
                    if (this.bytesRemainingInChunk != -1L) {
                        Http1ExchangeCodec.this.source.readUtf8LineStrict();
                    }
                    try {
                        boolean bl;
                        this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                        object = Http1ExchangeCodec.this.source.readUtf8LineStrict().trim();
                        if (this.bytesRemainingInChunk < 0L || !((String)object).isEmpty() && !(bl = ((String)object).startsWith(";"))) break block4;
                        if (this.bytesRemainingInChunk != 0L) break block5;
                        this.hasMoreChunks = false;
                        object = Http1ExchangeCodec.this;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException(numberFormatException.getMessage());
                    }
                    Http1ExchangeCodec.access$802((Http1ExchangeCodec)object, ((Http1ExchangeCodec)object).readHeaders());
                    HttpHeaders.receiveHeaders(Http1ExchangeCodec.this.client.cookieJar(), this.url, Http1ExchangeCodec.this.trailers);
                    this.responseBodyComplete();
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("expected chunk size and optional extensions but was \"");
            stringBuilder.append(this.bytesRemainingInChunk);
            stringBuilder.append((String)object);
            stringBuilder.append("\"");
            ProtocolException protocolException = new ProtocolException(stringBuilder.toString());
            throw protocolException;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                this.responseBodyComplete();
            }
            this.closed = true;
        }

        @Override
        public long read(Buffer object, long l) throws IOException {
            if (l >= 0L) {
                if (!this.closed) {
                    if (!this.hasMoreChunks) {
                        return -1L;
                    }
                    long l2 = this.bytesRemainingInChunk;
                    if (l2 == 0L || l2 == -1L) {
                        this.readChunkSize();
                        if (!this.hasMoreChunks) {
                            return -1L;
                        }
                    }
                    if ((l = super.read((Buffer)object, Math.min(l, this.bytesRemainingInChunk))) != -1L) {
                        this.bytesRemainingInChunk -= l;
                        return l;
                    }
                    Http1ExchangeCodec.this.realConnection.noNewExchanges();
                    object = new ProtocolException("unexpected end of stream");
                    this.responseBodyComplete();
                    throw object;
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        FixedLengthSource(long l) {
            this.bytesRemaining = l;
            if (l == 0L) {
                this.responseBodyComplete();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                this.responseBodyComplete();
            }
            this.closed = true;
        }

        @Override
        public long read(Buffer object, long l) throws IOException {
            if (l >= 0L) {
                if (!this.closed) {
                    long l2 = this.bytesRemaining;
                    if (l2 == 0L) {
                        return -1L;
                    }
                    if ((l = super.read((Buffer)object, Math.min(l2, l))) != -1L) {
                        this.bytesRemaining = l2 = this.bytesRemaining - l;
                        if (l2 == 0L) {
                            this.responseBodyComplete();
                        }
                        return l;
                    }
                    Http1ExchangeCodec.this.realConnection.noNewExchanges();
                    object = new ProtocolException("unexpected end of stream");
                    this.responseBodyComplete();
                    throw object;
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }

    private final class KnownLengthSink
    implements Sink {
        private boolean closed;
        private final ForwardingTimeout timeout;

        private KnownLengthSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.access$402(Http1ExchangeCodec.this, 3);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (!this.closed) {
                Util.checkOffsetAndCount(buffer.size(), 0L, l);
                Http1ExchangeCodec.this.sink.write(buffer, l);
                return;
            }
            throw new IllegalStateException("closed");
        }
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        private UnknownLengthSource() {
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.closed = true;
        }

        @Override
        public long read(Buffer object, long l) throws IOException {
            if (l >= 0L) {
                if (!this.closed) {
                    if (this.inputExhausted) {
                        return -1L;
                    }
                    if ((l = super.read((Buffer)object, l)) == -1L) {
                        this.inputExhausted = true;
                        this.responseBodyComplete();
                        return -1L;
                    }
                    return l;
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }
}

