/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import okhttp3.internal.Util;
import okio.ByteString;

public final class Header {
    public static final ByteString PSEUDO_PREFIX = ByteString.encodeUtf8(":");
    public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8(":status");
    public static final String RESPONSE_STATUS_UTF8 = ":status";
    public static final ByteString TARGET_AUTHORITY;
    public static final String TARGET_AUTHORITY_UTF8 = ":authority";
    public static final ByteString TARGET_METHOD;
    public static final String TARGET_METHOD_UTF8 = ":method";
    public static final ByteString TARGET_PATH;
    public static final String TARGET_PATH_UTF8 = ":path";
    public static final ByteString TARGET_SCHEME;
    public static final String TARGET_SCHEME_UTF8 = ":scheme";
    final int hpackSize;
    public final ByteString name;
    public final ByteString value;

    static {
        TARGET_METHOD = ByteString.encodeUtf8(TARGET_METHOD_UTF8);
        TARGET_PATH = ByteString.encodeUtf8(TARGET_PATH_UTF8);
        TARGET_SCHEME = ByteString.encodeUtf8(TARGET_SCHEME_UTF8);
        TARGET_AUTHORITY = ByteString.encodeUtf8(TARGET_AUTHORITY_UTF8);
    }

    public Header(String string2, String string3) {
        this(ByteString.encodeUtf8(string2), ByteString.encodeUtf8(string3));
    }

    public Header(ByteString byteString, String string2) {
        this(byteString, ByteString.encodeUtf8(string2));
    }

    public Header(ByteString byteString, ByteString byteString2) {
        this.name = byteString;
        this.value = byteString2;
        this.hpackSize = byteString.size() + 32 + byteString2.size();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = object instanceof Header;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Header)object;
            bl3 = bl;
            if (this.name.equals(((Header)object).name)) {
                bl3 = bl;
                if (this.value.equals(((Header)object).value)) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    public int hashCode() {
        return (527 + this.name.hashCode()) * 31 + this.value.hashCode();
    }

    public String toString() {
        return Util.format("%s: %s", this.name.utf8(), this.value.utf8());
    }
}

