/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

final class Hpack {
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE;

    static {
        STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
        NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();
    }

    private Hpack() {
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n = byteString.size();
        for (int i = 0; i < n; ++i) {
            byte by = byteString.getByte(i);
            if (by < 65 || by > 90) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PROTOCOL_ERROR response malformed: mixed case name: ");
            stringBuilder.append(byteString.utf8());
            throw new IOException(stringBuilder.toString());
        }
        return byteString;
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        Header[] headerArray;
        LinkedHashMap<ByteString, Integer> linkedHashMap = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i = 0; i < (headerArray = STATIC_HEADER_TABLE).length; ++i) {
            if (linkedHashMap.containsKey(headerArray[i].name)) continue;
            linkedHashMap.put(headerArray[i].name, i);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static final class Reader {
        Header[] dynamicTable;
        int dynamicTableByteCount;
        int headerCount;
        private final List<Header> headerList = new ArrayList<Header>();
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        int nextHeaderIndex;
        private final BufferedSource source;

        Reader(int n, int n2, Source source) {
            Header[] headerArray = new Header[8];
            this.dynamicTable = headerArray;
            this.nextHeaderIndex = headerArray.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n2;
            this.source = Okio.buffer(source);
        }

        Reader(int n, Source source) {
            this(n, n, source);
        }

        private void adjustDynamicTableByteCount() {
            int n = this.maxDynamicTableByteCount;
            int n2 = this.dynamicTableByteCount;
            if (n < n2) {
                if (n == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(n2 - n);
                }
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int dynamicTableIndex(int n) {
            return this.nextHeaderIndex + 1 + n;
        }

        private int evictToRecoverBytes(int n) {
            int n2 = 0;
            int n3 = 0;
            if (n > 0) {
                int n4 = n;
                n = n3;
                for (n2 = this.dynamicTable.length - 1; n2 >= (n3 = this.nextHeaderIndex) && n4 > 0; --n2) {
                    n4 -= this.dynamicTable[n2].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[n2].hpackSize;
                    --this.headerCount;
                    ++n;
                }
                Header[] headerArray = this.dynamicTable;
                System.arraycopy(headerArray, n3 + 1, headerArray, n3 + 1 + n, this.headerCount);
                this.nextHeaderIndex += n;
                n2 = n;
            }
            return n2;
        }

        private ByteString getName(int n) throws IOException {
            Object object;
            if (this.isStaticHeader(n)) {
                return Hpack.STATIC_HEADER_TABLE[n].name;
            }
            int n2 = this.dynamicTableIndex(n - STATIC_HEADER_TABLE.length);
            if (n2 >= 0 && n2 < ((Header[])(object = this.dynamicTable)).length) {
                return ((Header)object[n2]).name;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Header index too large ");
            ((StringBuilder)object).append(n + 1);
            throw new IOException(((StringBuilder)object).toString());
        }

        private void insertIntoDynamicTable(int n, Header header) {
            int n2;
            this.headerList.add(header);
            int n3 = n2 = header.hpackSize;
            if (n != -1) {
                n3 = n2 - this.dynamicTable[this.dynamicTableIndex((int)n)].hpackSize;
            }
            if (n3 > (n2 = this.maxDynamicTableByteCount)) {
                this.clearDynamicTable();
                return;
            }
            int n4 = this.evictToRecoverBytes(this.dynamicTableByteCount + n3 - n2);
            if (n == -1) {
                n = this.headerCount;
                Header[] headerArray = this.dynamicTable;
                if (n + 1 > headerArray.length) {
                    Header[] headerArray2 = new Header[headerArray.length * 2];
                    System.arraycopy(headerArray, 0, headerArray2, headerArray.length, headerArray.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray2;
                }
                n = this.nextHeaderIndex;
                this.nextHeaderIndex = n - 1;
                this.dynamicTable[n] = header;
                ++this.headerCount;
            } else {
                n2 = this.dynamicTableIndex(n);
                this.dynamicTable[n + (n2 + n4)] = header;
            }
            this.dynamicTableByteCount += n3;
        }

        private boolean isStaticHeader(int n) {
            boolean bl = true;
            if (n < 0 || n > STATIC_HEADER_TABLE.length - 1) {
                bl = false;
            }
            return bl;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        private void readIndexedHeader(int n) throws IOException {
            Object object;
            block4: {
                block3: {
                    block2: {
                        if (!this.isStaticHeader(n)) break block2;
                        Header header = STATIC_HEADER_TABLE[n];
                        this.headerList.add(header);
                        break block3;
                    }
                    int n2 = this.dynamicTableIndex(n - STATIC_HEADER_TABLE.length);
                    if (n2 < 0 || n2 >= ((Header[])(object = this.dynamicTable)).length) break block4;
                    this.headerList.add((Header)object[n2]);
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Header index too large ");
            ((StringBuilder)object).append(n + 1);
            throw new IOException(((StringBuilder)object).toString());
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n) throws IOException {
            this.insertIntoDynamicTable(-1, new Header(this.getName(n), this.readByteString()));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            this.insertIntoDynamicTable(-1, new Header(Hpack.checkLowercase(this.readByteString()), this.readByteString()));
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        ByteString readByteString() throws IOException {
            int n = this.readByte();
            boolean bl = (n & 0x80) == 128;
            n = this.readInt(n, 127);
            if (bl) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n)));
            }
            return this.source.readByteString(n);
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n = this.source.readByte() & 0xFF;
                if (n != 128) {
                    if ((n & 0x80) == 128) {
                        this.readIndexedHeader(this.readInt(n, 127) - 1);
                        continue;
                    }
                    if (n == 64) {
                        this.readLiteralHeaderWithIncrementalIndexingNewName();
                        continue;
                    }
                    if ((n & 0x40) == 64) {
                        this.readLiteralHeaderWithIncrementalIndexingIndexedName(this.readInt(n, 63) - 1);
                        continue;
                    }
                    if ((n & 0x20) == 32) {
                        this.maxDynamicTableByteCount = n = this.readInt(n, 31);
                        if (n >= 0 && n <= this.headerTableSizeSetting) {
                            this.adjustDynamicTableByteCount();
                            continue;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Invalid dynamic table size update ");
                        stringBuilder.append(this.maxDynamicTableByteCount);
                        throw new IOException(stringBuilder.toString());
                    }
                    if (n != 16 && n != 0) {
                        this.readLiteralHeaderWithoutIndexingIndexedName(this.readInt(n, 15) - 1);
                        continue;
                    }
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                throw new IOException("index == 0");
            }
        }

        int readInt(int n, int n2) throws IOException {
            int n3;
            if ((n &= n2) < n2) {
                return n;
            }
            n = 0;
            while (((n3 = this.readByte()) & 0x80) != 0) {
                n2 += (n3 & 0x7F) << n;
                n += 7;
            }
            return n2 + (n3 << n);
        }
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        Header[] dynamicTable;
        int dynamicTableByteCount;
        private boolean emitDynamicTableSizeUpdate;
        int headerCount;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        int nextHeaderIndex;
        private final Buffer out;
        private int smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        private final boolean useCompression;

        Writer(int n, boolean bl, Buffer buffer) {
            Header[] headerArray = new Header[8];
            this.dynamicTable = headerArray;
            this.nextHeaderIndex = headerArray.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n;
            this.useCompression = bl;
            this.out = buffer;
        }

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        private void adjustDynamicTableByteCount() {
            int n = this.maxDynamicTableByteCount;
            int n2 = this.dynamicTableByteCount;
            if (n < n2) {
                if (n == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(n2 - n);
                }
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n) {
            int n2 = 0;
            int n3 = 0;
            if (n > 0) {
                int n4 = n;
                n = n3;
                for (n2 = this.dynamicTable.length - 1; n2 >= (n3 = this.nextHeaderIndex) && n4 > 0; --n2) {
                    n4 -= this.dynamicTable[n2].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[n2].hpackSize;
                    --this.headerCount;
                    ++n;
                }
                Object[] objectArray = this.dynamicTable;
                System.arraycopy(objectArray, n3 + 1, objectArray, n3 + 1 + n, this.headerCount);
                objectArray = this.dynamicTable;
                n2 = this.nextHeaderIndex;
                Arrays.fill(objectArray, n2 + 1, n2 + 1 + n, null);
                this.nextHeaderIndex += n;
                n2 = n;
            }
            return n2;
        }

        private void insertIntoDynamicTable(Header header) {
            int n = header.hpackSize;
            int n2 = this.maxDynamicTableByteCount;
            if (n > n2) {
                this.clearDynamicTable();
                return;
            }
            this.evictToRecoverBytes(this.dynamicTableByteCount + n - n2);
            n2 = this.headerCount;
            Header[] headerArray = this.dynamicTable;
            if (n2 + 1 > headerArray.length) {
                Header[] headerArray2 = new Header[headerArray.length * 2];
                System.arraycopy(headerArray, 0, headerArray2, headerArray.length, headerArray.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray2;
            }
            n2 = this.nextHeaderIndex;
            this.nextHeaderIndex = n2 - 1;
            this.dynamicTable[n2] = header;
            ++this.headerCount;
            this.dynamicTableByteCount += n;
        }

        void setHeaderTableSizeSetting(int n) {
            this.headerTableSizeSetting = n;
            n = this.maxDynamicTableByteCount;
            int n2 = Math.min(n, 16384);
            if (n == n2) {
                return;
            }
            if (n2 < n) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n2;
            this.adjustDynamicTableByteCount();
        }

        void writeByteString(ByteString byteString) throws IOException {
            if (this.useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer = new Buffer();
                Huffman.get().encode(byteString, buffer);
                byteString = buffer.readByteString();
                this.writeInt(byteString.size(), 127, 128);
                this.out.write(byteString);
            } else {
                this.writeInt(byteString.size(), 127, 0);
                this.out.write(byteString);
            }
        }

        /*
         * Unable to fully structure code
         */
        void writeHeaders(List<Header> var1_1) throws IOException {
            if (this.emitDynamicTableSizeUpdate) {
                var2_2 = this.smallestHeaderTableSizeSetting;
                if (var2_2 < this.maxDynamicTableByteCount) {
                    this.writeInt(var2_2, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = 0x7FFFFFFF;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            var3_3 = var1_1.size();
            for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                block16: {
                    block15: {
                        var5_5 = var1_1.get(var4_4);
                        var6_6 = var5_5.name.toAsciiLowercase();
                        var7_7 = var5_5.value;
                        var8_8 = Hpack.NAME_TO_FIRST_INDEX.get(var6_6);
                        if (var8_8 == null) break block15;
                        var9_9 = var8_8 + 1;
                        if (var9_9 <= 1 || var9_9 >= 8) ** GOTO lbl-1000
                        if (Objects.equals(Hpack.STATIC_HEADER_TABLE[var9_9 - 1].value, var7_7)) {
                            var2_2 = var9_9;
                        } else if (Objects.equals(Hpack.STATIC_HEADER_TABLE[var9_9].value, var7_7)) {
                            var2_2 = var9_9++;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var2_2 = var9_9;
                            var9_9 = -1;
                        }
                        break block16;
                    }
                    var9_9 = -1;
                    var2_2 = -1;
                }
                var10_10 = var9_9;
                var11_11 = var2_2;
                if (var9_9 == -1) {
                    var12_12 = this.nextHeaderIndex + 1;
                    var13_13 = this.dynamicTable.length;
                    while (true) {
                        var10_10 = var9_9;
                        var11_11 = var2_2;
                        if (var12_12 >= var13_13) break;
                        var11_11 = var2_2;
                        if (Objects.equals(this.dynamicTable[var12_12].name, var6_6)) {
                            if (Objects.equals(this.dynamicTable[var12_12].value, var7_7)) {
                                var9_9 = this.nextHeaderIndex;
                                var10_10 = Hpack.STATIC_HEADER_TABLE.length + (var12_12 - var9_9);
                                var11_11 = var2_2;
                                break;
                            }
                            var11_11 = var2_2;
                            if (var2_2 == -1) {
                                var11_11 = var12_12 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                            }
                        }
                        ++var12_12;
                        var2_2 = var11_11;
                    }
                }
                if (var10_10 != -1) {
                    this.writeInt(var10_10, 127, 128);
                    continue;
                }
                if (var11_11 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(var6_6);
                    this.writeByteString(var7_7);
                    this.insertIntoDynamicTable(var5_5);
                    continue;
                }
                if (var6_6.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(var6_6)) {
                    this.writeInt(var11_11, 15, 0);
                    this.writeByteString(var7_7);
                    continue;
                }
                this.writeInt(var11_11, 63, 64);
                this.writeByteString(var7_7);
                this.insertIntoDynamicTable(var5_5);
            }
        }

        void writeInt(int n, int n2, int n3) {
            if (n < n2) {
                this.out.writeByte(n | n3);
                return;
            }
            this.out.writeByte(n3 | n2);
            n -= n2;
            while (n >= 128) {
                this.out.writeByte(0x80 | n & 0x7F);
                n >>>= 7;
            }
            this.out.writeByte(n);
        }
    }
}

