/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import okhttp3.internal.Util;
import okio.ByteString;

public final class Http2 {
    static final String[] BINARY;
    static final ByteString CONNECTION_PREFACE;
    static final String[] FLAGS;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_COMPRESSED = 32;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    private static final String[] FRAME_NAMES;
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_CONTINUATION = 9;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PING = 6;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_WINDOW_UPDATE = 8;

    /*
     * WARNING - void declaration
     */
    static {
        void var4_6;
        StringBuilder stringBuilder;
        Object[] objectArray;
        int n;
        CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FLAGS = new String[64];
        BINARY = new String[256];
        int bl = 0;
        for (n = 0; n < (objectArray = BINARY).length; ++n) {
            objectArray[n] = Util.format("%8s", Integer.toBinaryString(n)).replace(' ', '0');
        }
        String[] stringArray = FLAGS;
        stringArray[0] = "";
        stringArray[1] = "END_STREAM";
        objectArray = new int[1];
        objectArray[0] = (String)true;
        stringArray[8] = "PADDED";
        for (n = 0; n < 1; ++n) {
            String string2 = objectArray[n];
            stringArray = FLAGS;
            stringBuilder = new StringBuilder();
            stringBuilder.append(stringArray[string2]);
            stringBuilder.append("|PADDED");
            stringArray[string2 | 8] = stringBuilder.toString();
        }
        stringArray = FLAGS;
        stringArray[4] = "END_HEADERS";
        stringArray[32] = "PRIORITY";
        stringArray[36] = "END_HEADERS|PRIORITY";
        n = 0;
        while (true) {
            int n2 = bl;
            if (n >= 3) break;
            int n3 = (new int[]{4, 32, 36})[n];
            for (n2 = 0; n2 < 1; ++n2) {
                String string3 = objectArray[n2];
                stringArray = FLAGS;
                int n4 = string3 | n3;
                stringBuilder = new StringBuilder();
                stringBuilder.append(stringArray[string3]);
                stringBuilder.append('|');
                stringBuilder.append(stringArray[n3]);
                stringArray[n4] = stringBuilder.toString();
                stringBuilder = new StringBuilder();
                stringBuilder.append(stringArray[string3]);
                stringBuilder.append('|');
                stringBuilder.append(stringArray[n3]);
                stringBuilder.append("|PADDED");
                stringArray[n4 | 8] = stringBuilder.toString();
            }
            ++n;
        }
        while (var4_6 < (objectArray = FLAGS).length) {
            if (objectArray[var4_6] == null) {
                objectArray[var4_6] = BINARY[var4_6];
            }
            ++var4_6;
        }
    }

    private Http2() {
    }

    static String formatFlags(byte by, byte by2) {
        if (by2 == 0) {
            return "";
        }
        if (by != 2 && by != 3) {
            if (by != 4 && by != 6) {
                if (by != 7 && by != 8) {
                    Object object = FLAGS;
                    object = by2 < ((String[])object).length ? object[by2] : BINARY[by2];
                    if (by == 5 && (by2 & 4) != 0) {
                        return ((String)object).replace("HEADERS", "PUSH_PROMISE");
                    }
                    if (by == 0 && (by2 & 0x20) != 0) {
                        return ((String)object).replace("PRIORITY", "COMPRESSED");
                    }
                    return object;
                }
            } else {
                String string2 = by2 == 1 ? "ACK" : BINARY[by2];
                return string2;
            }
        }
        return BINARY[by2];
    }

    static String frameLog(boolean bl, int n, int n2, byte by, byte by2) {
        Object object = FRAME_NAMES;
        object = by < ((String[])object).length ? object[by] : Util.format("0x%02x", by);
        String string2 = Http2.formatFlags(by, by2);
        String string3 = bl ? "<<" : ">>";
        return Util.format("%s 0x%08x %5d %-13s %s", string3, n, n2, object, string2);
    }

    static IllegalArgumentException illegalArgument(String string2, Object ... objectArray) {
        throw new IllegalArgumentException(Util.format(string2, objectArray));
    }

    static IOException ioException(String string2, Object ... objectArray) throws IOException {
        throw new IOException(Util.format(string2, objectArray));
    }
}

