/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class Http2Connection
implements Closeable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    static final int AWAIT_PING = 3;
    static final int DEGRADED_PING = 2;
    static final long DEGRADED_PONG_TIMEOUT_NS = 1000000000L;
    static final int INTERVAL_PING = 1;
    static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final ExecutorService listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Http2Connection", true));
    private long awaitPingsSent = 0L;
    private long awaitPongsReceived = 0L;
    long bytesLeftInWriteWindow;
    final boolean client;
    final String connectionName;
    final Set<Integer> currentPushRequests;
    private long degradedPingsSent = 0L;
    private long degradedPongDeadlineNs = 0L;
    private long degradedPongsReceived = 0L;
    private long intervalPingsSent = 0L;
    private long intervalPongsReceived = 0L;
    int lastGoodStreamId;
    final Listener listener;
    int nextStreamId;
    Settings okHttpSettings;
    final Settings peerSettings;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    final ReaderRunnable readerRunnable;
    private boolean shutdown;
    final Socket socket;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    long unacknowledgedBytesRead = 0L;
    final Http2Writer writer;
    private final ScheduledExecutorService writerExecutor;

    Http2Connection(Builder builder) {
        String string2;
        boolean bl;
        Settings settings;
        this.okHttpSettings = new Settings();
        this.peerSettings = settings = new Settings();
        this.currentPushRequests = new LinkedHashSet<Integer>();
        this.pushObserver = builder.pushObserver;
        this.client = bl = builder.client;
        this.listener = builder.listener;
        int n = builder.client ? 1 : 2;
        this.nextStreamId = n;
        if (builder.client) {
            this.nextStreamId += 2;
        }
        if (builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.connectionName = string2 = builder.connectionName;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", string2), false));
        this.writerExecutor = scheduledThreadPoolExecutor;
        if (builder.pingIntervalMillis != 0) {
            scheduledThreadPoolExecutor.scheduleAtFixedRate(new IntervalPingRunnable(), builder.pingIntervalMillis, builder.pingIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", string2), true));
        settings.set(7, 65535);
        settings.set(5, 16384);
        this.bytesLeftInWriteWindow = settings.getInitialWindowSize();
        this.socket = builder.socket;
        this.writer = new Http2Writer(builder.sink, bl);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.source, bl));
    }

    static /* synthetic */ long access$108(Http2Connection http2Connection) {
        long l = http2Connection.intervalPongsReceived;
        http2Connection.intervalPongsReceived = 1L + l;
        return l;
    }

    static /* synthetic */ long access$208(Http2Connection http2Connection) {
        long l = http2Connection.intervalPingsSent;
        http2Connection.intervalPingsSent = 1L + l;
        return l;
    }

    static /* synthetic */ boolean access$302(Http2Connection http2Connection, boolean bl) {
        http2Connection.shutdown = bl;
        return bl;
    }

    static /* synthetic */ long access$608(Http2Connection http2Connection) {
        long l = http2Connection.degradedPongsReceived;
        http2Connection.degradedPongsReceived = 1L + l;
        return l;
    }

    static /* synthetic */ long access$708(Http2Connection http2Connection) {
        long l = http2Connection.awaitPongsReceived;
        http2Connection.awaitPongsReceived = 1L + l;
        return l;
    }

    private void failConnection(@Nullable IOException iOException) {
        this.close(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, iOException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Http2Stream newStream(int n, List<Header> object, boolean bl) throws IOException {
        boolean bl2 = bl ^ true;
        Http2Writer http2Writer = this.writer;
        // MONITORENTER : http2Writer
        // MONITORENTER : this
        if (this.nextStreamId > 0x3FFFFFFF) {
            this.shutdown(ErrorCode.REFUSED_STREAM);
        }
        if (this.shutdown) {
            object = new ConnectionShutdownException();
            throw object;
        }
        int n2 = this.nextStreamId;
        this.nextStreamId = n2 + 2;
        Http2Stream http2Stream = new Http2Stream(n2, this, bl2, false, null);
        boolean bl3 = !bl || this.bytesLeftInWriteWindow == 0L || http2Stream.bytesLeftInWriteWindow == 0L;
        if (http2Stream.isOpen()) {
            this.streams.put(n2, http2Stream);
        }
        // MONITOREXIT : this
        if (n == 0) {
            this.writer.headers(bl2, n2, (List<Header>)object);
        } else {
            if (this.client) {
                object = new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                throw object;
            }
            this.writer.pushPromise(n, n2, (List<Header>)object);
        }
        // MONITOREXIT : http2Writer
        if (!bl3) return http2Stream;
        this.writer.flush();
        return http2Stream;
    }

    private void pushExecutorExecute(NamedRunnable namedRunnable) {
        synchronized (this) {
            if (!this.shutdown) {
                this.pushExecutor.execute(namedRunnable);
            }
            return;
        }
    }

    void awaitPong() throws InterruptedException {
        synchronized (this) {
            while (this.awaitPongsReceived < this.awaitPingsSent) {
                this.wait();
            }
            return;
        }
    }

    @Override
    public void close() {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void close(ErrorCode http2StreamArray, ErrorCode errorCode, @Nullable IOException iOException) {
        try {
            this.shutdown((ErrorCode)http2StreamArray);
        }
        catch (IOException iOException2) {}
        http2StreamArray = null;
        // MONITORENTER : this
        if (!this.streams.isEmpty()) {
            http2StreamArray = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
            this.streams.clear();
        }
        // MONITOREXIT : this
        if (http2StreamArray != null) {
            for (Http2Stream http2Stream : http2StreamArray) {
                try {
                    http2Stream.close(errorCode, iOException);
                }
                catch (IOException iOException3) {}
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException4) {}
        try {
            this.socket.close();
        }
        catch (IOException iOException5) {}
        this.writerExecutor.shutdown();
        this.pushExecutor.shutdown();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    Http2Stream getStream(int n) {
        synchronized (this) {
            Http2Stream http2Stream = this.streams.get(n);
            return http2Stream;
        }
    }

    public boolean isHealthy(long l) {
        synchronized (this) {
            block5: {
                long l2;
                block4: {
                    boolean bl = this.shutdown;
                    if (!bl) break block4;
                    return false;
                }
                if (this.degradedPongsReceived >= this.degradedPingsSent || l < (l2 = this.degradedPongDeadlineNs)) break block5;
                return false;
            }
            return true;
        }
    }

    public int maxConcurrentStreams() {
        synchronized (this) {
            int n = this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
            return n;
        }
    }

    public Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    public int openStreamCount() {
        synchronized (this) {
            int n = this.streams.size();
            return n;
        }
    }

    void pushDataLater(final int n, BufferedSource object, final int n2, final boolean bl) throws IOException {
        final Buffer buffer = new Buffer();
        long l = n2;
        object.require(l);
        object.read(buffer, l);
        if (buffer.size() == l) {
            this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.connectionName, n}){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void execute() {
                    try {
                        boolean bl2 = Http2Connection.this.pushObserver.onData(n, buffer, n2, bl);
                        if (bl2) {
                            Http2Connection.this.writer.rstStream(n, ErrorCode.CANCEL);
                        }
                        if (!bl2) {
                            if (!bl) return;
                        }
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            });
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(buffer.size());
        ((StringBuilder)object).append(" != ");
        ((StringBuilder)object).append(n2);
        throw new IOException(((StringBuilder)object).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pushHeadersLater(final int n, final List<Header> list, final boolean bl) {
        try {
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.connectionName, n}){

                /*
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void execute() {
                    var1_1 = Http2Connection.this.pushObserver.onHeaders(n, list, bl);
                    if (!var1_1) ** GOTO lbl5
                    try {
                        Http2Connection.this.writer.rstStream(n, ErrorCode.CANCEL);
lbl5:
                        // 2 sources

                        if (!var1_1) {
                            if (bl == false) return;
                        }
                        var2_2 = Http2Connection.this;
                        synchronized (var2_2) {
                            Http2Connection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException var3_3) {
                        return;
                    }
                }
            };
            this.pushExecutorExecute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void pushRequestLater(final int n, final List<Header> list) {
        synchronized (this) {
            if (this.currentPushRequests.contains(n)) {
                this.writeSynResetLater(n, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n);
        }
        try {
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.connectionName, n}){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void execute() {
                    if (!Http2Connection.this.pushObserver.onRequest(n, list)) return;
                    try {
                        Http2Connection.this.writer.rstStream(n, ErrorCode.CANCEL);
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            };
            this.pushExecutorExecute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    void pushResetLater(final int n, final ErrorCode errorCode) {
        this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.connectionName, n}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                Http2Connection.this.pushObserver.onReset(n, errorCode);
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n);
                    return;
                }
            }
        });
    }

    public Http2Stream pushStream(int n, List<Header> list, boolean bl) throws IOException {
        if (!this.client) {
            return this.newStream(n, list, bl);
        }
        throw new IllegalStateException("Client cannot push requests.");
    }

    boolean pushedStream(int n) {
        boolean bl = true;
        if (n == 0 || (n & 1) != 0) {
            bl = false;
        }
        return bl;
    }

    Http2Stream removeStream(int n) {
        synchronized (this) {
            Http2Stream http2Stream = this.streams.remove(n);
            this.notifyAll();
            return http2Stream;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendDegradedPingLater() {
        synchronized (this) {
            long l = this.degradedPongsReceived;
            long l2 = this.degradedPingsSent;
            if (l < l2) {
                return;
            }
            this.degradedPingsSent = l2 + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        try {
            ScheduledExecutorService scheduledExecutorService = this.writerExecutor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s ping", new Object[]{this.connectionName}){

                @Override
                public void execute() {
                    Http2Connection.this.writePing(false, 2, 0);
                }
            };
            scheduledExecutorService.execute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSettings(Settings object) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            synchronized (this) {
                if (!this.shutdown) {
                    this.okHttpSettings.merge((Settings)object);
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 7] lbl6 : MonitorExitStatement: MONITOREXIT : this
                    this.writer.settings((Settings)object);
                    return;
                }
                object = new ConnectionShutdownException();
                throw object;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n;
            synchronized (this) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n = this.lastGoodStreamId;
            }
            this.writer.goAway(n, errorCode, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean bl) throws IOException {
        if (bl) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int n = this.okHttpSettings.getInitialWindowSize();
            if (n != 65535) {
                this.writer.windowUpdate(0, n - 65535);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    void updateConnectionFlowControl(long l) {
        synchronized (this) {
            this.unacknowledgedBytesRead = l = this.unacknowledgedBytesRead + l;
            if (l >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
                this.writeWindowUpdateLater(0, this.unacknowledgedBytesRead);
                this.unacknowledgedBytesRead = 0L;
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void writeData(int var1_1, boolean var2_2, Buffer var3_3, long var4_7) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [8 : 175->193)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void writeHeaders(int n, boolean bl, List<Header> list) throws IOException {
        this.writer.headers(bl, n, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writePing() {
        synchronized (this) {
            ++this.awaitPingsSent;
        }
        this.writePing(false, 3, 1330343787);
    }

    void writePing(boolean bl, int n, int n2) {
        try {
            this.writer.ping(bl, n, n2);
        }
        catch (IOException iOException) {
            this.failConnection(iOException);
        }
    }

    void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    void writeSynReset(int n, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n, errorCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeSynResetLater(final int n, final ErrorCode errorCode) {
        try {
            ScheduledExecutorService scheduledExecutorService = this.writerExecutor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s stream %d", new Object[]{this.connectionName, n}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writeSynReset(n, errorCode);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection(iOException);
                    }
                }
            };
            scheduledExecutorService.execute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeWindowUpdateLater(final int n, final long l) {
        try {
            ScheduledExecutorService scheduledExecutorService = this.writerExecutor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.connectionName, n}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writer.windowUpdate(n, l);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection(iOException);
                    }
                }
            };
            scheduledExecutorService.execute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    public static class Builder {
        boolean client;
        String connectionName;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        int pingIntervalMillis;
        PushObserver pushObserver = PushObserver.CANCEL;
        BufferedSink sink;
        Socket socket;
        BufferedSource source;

        public Builder(boolean bl) {
            this.client = bl;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pingIntervalMillis(int n) {
            this.pingIntervalMillis = n;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder socket(Socket socket) throws IOException {
            Object object = socket.getRemoteSocketAddress();
            object = object instanceof InetSocketAddress ? ((InetSocketAddress)object).getHostName() : object.toString();
            return this.socket(socket, (String)object, Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String string2, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.connectionName = string2;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }
    }

    final class IntervalPingRunnable
    extends NamedRunnable {
        IntervalPingRunnable() {
            super("OkHttp %s ping", Http2Connection.this.connectionName);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void execute() {
            boolean bl;
            Http2Connection http2Connection = Http2Connection.this;
            // MONITORENTER : http2Connection
            if (Http2Connection.this.intervalPongsReceived < Http2Connection.this.intervalPingsSent) {
                bl = true;
            } else {
                Http2Connection.access$208(Http2Connection.this);
                bl = false;
            }
            // MONITOREXIT : http2Connection
            if (bl) {
                Http2Connection.this.failConnection(null);
                return;
            }
            Http2Connection.this.writePing(false, 1, 0);
        }
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public void onSettings(Http2Connection http2Connection) {
        }

        public abstract void onStream(Http2Stream var1) throws IOException;
    }

    final class PingRunnable
    extends NamedRunnable {
        final int payload1;
        final int payload2;
        final boolean reply;

        PingRunnable(boolean bl, int n, int n2) {
            super("OkHttp %s ping %08x%08x", Http2Connection.this.connectionName, n, n2);
            this.reply = bl;
            this.payload1 = n;
            this.payload2 = n2;
        }

        @Override
        public void execute() {
            Http2Connection.this.writePing(this.reply, this.payload1, this.payload2);
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;

        ReaderRunnable(Http2Reader http2Reader) {
            super("OkHttp %s", Http2Connection.this.connectionName);
            this.reader = http2Reader;
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void alternateService(int n, String string2, ByteString byteString, String string3, int n2, long l) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void applyAndAckSettings(boolean bl, Settings http2StreamArray) {
            long l;
            Object object2 = Http2Connection.this.writer;
            // MONITORENTER : object2
            Http2Connection http2Connection = Http2Connection.this;
            // MONITORENTER : http2Connection
            int n = Http2Connection.this.peerSettings.getInitialWindowSize();
            if (bl) {
                Http2Connection.this.peerSettings.clear();
            }
            Http2Connection.this.peerSettings.merge((Settings)http2StreamArray);
            int n2 = Http2Connection.this.peerSettings.getInitialWindowSize();
            http2StreamArray = null;
            if (n2 != -1 && n2 != n) {
                long l2;
                l = l2 = (long)(n2 - n);
                if (!Http2Connection.this.streams.isEmpty()) {
                    http2StreamArray = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                    l = l2;
                }
            } else {
                l = 0L;
            }
            // MONITOREXIT : http2Connection
            try {
                Http2Connection.this.writer.applyAndAckSettings(Http2Connection.this.peerSettings);
            }
            catch (IOException iOException) {
                Http2Connection.this.failConnection(iOException);
            }
            if (http2StreamArray != null) {
                for (Object object2 : http2StreamArray) {
                    // MONITORENTER : object2
                    ((Http2Stream)object2).addBytesToWriteWindow(l);
                    // MONITOREXIT : object2
                }
            }
            listenerExecutor.execute(new NamedRunnable("OkHttp %s settings", new Object[]{Http2Connection.this.connectionName}){

                @Override
                public void execute() {
                    Http2Connection.this.listener.onSettings(Http2Connection.this);
                }
            });
        }

        @Override
        public void data(boolean bl, int n, BufferedSource bufferedSource, int n2) throws IOException {
            if (Http2Connection.this.pushedStream(n)) {
                Http2Connection.this.pushDataLater(n, bufferedSource, n2, bl);
                return;
            }
            Object object = Http2Connection.this.getStream(n);
            if (object == null) {
                Http2Connection.this.writeSynResetLater(n, ErrorCode.PROTOCOL_ERROR);
                object = Http2Connection.this;
                long l = n2;
                ((Http2Connection)object).updateConnectionFlowControl(l);
                bufferedSource.skip(l);
                return;
            }
            ((Http2Stream)object).receiveData(bufferedSource, n2);
            if (bl) {
                ((Http2Stream)object).receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void execute() {
            Throwable throwable2;
            IOException iOException;
            Object object;
            ErrorCode errorCode;
            block5: {
                ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
                errorCode = ErrorCode.INTERNAL_ERROR;
                ErrorCode errorCode3 = null;
                Object object2 = null;
                object = errorCode2;
                iOException = object2;
                ErrorCode errorCode4 = errorCode2;
                try {
                    try {
                        this.reader.readConnectionPreface(this);
                        do {
                            object = errorCode2;
                            iOException = object2;
                            errorCode4 = errorCode2;
                        } while (this.reader.nextFrame(false, this));
                        object = errorCode2;
                        iOException = object2;
                        errorCode4 = errorCode2;
                        object = errorCode2 = ErrorCode.NO_ERROR;
                        iOException = object2;
                        errorCode4 = errorCode2;
                        object2 = ErrorCode.CANCEL;
                        errorCode4 = errorCode2;
                        object = object2;
                        errorCode2 = errorCode3;
                    }
                    catch (IOException iOException2) {
                        object = errorCode4;
                        iOException = iOException2;
                        object = errorCode4 = ErrorCode.PROTOCOL_ERROR;
                        iOException = iOException2;
                        object = errorCode3 = ErrorCode.PROTOCOL_ERROR;
                    }
                }
                catch (Throwable throwable2) {
                    break block5;
                }
                Http2Connection.this.close(errorCode4, (ErrorCode)((Object)object), (IOException)((Object)errorCode2));
                Util.closeQuietly(this.reader);
                return;
            }
            Http2Connection.this.close((ErrorCode)((Object)object), errorCode, iOException);
            Util.closeQuietly(this.reader);
            throw throwable2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void goAway(int n, ErrorCode object, ByteString http2StreamArray) {
            http2StreamArray.size();
            object = Http2Connection.this;
            synchronized (object) {
                http2StreamArray = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Http2Connection.access$302(Http2Connection.this, true);
            }
            int n2 = http2StreamArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = http2StreamArray[n3];
                if (((Http2Stream)object).getId() > n && ((Http2Stream)object).isLocallyInitiated()) {
                    ((Http2Stream)object).receiveRstStream(ErrorCode.REFUSED_STREAM);
                    Http2Connection.this.removeStream(((Http2Stream)object).getId());
                }
                ++n3;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void headers(boolean bl, int n, int n2, List<Header> object) {
            if (Http2Connection.this.pushedStream(n)) {
                Http2Connection.this.pushHeadersLater(n, (List<Header>)object, bl);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                NamedRunnable namedRunnable = Http2Connection.this.getStream(n);
                if (namedRunnable != null) {
                    // MONITOREXIT @DISABLED, blocks:[2, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var5_5
                    ((Http2Stream)((Object)namedRunnable)).receiveHeaders(Util.toHeaders(object), bl);
                    return;
                }
                if (Http2Connection.this.shutdown) {
                    return;
                }
                if (n <= Http2Connection.this.lastGoodStreamId) {
                    return;
                }
                if (n % 2 == Http2Connection.this.nextStreamId % 2) {
                    return;
                }
                namedRunnable = Util.toHeaders(object);
                object = new Http2Stream(n, Http2Connection.this, false, bl, (Headers)((Object)namedRunnable));
                Http2Connection.this.lastGoodStreamId = n;
                Http2Connection.this.streams.put(n, (Http2Stream)object);
                ExecutorService executorService = listenerExecutor;
                namedRunnable = new NamedRunnable("OkHttp %s stream %d", new Object[]{Http2Connection.this.connectionName, n}, (Http2Stream)object){
                    final /* synthetic */ Http2Stream val$newStream;
                    {
                        this.val$newStream = http2Stream;
                        super(string2, objectArray);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void execute() {
                        try {
                            Http2Connection.this.listener.onStream(this.val$newStream);
                            return;
                        }
                        catch (IOException iOException) {
                            Platform platform = Platform.get();
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Http2Connection.Listener failure for ");
                            stringBuilder.append(Http2Connection.this.connectionName);
                            platform.log(4, stringBuilder.toString(), iOException);
                            try {
                                this.val$newStream.close(ErrorCode.PROTOCOL_ERROR, iOException);
                                return;
                            }
                            catch (IOException iOException2) {
                                return;
                            }
                        }
                    }
                };
                executorService.execute(namedRunnable);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void ping(boolean bl, int n, int n2) {
            if (bl) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Throwable throwable2;
                    block10: {
                        block9: {
                            if (n == 1) {
                                try {
                                    Http2Connection.access$108(Http2Connection.this);
                                    break block9;
                                }
                                catch (Throwable throwable2) {
                                    break block10;
                                }
                            }
                            if (n == 2) {
                                Http2Connection.access$608(Http2Connection.this);
                            } else {
                                if (n != 3) return;
                                Http2Connection.access$708(Http2Connection.this);
                                Http2Connection.this.notifyAll();
                            }
                        }
                        return;
                    }
                    throw throwable2;
                }
            }
            try {
                ScheduledExecutorService scheduledExecutorService = Http2Connection.this.writerExecutor;
                PingRunnable pingRunnable = new PingRunnable(true, n, n2);
                scheduledExecutorService.execute(pingRunnable);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
        }

        @Override
        public void priority(int n, int n2, int n3, boolean bl) {
        }

        @Override
        public void pushPromise(int n, int n2, List<Header> list) {
            Http2Connection.this.pushRequestLater(n2, list);
        }

        @Override
        public void rstStream(int n, ErrorCode errorCode) {
            if (Http2Connection.this.pushedStream(n)) {
                Http2Connection.this.pushResetLater(n, errorCode);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.removeStream(n);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void settings(final boolean bl, final Settings settings) {
            try {
                ScheduledExecutorService scheduledExecutorService = Http2Connection.this.writerExecutor;
                NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s ACK Settings", new Object[]{Http2Connection.this.connectionName}){

                    @Override
                    public void execute() {
                        ReaderRunnable.this.applyAndAckSettings(bl, settings);
                    }
                };
                scheduledExecutorService.execute(namedRunnable);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void windowUpdate(int n, long l) {
            if (n == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection http2Connection2 = Http2Connection.this;
                    http2Connection2.bytesLeftInWriteWindow += l;
                    Http2Connection.this.notifyAll();
                    return;
                }
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n);
            if (http2Stream == null) return;
            synchronized (http2Stream) {
                http2Stream.addBytesToWriteWindow(l);
                return;
            }
        }
    }
}

