/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    private static final String CONNECTION = "connection";
    private static final String ENCODING = "encoding";
    private static final String HOST = "host";
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String PROXY_CONNECTION = "proxy-connection";
    private static final String TE = "te";
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String UPGRADE = "upgrade";
    private volatile boolean canceled;
    private final Interceptor.Chain chain;
    private final Http2Connection connection;
    private final Protocol protocol;
    private final RealConnection realConnection;
    private volatile Http2Stream stream;

    public Http2ExchangeCodec(OkHttpClient object, RealConnection realConnection, Interceptor.Chain chain, Http2Connection http2Connection) {
        this.realConnection = realConnection;
        this.chain = chain;
        this.connection = http2Connection;
        object = object.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
        this.protocol = object;
    }

    public static List<Header> http2HeadersList(Request object) {
        Headers headers = ((Request)object).headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, ((Request)object).method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(((Request)object).url())));
        String string2 = ((Request)object).header("Host");
        if (string2 != null) {
            arrayList.add(new Header(Header.TARGET_AUTHORITY, string2));
        }
        arrayList.add(new Header(Header.TARGET_SCHEME, ((Request)object).url().scheme()));
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            object = headers.name(i).toLowerCase(Locale.US);
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(object) && (!((String)object).equals(TE) || !headers.value(i).equals("trailers"))) continue;
            arrayList.add(new Header((String)object, headers.value(i)));
        }
        return arrayList;
    }

    public static Response.Builder readHttp2HeadersList(Headers headers, Protocol protocol) throws IOException {
        Headers.Builder builder = new Headers.Builder();
        int n = headers.size();
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            String string2 = headers.name(i);
            String string3 = headers.value(i);
            if (string2.equals(":status")) {
                object = new StringBuilder();
                ((StringBuilder)object).append("HTTP/1.1 ");
                ((StringBuilder)object).append(string3);
                object = StatusLine.parse(((StringBuilder)object).toString());
            } else {
                object = stringBuilder;
                if (!HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(string2)) {
                    Internal.instance.addLenient(builder, string2, string3);
                    object = stringBuilder;
                }
            }
            stringBuilder = object;
        }
        if (stringBuilder != null) {
            return new Response.Builder().protocol(protocol).code(((StatusLine)((Object)stringBuilder)).code).message(((StatusLine)((Object)stringBuilder)).message).headers(builder.build());
        }
        throw new ProtocolException("Expected ':status' header not present");
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    @Override
    public RealConnection connection() {
        return this.realConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long l) {
        return this.stream.getSink();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public Source openResponseBodySource(Response response) {
        return this.stream.getSource();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Response.Builder builder = Http2ExchangeCodec.readHttp2HeadersList(this.stream.takeHeaders(), this.protocol);
        if (bl && Internal.instance.code(builder) == 100) {
            return null;
        }
        return builder;
    }

    @Override
    public long reportedContentLength(Response response) {
        return HttpHeaders.contentLength(response);
    }

    @Override
    public Headers trailers() throws IOException {
        return this.stream.trailers();
    }

    @Override
    public void writeRequestHeaders(Request object) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean bl = ((Request)object).body() != null;
        object = Http2ExchangeCodec.http2HeadersList((Request)object);
        this.stream = this.connection.newStream((List<Header>)object, bl);
        if (!this.canceled) {
            this.stream.readTimeout().timeout(this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
            this.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
            return;
        }
        this.stream.closeLater(ErrorCode.CANCEL);
        throw new IOException("Canceled");
    }
}

