/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

final class Http2Reader
implements Closeable {
    static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final boolean client;
    private final ContinuationSource continuation;
    final Hpack.Reader hpackReader;
    private final BufferedSource source;

    Http2Reader(BufferedSource source, boolean bl) {
        this.source = source;
        this.client = bl;
        source = new ContinuationSource((BufferedSource)source);
        this.continuation = source;
        this.hpackReader = new Hpack.Reader(4096, source);
    }

    static int lengthWithoutPadding(int n, byte by, short s) throws IOException {
        int n2 = n;
        if ((by & 8) != 0) {
            n2 = n - 1;
        }
        if (s <= n2) {
            return (short)(n2 - s);
        }
        throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s, n2);
    }

    private void readData(Handler handler, int n, byte by, int n2) throws IOException {
        short s = 0;
        if (n2 != 0) {
            short s2 = 1;
            boolean bl = (by & 1) != 0;
            if ((by & 0x20) == 0) {
                s2 = 0;
            }
            if (s2 == 0) {
                short s3 = s;
                if ((by & 8) != 0) {
                    s3 = s2 = (short)(this.source.readByte() & 0xFF);
                }
                n = Http2Reader.lengthWithoutPadding(n, by, s3);
                handler.data(bl, n2, this.source, n);
                this.source.skip(s3);
                return;
            }
            throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_DATA streamId == 0", new Object[0]);
    }

    private void readGoAway(Handler handler, int n, byte by, int n2) throws IOException {
        if (n >= 8) {
            if (n2 == 0) {
                by = (byte)this.source.readInt();
                n2 = this.source.readInt();
                n -= 8;
                ErrorCode errorCode = ErrorCode.fromHttp2(n2);
                if (errorCode != null) {
                    ByteString byteString = ByteString.EMPTY;
                    if (n > 0) {
                        byteString = this.source.readByteString(n);
                    }
                    handler.goAway(by, errorCode, byteString);
                    return;
                }
                throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", n2);
            }
            throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        throw Http2.ioException("TYPE_GOAWAY length < 8: %s", n);
    }

    private List<Header> readHeaderBlock(int n, short s, byte by, int n2) throws IOException {
        ContinuationSource continuationSource = this.continuation;
        continuationSource.left = n;
        continuationSource.length = n;
        this.continuation.padding = s;
        this.continuation.flags = by;
        this.continuation.streamId = n2;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readHeaders(Handler handler, int n, byte by, int n2) throws IOException {
        short s = 0;
        if (n2 != 0) {
            int n3;
            boolean bl = (by & 1) != 0;
            short s2 = s;
            if ((by & 8) != 0) {
                short s3;
                s2 = s3 = (short)(this.source.readByte() & 0xFF);
            }
            int n4 = n;
            if ((by & 0x20) != 0) {
                this.readPriority(handler, n2);
                n3 = n - 5;
            }
            handler.headers(bl, n2, -1, this.readHeaderBlock(Http2Reader.lengthWithoutPadding(n3, by, s2), s2, by, n2));
            return;
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
    }

    static int readMedium(BufferedSource bufferedSource) throws IOException {
        byte by = bufferedSource.readByte();
        byte by2 = bufferedSource.readByte();
        return bufferedSource.readByte() & 0xFF | ((by & 0xFF) << 16 | (by2 & 0xFF) << 8);
    }

    private void readPing(Handler handler, int n, byte by, int n2) throws IOException {
        boolean bl = false;
        if (n == 8) {
            if (n2 == 0) {
                n2 = this.source.readInt();
                n = this.source.readInt();
                if ((by & 1) != 0) {
                    bl = true;
                }
                handler.ping(bl, n2, n);
                return;
            }
            throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
        }
        throw Http2.ioException("TYPE_PING length != 8: %s", n);
    }

    private void readPriority(Handler handler, int n) throws IOException {
        int n2 = this.source.readInt();
        boolean bl = (Integer.MIN_VALUE & n2) != 0;
        handler.priority(n, n2 & Integer.MAX_VALUE, (this.source.readByte() & 0xFF) + 1, bl);
    }

    private void readPriority(Handler handler, int n, byte by, int n2) throws IOException {
        if (n == 5) {
            if (n2 != 0) {
                this.readPriority(handler, n2);
                return;
            }
            throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        throw Http2.ioException("TYPE_PRIORITY length: %d != 5", n);
    }

    private void readPushPromise(Handler handler, int n, byte by, int n2) throws IOException {
        short s = 0;
        if (n2 != 0) {
            short s2 = s;
            if ((by & 8) != 0) {
                s2 = s = (short)(this.source.readByte() & 0xFF);
            }
            handler.pushPromise(n2, this.source.readInt() & Integer.MAX_VALUE, this.readHeaderBlock(Http2Reader.lengthWithoutPadding(n - 4, by, s2), s2, by, n2));
            return;
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
    }

    private void readRstStream(Handler handler, int n, byte by, int n2) throws IOException {
        if (n == 4) {
            if (n2 != 0) {
                n = this.source.readInt();
                ErrorCode errorCode = ErrorCode.fromHttp2(n);
                if (errorCode != null) {
                    handler.rstStream(n2, errorCode);
                    return;
                }
                throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", n);
            }
            throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSettings(Handler handler, int n, byte by, int n2) throws IOException {
        if (n2 != 0) throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
        if ((by & 1) != 0) {
            if (n != 0) throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            handler.ackSettings();
            return;
        }
        if (n % 6 != 0) throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", n);
        Settings settings = new Settings();
        for (n2 = 0; n2 < n; n2 += 6) {
            int n3 = this.source.readShort() & 0xFFFF;
            int n4 = this.source.readInt();
            if (n3 != 2) {
                if (n3 != 3) {
                    if (n3 != 4) {
                        if (n3 != 5) {
                            by = (byte)n3;
                        } else {
                            if (n4 < 16384 || n4 > 0xFFFFFF) throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", n4);
                            by = (byte)n3;
                        }
                    } else {
                        by = (byte)7;
                        if (n4 < 0) {
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                        }
                    }
                } else {
                    by = (byte)4;
                }
            } else {
                by = (byte)n3;
                if (n4 != 0) {
                    if (n4 != 1) throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                    by = (byte)n3;
                }
            }
            settings.set(by, n4);
        }
        handler.settings(false, settings);
    }

    private void readWindowUpdate(Handler handler, int n, byte by, int n2) throws IOException {
        if (n == 4) {
            long l = (long)this.source.readInt() & Integer.MAX_VALUE;
            if (l != 0L) {
                handler.windowUpdate(n2, l);
                return;
            }
            throw Http2.ioException("windowSizeIncrement was 0", l);
        }
        throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", n);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    public boolean nextFrame(boolean bl, Handler handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (EOFException eOFException) {
            return false;
        }
        int n = Http2Reader.readMedium(this.source);
        if (n >= 0 && n <= 16384) {
            byte by = (byte)(this.source.readByte() & 0xFF);
            if (bl && by != 4) {
                throw Http2.ioException("Expected a SETTINGS frame but was %s", by);
            }
            byte by2 = (byte)(this.source.readByte() & 0xFF);
            int n2 = this.source.readInt() & Integer.MAX_VALUE;
            Logger logger = Http2Reader.logger;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.frameLog(true, n2, n, by, by2));
            }
            switch (by) {
                default: {
                    this.source.skip(n);
                    break;
                }
                case 8: {
                    this.readWindowUpdate(handler, n, by2, n2);
                    break;
                }
                case 7: {
                    this.readGoAway(handler, n, by2, n2);
                    break;
                }
                case 6: {
                    this.readPing(handler, n, by2, n2);
                    break;
                }
                case 5: {
                    this.readPushPromise(handler, n, by2, n2);
                    break;
                }
                case 4: {
                    this.readSettings(handler, n, by2, n2);
                    break;
                }
                case 3: {
                    this.readRstStream(handler, n, by2, n2);
                    break;
                }
                case 2: {
                    this.readPriority(handler, n, by2, n2);
                    break;
                }
                case 1: {
                    this.readHeaders(handler, n, by2, n2);
                    break;
                }
                case 0: {
                    this.readData(handler, n, by2, n2);
                }
            }
            return true;
        }
        throw Http2.ioException("FRAME_SIZE_ERROR: %s", n);
    }

    public void readConnectionPreface(Handler object) throws IOException {
        ByteString byteString;
        block8: {
            block7: {
                block6: {
                    if (!this.client) break block6;
                    if (!this.nextFrame(true, (Handler)object)) {
                        throw Http2.ioException("Required SETTINGS preface not received", new Object[0]);
                    }
                    break block7;
                }
                byteString = this.source.readByteString(Http2.CONNECTION_PREFACE.size());
                object = logger;
                if (((Logger)object).isLoggable(Level.FINE)) {
                    ((Logger)object).fine(Util.format("<< CONNECTION %s", byteString.hex()));
                }
                if (!Http2.CONNECTION_PREFACE.equals(byteString)) break block8;
            }
            return;
        }
        throw Http2.ioException("Expected a connection header but was %s", byteString.utf8());
    }

    static final class ContinuationSource
    implements Source {
        byte flags;
        int left;
        int length;
        short padding;
        private final BufferedSource source;
        int streamId;

        ContinuationSource(BufferedSource bufferedSource) {
            this.source = bufferedSource;
        }

        private void readContinuationHeader() throws IOException {
            int n;
            int n2 = this.streamId;
            this.left = n = Http2Reader.readMedium(this.source);
            this.length = n;
            byte by = (byte)(this.source.readByte() & 0xFF);
            this.flags = (byte)(this.source.readByte() & 0xFF);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.frameLog(true, this.streamId, this.length, by, this.flags));
            }
            this.streamId = n = this.source.readInt() & Integer.MAX_VALUE;
            if (by == 9) {
                if (n == n2) {
                    return;
                }
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
            throw Http2.ioException("%s != TYPE_CONTINUATION", by);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            int n;
            while ((n = this.left) == 0) {
                this.source.skip(this.padding);
                this.padding = (short)0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            if ((l = this.source.read(buffer, Math.min(l, (long)n))) == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - l);
            return l;
        }

        @Override
        public Timeout timeout() {
            return this.source.timeout();
        }
    }

    static interface Handler {
        public void ackSettings();

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);

        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void ping(boolean var1, int var2, int var3);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void windowUpdate(int var1, long var2);
    }
}

