/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.StreamResetException;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http2Stream {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    long bytesLeftInWriteWindow;
    final Http2Connection connection;
    @Nullable
    ErrorCode errorCode;
    @Nullable
    IOException errorException;
    private boolean hasResponseHeaders;
    private final Deque<Headers> headersQueue;
    final int id;
    final StreamTimeout readTimeout;
    final FramingSink sink;
    private final FramingSource source;
    long unacknowledgedBytesRead = 0L;
    final StreamTimeout writeTimeout;

    Http2Stream(int n, Http2Connection closeable, boolean bl, boolean bl2, @Nullable Headers headers) {
        FramingSink framingSink;
        ArrayDeque<Headers> arrayDeque = new ArrayDeque<Headers>();
        this.headersQueue = arrayDeque;
        this.readTimeout = new StreamTimeout();
        this.writeTimeout = new StreamTimeout();
        Objects.requireNonNull(closeable, "connection == null");
        this.id = n;
        this.connection = closeable;
        this.bytesLeftInWriteWindow = closeable.peerSettings.getInitialWindowSize();
        closeable = new FramingSource(closeable.okHttpSettings.getInitialWindowSize());
        this.source = closeable;
        this.sink = framingSink = new FramingSink();
        ((FramingSource)closeable).finished = bl2;
        framingSink.finished = bl;
        if (headers != null) {
            arrayDeque.add(headers);
        }
        if (this.isLocallyInitiated() && headers != null) {
            throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
        }
        if (!this.isLocallyInitiated() && headers == null) {
            throw new IllegalStateException("remotely-initiated streams should have headers");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeInternal(ErrorCode errorCode, @Nullable IOException iOException) {
        synchronized (this) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.errorException = iOException;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    void addBytesToWriteWindow(long l) {
        this.bytesLeftInWriteWindow += l;
        if (l > 0L) {
            this.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void cancelStreamIfNecessary() throws IOException {
        // MONITORENTER : this
        boolean bl = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
        boolean bl2 = this.isOpen();
        // MONITOREXIT : this
        if (bl) {
            this.close(ErrorCode.CANCEL, null);
            return;
        }
        if (bl2) return;
        this.connection.removeStream(this.id);
    }

    void checkOutNotClosed() throws IOException {
        if (!this.sink.closed) {
            if (!this.sink.finished) {
                if (this.errorCode != null) {
                    IOException iOException = this.errorException;
                    if (iOException == null) {
                        iOException = new StreamResetException(this.errorCode);
                    }
                    throw iOException;
                }
                return;
            }
            throw new IOException("stream finished");
        }
        throw new IOException("stream closed");
    }

    public void close(ErrorCode errorCode, @Nullable IOException iOException) throws IOException {
        if (!this.closeInternal(errorCode, iOException)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueTrailers(Headers object) {
        synchronized (this) {
            if (this.sink.finished) {
                object = new IllegalStateException("already finished");
                throw object;
            }
            if (((Headers)object).size() != 0) {
                FramingSink.access$302(this.sink, (Headers)object);
                return;
            }
            object = new IllegalArgumentException("trailers.size() == 0");
            throw object;
        }
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public ErrorCode getErrorCode() {
        synchronized (this) {
            ErrorCode errorCode = this.errorCode;
            return errorCode;
        }
    }

    public int getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sink getSink() {
        synchronized (this) {
            if (!this.hasResponseHeaders && !this.isLocallyInitiated()) {
                IllegalStateException illegalStateException = new IllegalStateException("reply before requesting the sink");
                throw illegalStateException;
            }
            return this.sink;
        }
    }

    public Source getSource() {
        return this.source;
    }

    public boolean isLocallyInitiated() {
        int n = this.id;
        boolean bl = true;
        boolean bl2 = (n & 1) == 1;
        bl2 = this.connection.client == bl2 ? bl : false;
        return bl2;
    }

    public boolean isOpen() {
        synchronized (this) {
            block5: {
                boolean bl;
                block4: {
                    ErrorCode errorCode = this.errorCode;
                    if (errorCode == null) break block4;
                    return false;
                }
                if (!this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || !(bl = this.hasResponseHeaders)) break block5;
                return false;
            }
            return true;
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    void receiveData(BufferedSource bufferedSource, int n) throws IOException {
        this.source.receive(bufferedSource, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receiveHeaders(Headers headers, boolean bl) {
        // MONITORENTER : this
        if (this.hasResponseHeaders && bl) {
            FramingSource.access$202(this.source, headers);
        } else {
            this.hasResponseHeaders = true;
            this.headersQueue.add(headers);
        }
        if (bl) {
            this.source.finished = true;
        }
        bl = this.isOpen();
        this.notifyAll();
        // MONITOREXIT : this
        if (bl) return;
        this.connection.removeStream(this.id);
    }

    void receiveRstStream(ErrorCode errorCode) {
        synchronized (this) {
            if (this.errorCode == null) {
                this.errorCode = errorCode;
                this.notifyAll();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Headers takeHeaders() throws IOException {
        synchronized (this) {
            block8: {
                this.readTimeout.enter();
                while (this.headersQueue.isEmpty() && this.errorCode == null) {
                    this.waitForIo();
                }
                if (this.headersQueue.isEmpty()) break block8;
                Headers headers = this.headersQueue.removeFirst();
                return headers;
            }
            IOException iOException = this.errorException;
            if (iOException != null) {
                throw iOException;
            }
            iOException = new StreamResetException(this.errorCode);
            throw iOException;
            finally {
                this.readTimeout.exitAndThrowIfTimedOut();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Headers trailers() throws IOException {
        synchronized (this) {
            if (this.errorCode != null) {
                IOException iOException = this.errorException;
                if (iOException != null) {
                    throw iOException;
                }
                iOException = new StreamResetException(this.errorCode);
                throw iOException;
            }
            if (this.source.finished && this.source.receiveBuffer.exhausted() && this.source.readBuffer.exhausted()) {
                if (this.source.trailers == null) return Util.EMPTY_HEADERS;
                return this.source.trailers;
            }
            IllegalStateException illegalStateException = new IllegalStateException("too early; can't read the trailers yet");
            throw illegalStateException;
        }
    }

    void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeHeaders(List<Header> list, boolean bl, boolean bl2) throws IOException {
        Objects.requireNonNull(list, "headers == null");
        synchronized (this) {
            this.hasResponseHeaders = true;
            if (bl) {
                this.sink.finished = true;
            }
        }
        boolean bl3 = bl2;
        if (!bl2) {
            Http2Connection http2Connection = this.connection;
            synchronized (http2Connection) {
                bl2 = this.connection.bytesLeftInWriteWindow == 0L;
            }
            bl3 = bl2;
        }
        this.connection.writeHeaders(this.id, bl, list);
        if (bl3) {
            this.connection.flush();
        }
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    final class FramingSink
    implements Sink {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private static final long EMIT_BUFFER_SIZE = 16384L;
        boolean closed;
        boolean finished;
        private final Buffer sendBuffer = new Buffer();
        private Headers trailers;

        FramingSink() {
        }

        static /* synthetic */ Headers access$302(FramingSink framingSink, Headers headers) {
            framingSink.trailers = headers;
            return headers;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void emitFrame(boolean bl) throws IOException {
            Throwable throwable2;
            block13: {
                long l;
                block12: {
                    block11: {
                        Http2Stream http2Stream = Http2Stream.this;
                        synchronized (http2Stream) {
                            Http2Stream.this.writeTimeout.enter();
                            while (Http2Stream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                                Http2Stream.this.waitForIo();
                            }
                            Http2Stream.this.checkOutNotClosed();
                            l = Math.min(Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                            Http2Stream http2Stream2 = Http2Stream.this;
                            http2Stream2.bytesLeftInWriteWindow -= l;
                        }
                        Http2Stream.this.writeTimeout.enter();
                        if (bl) {
                            try {
                                if (l != this.sendBuffer.size()) break block11;
                                bl = true;
                                break block12;
                            }
                            catch (Throwable throwable2) {
                                break block13;
                            }
                        }
                    }
                    bl = false;
                }
                Http2Stream.this.connection.writeData(Http2Stream.this.id, bl, this.sendBuffer, l);
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                return;
            }
            Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
            throw throwable2;
            {
                finally {
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            Http2Stream http2Stream = Http2Stream.this;
            // MONITORENTER : http2Stream
            if (this.closed) {
                // MONITOREXIT : http2Stream
                return;
            }
            // MONITOREXIT : http2Stream
            if (!Http2Stream.this.sink.finished) {
                boolean bl = this.sendBuffer.size() > 0L;
                boolean bl2 = this.trailers != null;
                if (bl2) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Stream.this.connection.writeHeaders(Http2Stream.this.id, true, Util.toHeaderBlock(this.trailers));
                } else if (bl) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else {
                    Http2Stream.this.connection.writeData(Http2Stream.this.id, true, null, 0L);
                }
            }
            Http2Stream http2Stream2 = Http2Stream.this;
            // MONITORENTER : http2Stream2
            this.closed = true;
            // MONITOREXIT : http2Stream2
            Http2Stream.this.connection.flush();
            Http2Stream.this.cancelStreamIfNecessary();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void flush() throws IOException {
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                Http2Stream.this.connection.flush();
            }
            return;
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            this.sendBuffer.write(buffer, l);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }
    }

    private final class FramingSource
    implements Source {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        boolean closed;
        boolean finished;
        private final long maxByteCount;
        private final Buffer readBuffer;
        private final Buffer receiveBuffer = new Buffer();
        private Headers trailers;

        FramingSource(long l) {
            this.readBuffer = new Buffer();
            this.maxByteCount = l;
        }

        static /* synthetic */ Headers access$202(FramingSource framingSource, Headers headers) {
            framingSource.trailers = headers;
            return headers;
        }

        private void updateConnectionFlowControl(long l) {
            Http2Stream.this.connection.updateConnectionFlowControl(l);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            Http2Stream http2Stream = Http2Stream.this;
            // MONITORENTER : http2Stream
            this.closed = true;
            long l = this.readBuffer.size();
            this.readBuffer.clear();
            Http2Stream.this.notifyAll();
            // MONITOREXIT : http2Stream
            if (l > 0L) {
                this.updateConnectionFlowControl(l);
            }
            Http2Stream.this.cancelStreamIfNecessary();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public long read(Buffer object, long l) throws IOException {
            block13: {
                IOException iOException;
                block14: {
                    if (l < 0L) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("byteCount < 0: ");
                        ((StringBuilder)object).append(l);
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    while (true) {
                        iOException = null;
                        Http2Stream http2Stream = Http2Stream.this;
                        // MONITORENTER : http2Stream
                        Http2Stream.this.readTimeout.enter();
                        if (Http2Stream.this.errorCode != null) {
                            iOException = Http2Stream.this.errorException != null ? Http2Stream.this.errorException : new StreamResetException(Http2Stream.this.errorCode);
                        }
                        if (this.closed) break block13;
                        if (this.readBuffer.size() > 0L) {
                            Buffer buffer = this.readBuffer;
                            long l2 = buffer.read((Buffer)object, Math.min(l, buffer.size()));
                            object = Http2Stream.this;
                            ((Http2Stream)object).unacknowledgedBytesRead += l2;
                            l = l2;
                            if (iOException != null) break block14;
                            l = l2;
                            if (Http2Stream.this.unacknowledgedBytesRead >= (long)(Http2Stream.this.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                                Http2Stream.this.connection.writeWindowUpdateLater(Http2Stream.this.id, Http2Stream.this.unacknowledgedBytesRead);
                                Http2Stream.this.unacknowledgedBytesRead = 0L;
                                l = l2;
                            }
                            break block14;
                        }
                        if (this.finished || iOException != null) break;
                        Http2Stream.this.waitForIo();
                        Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                        // MONITOREXIT : http2Stream
                    }
                    l = -1L;
                }
                Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                // MONITOREXIT : http2Stream
                if (l != -1L) {
                    this.updateConnectionFlowControl(l);
                    return l;
                }
                if (iOException != null) throw iOException;
                return -1L;
            }
            try {
                object = new IOException("stream closed");
                throw object;
            }
            catch (Throwable throwable) {
                Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void receive(BufferedSource bufferedSource, long l) throws IOException {
            while (l > 0L) {
                Http2Stream http2Stream = Http2Stream.this;
                // MONITORENTER : http2Stream
                boolean bl = this.finished;
                long l2 = this.readBuffer.size();
                long l3 = this.maxByteCount;
                boolean bl2 = true;
                boolean bl3 = l2 + l > l3;
                // MONITOREXIT : http2Stream
                if (bl3) {
                    bufferedSource.skip(l);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (bl) {
                    bufferedSource.skip(l);
                    return;
                }
                l2 = bufferedSource.read(this.receiveBuffer, l);
                if (l2 == -1L) throw new EOFException();
                l3 = l - l2;
                http2Stream = Http2Stream.this;
                // MONITORENTER : http2Stream
                if (this.closed) {
                    l2 = this.receiveBuffer.size();
                    this.receiveBuffer.clear();
                } else {
                    bl3 = this.readBuffer.size() == 0L ? bl2 : false;
                    this.readBuffer.writeAll(this.receiveBuffer);
                    if (bl3) {
                        Http2Stream.this.notifyAll();
                    }
                    l2 = 0L;
                }
                // MONITOREXIT : http2Stream
                l = l3;
                if (l2 <= 0L) continue;
                this.updateConnectionFlowControl(l2);
                l = l3;
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (!this.exit()) {
                return;
            }
            throw this.newTimeoutException(null);
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
            Http2Stream.this.connection.sendDegradedPingLater();
        }
    }
}

