/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final boolean client;
    private boolean closed;
    private final Buffer hpackBuffer;
    final Hpack.Writer hpackWriter;
    private int maxFrameSize;
    private final BufferedSink sink;

    Http2Writer(BufferedSink bufferedSink, boolean bl) {
        this.sink = bufferedSink;
        this.client = bl;
        bufferedSink = new Buffer();
        this.hpackBuffer = bufferedSink;
        this.hpackWriter = new Hpack.Writer((Buffer)bufferedSink);
        this.maxFrameSize = 16384;
    }

    private void writeContinuationFrames(int n, long l) throws IOException {
        while (l > 0L) {
            byte by;
            int n2;
            long l2;
            byte by2 = (l -= (l2 = (long)(n2 = (int)Math.min((long)this.maxFrameSize, l)))) == 0L ? (by = 4) : (by = 0);
            this.frameHeader(n, n2, (byte)9, by2);
            this.sink.write(this.hpackBuffer, l2);
        }
    }

    private static void writeMedium(BufferedSink bufferedSink, int n) throws IOException {
        bufferedSink.writeByte(n >>> 16 & 0xFF);
        bufferedSink.writeByte(n >>> 8 & 0xFF);
        bufferedSink.writeByte(n & 0xFF);
    }

    public void applyAndAckSettings(Settings object) throws IOException {
        synchronized (this) {
            if (!this.closed) {
                this.maxFrameSize = ((Settings)object).getMaxFrameSize(this.maxFrameSize);
                if (((Settings)object).getHeaderTableSize() != -1) {
                    this.hpackWriter.setHeaderTableSizeSetting(((Settings)object).getHeaderTableSize());
                }
                this.frameHeader(0, 0, (byte)4, (byte)1);
                this.sink.flush();
                return;
            }
            object = new IOException("closed");
            throw object;
        }
    }

    @Override
    public void close() throws IOException {
        synchronized (this) {
            this.closed = true;
            this.sink.close();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectionPreface() throws IOException {
        synchronized (this) {
            if (this.closed) {
                IOException iOException = new IOException("closed");
                throw iOException;
            }
            boolean bl = this.client;
            if (!bl) {
                return;
            }
            Logger logger = Http2Writer.logger;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format(">> CONNECTION %s", Http2.CONNECTION_PREFACE.hex()));
            }
            this.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
            this.sink.flush();
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void data(boolean bl, int n, Buffer object, int n2) throws IOException {
        synchronized (this) {
            void var4_4;
            byte by;
            if (this.closed) {
                object = new IOException("closed");
                throw object;
            }
            byte by2 = by = 0;
            if (bl) {
                by2 = by = (byte)1;
            }
            this.dataFrame(n, by2, (Buffer)object, (int)var4_4);
            return;
        }
    }

    void dataFrame(int n, byte by, Buffer buffer, int n2) throws IOException {
        this.frameHeader(n, n2, (byte)0, by);
        if (n2 > 0) {
            this.sink.write(buffer, (long)n2);
        }
    }

    public void flush() throws IOException {
        synchronized (this) {
            if (!this.closed) {
                this.sink.flush();
                return;
            }
            IOException iOException = new IOException("closed");
            throw iOException;
        }
    }

    public void frameHeader(int n, int n2, byte by, byte by2) throws IOException {
        int n3;
        Logger logger = Http2Writer.logger;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n, n2, by, by2));
        }
        if (n2 <= (n3 = this.maxFrameSize)) {
            if ((Integer.MIN_VALUE & n) == 0) {
                Http2Writer.writeMedium(this.sink, n2);
                this.sink.writeByte(by & 0xFF);
                this.sink.writeByte(by2 & 0xFF);
                this.sink.writeInt(n & Integer.MAX_VALUE);
                return;
            }
            throw Http2.illegalArgument("reserved bit set: %s", n);
        }
        throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", n3, n2);
    }

    public void goAway(int n, ErrorCode object, byte[] byArray) throws IOException {
        synchronized (this) {
            if (!this.closed) {
                if (object.httpCode != -1) {
                    this.frameHeader(0, byArray.length + 8, (byte)7, (byte)0);
                    this.sink.writeInt(n);
                    this.sink.writeInt(object.httpCode);
                    if (byArray.length > 0) {
                        this.sink.write(byArray);
                    }
                    this.sink.flush();
                    return;
                }
                throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
            }
            object = new IOException("closed");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void headers(boolean bl, int n, List<Header> object) throws IOException {
        synchronized (this) {
            if (this.closed) {
                object = new IOException("closed");
                throw object;
            }
            this.hpackWriter.writeHeaders((List<Header>)object);
            long l = this.hpackBuffer.size();
            int n2 = (int)Math.min((long)this.maxFrameSize, l);
            long l2 = n2;
            long l3 = l == l2 ? 0 : (l < l2 ? -1 : 1);
            byte by = l3 == false ? (byte)4 : 0;
            byte by2 = by;
            if (bl) {
                by2 = by = (byte)((byte)(by | 1));
            }
            this.frameHeader(n, n2, (byte)1, by2);
            this.sink.write(this.hpackBuffer, l2);
            if (l3 > 0) {
                this.writeContinuationFrames(n, l - l2);
            }
            return;
        }
    }

    public int maxDataLength() {
        return this.maxFrameSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ping(boolean bl, int n, int n2) throws IOException {
        synchronized (this) {
            byte by;
            byte by2;
            if (this.closed) {
                IOException iOException = new IOException("closed");
                throw iOException;
            }
            byte by3 = bl ? (by2 = 1) : (by = 0);
            this.frameHeader(0, 8, (byte)6, by3);
            this.sink.writeInt(n);
            this.sink.writeInt(n2);
            this.sink.flush();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pushPromise(int n, int n2, List<Header> object) throws IOException {
        synchronized (this) {
            byte by;
            byte by2;
            if (this.closed) {
                object = new IOException("closed");
                throw object;
            }
            this.hpackWriter.writeHeaders((List<Header>)object);
            long l = this.hpackBuffer.size();
            int n3 = (int)Math.min((long)(this.maxFrameSize - 4), l);
            long l2 = n3;
            long l3 = l == l2 ? 0 : (l < l2 ? -1 : 1);
            byte by3 = l3 == false ? (by2 = 4) : (by = 0);
            this.frameHeader(n, n3 + 4, (byte)5, by3);
            this.sink.writeInt(n2 & Integer.MAX_VALUE);
            this.sink.write(this.hpackBuffer, l2);
            if (l3 > 0) {
                this.writeContinuationFrames(n, l - l2);
            }
            return;
        }
    }

    public void rstStream(int n, ErrorCode object) throws IOException {
        synchronized (this) {
            if (!this.closed) {
                if (object.httpCode != -1) {
                    this.frameHeader(n, 4, (byte)3, (byte)0);
                    this.sink.writeInt(object.httpCode);
                    this.sink.flush();
                    return;
                }
                object = new IllegalArgumentException();
                throw object;
            }
            object = new IOException("closed");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void settings(Settings object) throws IOException {
        synchronized (this) {
            if (this.closed) {
                object = new IOException("closed");
                throw object;
            }
            int n = ((Settings)object).size();
            int n2 = 0;
            this.frameHeader(0, n * 6, (byte)4, (byte)0);
            while (true) {
                if (n2 >= 10) {
                    this.sink.flush();
                    return;
                }
                if (((Settings)object).isSet(n2)) {
                    n = n2 == 4 ? 3 : (n2 == 7 ? 4 : n2);
                    this.sink.writeShort(n);
                    this.sink.writeInt(((Settings)object).get(n2));
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void windowUpdate(int n, long l) throws IOException {
        synchronized (this) {
            if (this.closed) {
                IOException iOException = new IOException("closed");
                throw iOException;
            }
            if (l != 0L && l <= Integer.MAX_VALUE) {
                this.frameHeader(n, 4, (byte)8, (byte)0);
                this.sink.writeInt((int)l);
                this.sink.flush();
                return;
            }
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", l);
        }
    }
}

