/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.util.Arrays;

public final class Settings {
    static final int COUNT = 10;
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    static final int ENABLE_PUSH = 2;
    static final int HEADER_TABLE_SIZE = 1;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int MAX_FRAME_SIZE = 5;
    static final int MAX_HEADER_LIST_SIZE = 6;
    private int set;
    private final int[] values = new int[10];

    void clear() {
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    int get(int n) {
        return this.values[n];
    }

    boolean getEnablePush(boolean bl) {
        int n = this.set;
        boolean bl2 = false;
        n = (n & 4) != 0 ? this.values[2] : (bl ? 1 : 0);
        bl = bl2;
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    int getHeaderTableSize() {
        int n = (this.set & 2) != 0 ? this.values[1] : -1;
        return n;
    }

    int getInitialWindowSize() {
        int n = (this.set & 0x80) != 0 ? this.values[7] : 65535;
        return n;
    }

    int getMaxConcurrentStreams(int n) {
        if ((this.set & 0x10) != 0) {
            n = this.values[4];
        }
        return n;
    }

    int getMaxFrameSize(int n) {
        if ((this.set & 0x20) != 0) {
            n = this.values[5];
        }
        return n;
    }

    int getMaxHeaderListSize(int n) {
        if ((this.set & 0x40) != 0) {
            n = this.values[6];
        }
        return n;
    }

    boolean isSet(int n) {
        boolean bl = true;
        if ((1 << n & this.set) == 0) {
            bl = false;
        }
        return bl;
    }

    void merge(Settings settings) {
        for (int i = 0; i < 10; ++i) {
            if (!settings.isSet(i)) continue;
            this.set(i, settings.get(i));
        }
    }

    Settings set(int n, int n2) {
        int[] nArray;
        if (n >= 0 && n < (nArray = this.values).length) {
            this.set = 1 << n | this.set;
            nArray[n] = n2;
        }
        return this;
    }

    int size() {
        return Integer.bitCount(this.set);
    }
}

