/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.net.ssl.SSLSockets;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import okhttp3.Protocol;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.Platform;

class Android10Platform
extends AndroidPlatform {
    Android10Platform(Class<?> clazz) {
        super(clazz, null, null, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Platform buildIfSupported() {
        try {
            if (Android10Platform.getSdkInt() < 29) return null;
            return new Android10Platform(Class.forName("com.android.org.conscrypt.SSLParametersImpl"));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    private void enableSessionTickets(SSLSocket sSLSocket) {
        if (SSLSockets.isSupportedSocket((SSLSocket)sSLSocket)) {
            SSLSockets.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) {
        this.enableSessionTickets(sSLSocket);
        object = sSLSocket.getSSLParameters();
        ((SSLParameters)object).setApplicationProtocols(Platform.alpnProtocolNames(list).toArray(new String[0]));
        sSLSocket.setSSLParameters((SSLParameters)object);
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        if ((object = ((SSLSocket)object).getApplicationProtocol()) != null && !((String)object).isEmpty()) {
            return object;
        }
        return null;
    }
}

