/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final CloseGuard closeGuard = CloseGuard.get();
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    private final Method setHostname;
    private final Method setUseSessionTickets;
    private final Class<?> sslParametersClass;
    private final Class<?> sslSocketClass;

    AndroidPlatform(Class<?> clazz, Class<?> clazz2, Method method, Method method2, Method method3, Method method4) {
        this.sslParametersClass = clazz;
        this.sslSocketClass = clazz2;
        this.setUseSessionTickets = method;
        this.setHostname = method2;
        this.getAlpnSelectedProtocol = method3;
        this.setAlpnProtocols = method4;
    }

    private boolean api23IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            boolean bl = (Boolean)clazz.getMethod("isCleartextTrafficPermitted", new Class[0]).invoke(object, new Object[0]);
            return bl;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string2);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            boolean bl = (Boolean)clazz.getMethod("isCleartextTrafficPermitted", String.class).invoke(object, string2);
            return bl;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string2, clazz, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Platform buildIfSupported() {
        Object object;
        block5: {
            Class<?> clazz;
            if (AndroidPlatform.getSdkInt() == 0) {
                return null;
            }
            try {
                object = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
                clazz = Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
                if (Build.VERSION.SDK_INT < 21) break block5;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            try {
                return new AndroidPlatform((Class<?>)object, clazz, clazz.getDeclaredMethod("setUseSessionTickets", Boolean.TYPE), clazz.getMethod("setHostname", String.class), clazz.getMethod("getAlpnSelectedProtocol", new Class[0]), clazz.getMethod("setAlpnProtocols", byte[].class));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Expected Android API level 21+ but was ");
        ((StringBuilder)object).append(Build.VERSION.SDK_INT);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    static int getSdkInt() {
        try {
            int n = Build.VERSION.SDK_INT;
            return n;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return 0;
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        try {
            Object object = Class.forName("android.net.http.X509TrustManagerExtensions");
            object = new AndroidCertificateChainCleaner(((Class)object).getConstructor(X509TrustManager.class).newInstance(x509TrustManager), ((Class)object).getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class));
            return object;
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        try {
            Object object = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            ((Method)object).setAccessible(true);
            object = new CustomTrustRootIndex(x509TrustManager, (Method)object);
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void configureTlsExtensions(SSLSocket var1_1, String var2_5, List<Protocol> var3_6) {
        if (!this.sslSocketClass.isInstance(var1_1)) {
            return;
        }
        if (var2_5 == null) ** GOTO lbl9
        try {
            this.setUseSessionTickets.invoke((Object)var1_1, new Object[]{true});
            this.setHostname.invoke((Object)var1_1, new Object[]{var2_5});
lbl9:
            // 2 sources

            this.setAlpnProtocols.invoke((Object)var1_1, new Object[]{AndroidPlatform.concatLengthPrefixed(var3_6)});
            return;
        }
        catch (InvocationTargetException var1_2) {
        }
        catch (IllegalAccessException var1_3) {
            // empty catch block
        }
        throw new AssertionError(var1_4);
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        try {
            socket.connect(inetSocketAddress, n);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", classCastException);
            }
            throw classCastException;
        }
        catch (AssertionError assertionError) {
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError));
            }
            throw assertionError;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SSLContext getSSLContext() {
        boolean bl = true;
        try {
            int n;
            if (Build.VERSION.SDK_INT < 16 || (n = Build.VERSION.SDK_INT) >= 22) {
                bl = false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (bl) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        void var1_4;
        block6: {
            block5: {
                boolean bl = this.sslSocketClass.isInstance(object);
                Object var3_6 = null;
                if (!bl) {
                    return null;
                }
                byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invoke(object, new Object[0]);
                object = var3_6;
                if (byArray == null) break block5;
                try {
                    object = new String(byArray, StandardCharsets.UTF_8);
                }
                catch (InvocationTargetException invocationTargetException) {
                    break block6;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return object;
        }
        throw new AssertionError(var1_4);
    }

    @Override
    @Nullable
    public Object getStackTraceForCloseable(String string2) {
        return this.closeGuard.createAndOpen(string2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCleartextTrafficPermitted(String string2) {
        void var1_5;
        try {
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            return this.api24IsCleartextTrafficPermitted(string2, clazz, clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError("unable to determine cleartext support", (Throwable)var1_5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError("unable to determine cleartext support", (Throwable)var1_5);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
            throw new AssertionError("unable to determine cleartext support", (Throwable)var1_5);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return super.isCleartextTrafficPermitted(string2);
        }
    }

    @Override
    public void log(int n, String string2, @Nullable Throwable throwable) {
        int n2 = 5;
        if (n != 5) {
            n2 = 3;
        }
        CharSequence charSequence = string2;
        if (throwable != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append('\n');
            ((StringBuilder)charSequence).append(Log.getStackTraceString((Throwable)throwable));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        n = 0;
        int n3 = ((String)charSequence).length();
        block0: while (n < n3) {
            int n4 = ((String)charSequence).indexOf(10, n);
            if (n4 == -1) {
                n4 = n3;
            }
            while (true) {
                int n5 = Math.min(n4, n + 4000);
                Log.println((int)n2, (String)"OkHttp", (String)((String)charSequence).substring(n, n5));
                if (n5 >= n4) {
                    n = n5 + 1;
                    continue block0;
                }
                n = n5;
            }
        }
    }

    @Override
    public void logCloseableLeak(String string2, Object object) {
        if (!this.closeGuard.warnIfOpen(object)) {
            this.log(5, string2, null);
        }
    }

    @Override
    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory object) {
        Object obj;
        Object obj2 = obj = AndroidPlatform.readFieldOrNull(object, this.sslParametersClass, "sslParameters");
        if (obj == null) {
            try {
                obj2 = AndroidPlatform.readFieldOrNull(object, Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, object.getClass().getClassLoader()), "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager((SSLSocketFactory)object);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(obj2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(obj2, X509TrustManager.class, "trustManager");
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Method checkServerTrusted;
        private final Object x509TrustManagerExtensions;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        @Override
        public List<Certificate> clean(List<Certificate> object, String string2) throws SSLPeerUnverifiedException {
            try {
                object = object.toArray(new X509Certificate[object.size()]);
                object = (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, object, "RSA", string2);
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                ((Throwable)object).initCause(invocationTargetException);
                throw object;
            }
        }

        public boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        static CloseGuard get() {
            GenericDeclaration genericDeclaration;
            GenericDeclaration genericDeclaration2;
            Method method = null;
            try {
                genericDeclaration2 = Class.forName("dalvik.system.CloseGuard");
                genericDeclaration = genericDeclaration2.getMethod("get", new Class[0]);
                Method method2 = genericDeclaration2.getMethod("open", String.class);
                genericDeclaration2 = genericDeclaration2.getMethod("warnIfOpen", new Class[0]);
                method = genericDeclaration;
                genericDeclaration = genericDeclaration2;
                genericDeclaration2 = method2;
            }
            catch (Exception exception) {
                genericDeclaration = null;
                genericDeclaration2 = genericDeclaration;
            }
            return new CloseGuard(method, (Method)genericDeclaration2, (Method)genericDeclaration);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Object createAndOpen(String string2) {
            Object object = this.getMethod;
            if (object == null) return null;
            try {
                object = ((Method)object).invoke(null, new Object[0]);
                this.openMethod.invoke(object, string2);
                return object;
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean warnIfOpen(Object object) {
            boolean bl;
            boolean bl2 = bl = false;
            if (object == null) return bl2;
            try {
                this.warnIfOpenMethod.invoke(object, new Object[0]);
                return true;
            }
            catch (Exception exception) {
                return bl;
            }
        }
    }

    static final class CustomTrustRootIndex
    implements TrustRootIndex {
        private final Method findByIssuerAndSignatureMethod;
        private final X509TrustManager trustManager;

        CustomTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (object == this) {
                return true;
            }
            if (!(object instanceof CustomTrustRootIndex)) {
                return false;
            }
            object = (CustomTrustRootIndex)object;
            if (!this.trustManager.equals(((CustomTrustRootIndex)object).trustManager) || !this.findByIssuerAndSignatureMethod.equals(((CustomTrustRootIndex)object).findByIssuerAndSignatureMethod)) {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
            Object var2_4 = null;
            TrustAnchor trustAnchor = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, x509Certificate);
            x509Certificate = var2_4;
            if (trustAnchor == null) return x509Certificate;
            try {
                return trustAnchor.getTrustedCert();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError("unable to get issues and signature", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return var2_4;
            }
        }

        public int hashCode() {
            return this.trustManager.hashCode() + this.findByIssuerAndSignatureMethod.hashCode() * 31;
        }
    }
}

