/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;

class Jdk8WithJettyBootPlatform
extends Platform {
    private final Class<?> clientProviderClass;
    private final Method getMethod;
    private final Method putMethod;
    private final Method removeMethod;
    private final Class<?> serverProviderClass;

    Jdk8WithJettyBootPlatform(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2) {
        this.putMethod = method;
        this.getMethod = method2;
        this.removeMethod = method3;
        this.clientProviderClass = clazz;
        this.serverProviderClass = clazz2;
    }

    public static Platform buildIfSupported() {
        try {
            Object object = Class.forName("org.eclipse.jetty.alpn.ALPN", true, null);
            Serializable serializable = new StringBuilder();
            serializable.append("org.eclipse.jetty.alpn.ALPN");
            serializable.append("$Provider");
            serializable = Class.forName(serializable.toString(), true, null);
            Serializable serializable2 = new StringBuilder();
            serializable2.append("org.eclipse.jetty.alpn.ALPN");
            serializable2.append("$ClientProvider");
            serializable2 = Class.forName(serializable2.toString(), true, null);
            Serializable serializable3 = new StringBuilder();
            serializable3.append("org.eclipse.jetty.alpn.ALPN");
            serializable3.append("$ServerProvider");
            serializable3 = Class.forName(serializable3.toString(), true, null);
            object = new Jdk8WithJettyBootPlatform(((Class)object).getMethod("put", new Class[]{SSLSocket.class, serializable}), ((Class)object).getMethod("get", SSLSocket.class), ((Class)object).getMethod("remove", SSLSocket.class), (Class<?>)serializable2, (Class<?>)serializable3);
            return object;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterHandshake(SSLSocket sSLSocket) {
        void var1_4;
        try {
            this.removeMethod.invoke(null, sSLSocket);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new AssertionError("failed to remove ALPN", (Throwable)var1_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> object2) {
        void var1_4;
        List<String> list = Jdk8WithJettyBootPlatform.alpnProtocolNames(object2);
        try {
            object2 = Platform.class.getClassLoader();
            object = this.clientProviderClass;
            Class<?> clazz = this.serverProviderClass;
            AlpnProvider alpnProvider = new AlpnProvider(list);
            object = Proxy.newProxyInstance((ClassLoader)object2, new Class[]{object, clazz}, (InvocationHandler)alpnProvider);
            this.putMethod.invoke(null, sSLSocket, object);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new AssertionError("failed to set ALPN", (Throwable)var1_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        void var1_4;
        block9: {
            block8: {
                block7: {
                    Object var3_6;
                    block6: {
                        Method method = this.getMethod;
                        var3_6 = null;
                        object = (AlpnProvider)Proxy.getInvocationHandler(method.invoke(null, object));
                        if (((AlpnProvider)object).unsupported || ((AlpnProvider)object).selected != null) break block6;
                        Platform.get().log(4, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", null);
                        return null;
                    }
                    if (!((AlpnProvider)object).unsupported) break block7;
                    object = var3_6;
                    break block8;
                }
                try {
                    object = ((AlpnProvider)object).selected;
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block9;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return object;
        }
        throw new AssertionError("failed to get ALPN selected protocol", (Throwable)var1_4);
    }

    private static class AlpnProvider
    implements InvocationHandler {
        private final List<String> protocols;
        String selected;
        boolean unsupported;

        AlpnProvider(List<String> list) {
            this.protocols = list;
        }

        @Override
        public Object invoke(Object object, Method object2, Object[] objectArray) throws Throwable {
            String string2 = ((Method)object2).getName();
            Class<?> clazz = ((Method)object2).getReturnType();
            object = objectArray;
            if (objectArray == null) {
                object = Util.EMPTY_STRING_ARRAY;
            }
            if (string2.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string2.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string2.equals("protocols") && ((Object[])object).length == 0) {
                return this.protocols;
            }
            if ((string2.equals("selectProtocol") || string2.equals("select")) && String.class == clazz && ((Object[])object).length == 1 && object[0] instanceof List) {
                object2 = (List)object[0];
                int n = object2.size();
                for (int i = 0; i < n; ++i) {
                    object = (String)object2.get(i);
                    if (!this.protocols.contains(object)) continue;
                    this.selected = object;
                    return object;
                }
                this.selected = object = this.protocols.get(0);
                return object;
            }
            if ((string2.equals("protocolSelected") || string2.equals("selected")) && ((Object[])object).length == 1) {
                this.selected = (String)object[0];
                return null;
            }
            return ((Method)object2).invoke((Object)this, object);
        }
    }
}

