/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import okio.Buffer;

public class Platform {
    public static final int INFO = 4;
    private static final Platform PLATFORM = Platform.findPlatform();
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static List<String> alpnProtocolNames(List<Protocol> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = list.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            arrayList.add(protocol.toString());
        }
        return arrayList;
    }

    static byte[] concatLengthPrefixed(List<Protocol> list) {
        Buffer buffer = new Buffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = list.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer.writeByte(protocol.toString().length());
            buffer.writeUtf8(protocol.toString());
        }
        return buffer.readByteArray();
    }

    private static Platform findPlatform() {
        Platform platform = Android10Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = AndroidPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        if (Platform.isConscryptPreferred() && (platform = ConscryptPlatform.buildIfSupported()) != null) {
            return platform;
        }
        platform = Jdk9Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = Jdk8WithJettyBootPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        return new Platform();
    }

    public static Platform get() {
        return PLATFORM;
    }

    public static boolean isConscryptPreferred() {
        if ("conscrypt".equals(Util.getSystemProperty("okhttp.platform", null))) {
            return true;
        }
        return "Conscrypt".equals(Security.getProviders()[0].getName());
    }

    @Nullable
    static <T> T readFieldOrNull(Object object, Class<T> clazz, String string2) {
        for (Class<?> clazz2 = object.getClass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Object object2;
            block6: {
                object2 = clazz2.getDeclaredField(string2);
                ((Field)object2).setAccessible(true);
                object2 = ((Field)object2).get(object);
                if (clazz.isInstance(object2)) break block6;
                return null;
            }
            try {
                object2 = clazz.cast(object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            return (T)object2;
        }
        if (!string2.equals("delegate") && (object = Platform.readFieldOrNull(object, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(object, clazz, string2);
        }
        return null;
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public CertificateChainCleaner buildCertificateChainCleaner(SSLSocketFactory sSLSocketFactory) {
        Object object = this.trustManager(sSLSocketFactory);
        if (object != null) {
            return this.buildCertificateChainCleaner((X509TrustManager)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unable to extract the trust manager on ");
        ((StringBuilder)object).append(Platform.get());
        ((StringBuilder)object).append(", sslSocketFactory is ");
        ((StringBuilder)object).append(sSLSocketFactory.getClass());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        return new BasicTrustRootIndex(x509TrustManager.getAcceptedIssuers());
    }

    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, @Nullable String string2, List<Protocol> list) {
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        socket.connect(inetSocketAddress, n);
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public SSLContext getSSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            return sSLContext;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    @Nullable
    public Object getStackTraceForCloseable(String string2) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string2);
        }
        return null;
    }

    public boolean isCleartextTrafficPermitted(String string2) {
        return true;
    }

    public void log(int n, String string2, @Nullable Throwable throwable) {
        Level level = n == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string2, throwable);
    }

    public void logCloseableLeak(String string2, Object object) {
        CharSequence charSequence = string2;
        if (object == null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(" To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        this.log(5, (String)charSequence, (Throwable)object);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory object) {
        block3: {
            try {
                object = Platform.readFieldOrNull(object, Class.forName("sun.security.ssl.SSLContextImpl"), "context");
                if (object != null) break block3;
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        object = Platform.readFieldOrNull(object, X509TrustManager.class, "trustManager");
        return object;
    }
}

