/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import okio.GzipSource;
import okio.Okio;

public final class PublicSuffixDatabase {
    private static final String[] EMPTY_RULE;
    private static final byte EXCEPTION_MARKER = 33;
    private static final String[] PREVAILING_RULE;
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL;
    private static final PublicSuffixDatabase instance;
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private byte[] publicSuffixExceptionListBytes;
    private byte[] publicSuffixListBytes;
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);

    static {
        WILDCARD_LABEL = new byte[]{42};
        EMPTY_RULE = new String[0];
        PREVAILING_RULE = new String[]{"*"};
        instance = new PublicSuffixDatabase();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static String binarySearchBytes(byte[] object, byte[][] byArray, int n) {
        int n2 = ((byte[])object).length;
        int n3 = 0;
        void var0_3;
        block0: while (n3 < n2) {
            void var2_5;
            int n4;
            int n5;
            for (n5 = (n3 + n2) / 2; n5 > -1 && object[n5] != 10; --n5) {
            }
            int n6 = n5 + 1;
            n5 = 1;
            while (object[n4 = n6 + n5] != 10) {
                ++n5;
            }
            int n7 = n4 - n6;
            void var9_12 = var2_5;
            int n8 = 0;
            n5 = 0;
            int n9 = 0;
            while (true) {
                block12: {
                    block14: {
                        block15: {
                            block13: {
                                void var1_4;
                                int n10;
                                block11: {
                                    if (n8 != 0) {
                                        n10 = 46;
                                        n8 = 0;
                                    } else {
                                        n10 = var1_4[var9_12][n5];
                                        n10 &= 0xFF;
                                    }
                                    if ((n10 -= object[n6 + n9] & 0xFF) != 0) break block11;
                                    ++n5;
                                    if (++n9 == n7) break block11;
                                    if (((void)var1_4[var9_12]).length != n5) continue;
                                    if (var9_12 != ((void)var1_4).length - 1) break block12;
                                }
                                if (n10 < 0) break block13;
                                if (n10 > 0) break block14;
                                n8 = n7 - n9;
                                n5 = ((void)var1_4[var9_12]).length - n5;
                                while (++var9_12 < ((void)var1_4).length) {
                                    n5 += ((void)var1_4[var9_12]).length;
                                }
                                if (n5 >= n8) break block15;
                            }
                            n2 = n6 - 1;
                            continue block0;
                        }
                        if (n5 <= n8) {
                            String string2 = new String((byte[])object, n6, n7, StandardCharsets.UTF_8);
                            return var0_3;
                        }
                    }
                    n3 = n4 + 1;
                    continue block0;
                }
                ++var9_12;
                n8 = 1;
                n5 = -1;
            }
            break;
        }
        return var0_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] findMatchingRule(String[] object) {
        Object object2;
        Object object3;
        Object var8_9;
        int n;
        byte[][] byArrayArray;
        int n2;
        int n3;
        block19: {
            boolean bl = this.listRead.get();
            n3 = 0;
            if (!bl && this.listRead.compareAndSet(false, true)) {
                this.readTheListUninterruptibly();
            } else {
                try {
                    this.readCompleteLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            synchronized (this) {
                if (this.publicSuffixListBytes == null) {
                    object = new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.");
                    throw object;
                }
            }
            n2 = ((String[])object).length;
            byArrayArray = new byte[n2][];
            for (n = 0; n < ((String[])object).length; ++n) {
                byArrayArray[n] = object[n].getBytes(StandardCharsets.UTF_8);
            }
            n = 0;
            while (true) {
                var8_9 = null;
                if (n >= n2) break;
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, byArrayArray, n);
                if (object == null) {
                    ++n;
                    continue;
                }
                break block19;
                break;
            }
            object = null;
        }
        if (n2 > 1) {
            object3 = (byte[][])byArrayArray.clone();
            for (n = 0; n < ((byte[][])object3).length - 1; ++n) {
                object3[n] = WILDCARD_LABEL;
                object2 = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, object3, n);
                if (object2 == null) {
                    continue;
                }
                break;
            }
        } else {
            object2 = null;
        }
        object3 = var8_9;
        if (object2 != null) {
            n = n3;
            while (true) {
                object3 = var8_9;
                if (n >= n2 - 1 || (object3 = (Object)PublicSuffixDatabase.binarySearchBytes(this.publicSuffixExceptionListBytes, byArrayArray, n)) != null) break;
                ++n;
            }
        }
        if (object3 != null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("!");
            ((StringBuilder)object).append((String)object3);
            return ((StringBuilder)object).toString().split("\\.");
        }
        if (object == null && object2 == null) {
            return PREVAILING_RULE;
        }
        object = object != null ? ((String)object).split("\\.") : EMPTY_RULE;
        object2 = object2 != null ? object2.split("\\.") : EMPTY_RULE;
        if (((Object)object).length <= ((String[])object2).length) return object2;
        return object;
    }

    public static PublicSuffixDatabase get() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readTheList() throws IOException {
        byte[] byArray;
        byte[] byArray2;
        block10: {
            Closeable closeable = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
            if (closeable == null) {
                return;
            }
            closeable = Okio.buffer(new GzipSource(Okio.source((InputStream)closeable)));
            try {
                byArray2 = new byte[closeable.readInt()];
                closeable.readFully(byArray2);
                byArray = new byte[closeable.readInt()];
                closeable.readFully(byArray);
                if (closeable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (closeable == null) throw throwable2;
                    try {
                        closeable.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            closeable.close();
        }
        synchronized (this) {
            this.publicSuffixListBytes = byArray2;
            this.publicSuffixExceptionListBytes = byArray;
        }
        this.readCompleteLatch.countDown();
    }

    /*
     * Exception decompiling
     */
    private void readTheListUninterruptibly() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 22->32)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getEffectiveTldPlusOne(String stringArray) {
        int n;
        int n2;
        Objects.requireNonNull(stringArray, "domain == null");
        Object object = IDN.toUnicode((String)stringArray).split("\\.");
        String[] stringArray2 = this.findMatchingRule((String[])object);
        if (((String[])object).length == stringArray2.length && stringArray2[0].charAt(0) != '!') {
            return null;
        }
        if (stringArray2[0].charAt(0) == '!') {
            n2 = ((String[])object).length;
            n = stringArray2.length;
        } else {
            n2 = ((String[])object).length;
            n = stringArray2.length + 1;
        }
        n2 -= n;
        object = new StringBuilder();
        stringArray = stringArray.split("\\.");
        while (n2 < stringArray.length) {
            ((StringBuilder)object).append(stringArray[n2]);
            ((StringBuilder)object).append('.');
            ++n2;
        }
        ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
        return ((StringBuilder)object).toString();
    }

    void setListBytes(byte[] byArray, byte[] byArray2) {
        this.publicSuffixListBytes = byArray;
        this.publicSuffixExceptionListBytes = byArray2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }
}

