/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    private static final int MAX_SIGNERS = 9;
    private final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        this.trustRootIndex = trustRootIndex;
    }

    private boolean verifySignature(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (!x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN())) {
            return false;
        }
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    @Override
    public List<Certificate> clean(List<Certificate> object, String object2) throws SSLPeerUnverifiedException {
        ArrayDeque<Certificate> arrayDeque = new ArrayDeque<Certificate>((Collection<Certificate>)object);
        object2 = new ArrayList();
        object2.add((Certificate)arrayDeque.removeFirst());
        boolean bl = false;
        block0: for (int i = 0; i < 9; ++i) {
            object = (X509Certificate)object2.get(object2.size() - 1);
            Object object3 = this.trustRootIndex.findByIssuerAndSignature((X509Certificate)object);
            if (object3 != null) {
                if (object2.size() > 1 || !((Certificate)object).equals(object3)) {
                    object2.add(object3);
                }
                if (this.verifySignature((X509Certificate)object3, (X509Certificate)object3)) {
                    return object2;
                }
                bl = true;
                continue;
            }
            object3 = arrayDeque.iterator();
            while (object3.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)object3.next();
                if (!this.verifySignature((X509Certificate)object, x509Certificate)) continue;
                object3.remove();
                object2.add(x509Certificate);
                continue block0;
            }
            if (bl) {
                return object2;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Failed to find a trusted cert that signed ");
            ((StringBuilder)object2).append(object);
            throw new SSLPeerUnverifiedException(((StringBuilder)object2).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Certificate chain too long: ");
        ((StringBuilder)object).append(object2);
        throw new SSLPeerUnverifiedException(((StringBuilder)object).toString());
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicCertificateChainCleaner) || !((BasicCertificateChainCleaner)object).trustRootIndex.equals(this.trustRootIndex)) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.trustRootIndex.hashCode();
    }
}

