/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import okhttp3.internal.tls.TrustRootIndex;

public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts = new LinkedHashMap<X500Principal, Set<X509Certificate>>();

    public BasicTrustRootIndex(X509Certificate ... x509CertificateArray) {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            Set<X509Certificate> set;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            Set<X509Certificate> set2 = set = this.subjectToCaCerts.get(x500Principal);
            if (set == null) {
                set2 = new LinkedHashSet<X509Certificate>(1);
                this.subjectToCaCerts.put(x500Principal, set2);
            }
            set2.add(x509Certificate);
        }
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicTrustRootIndex) || !((BasicTrustRootIndex)object).subjectToCaCerts.equals(this.subjectToCaCerts)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        Iterator iterator2 = x509Certificate.getIssuerX500Principal();
        if ((iterator2 = this.subjectToCaCerts.get(iterator2)) == null) {
            return null;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator2.next();
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
                return x509Certificate2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public int hashCode() {
        return this.subjectToCaCerts.hashCode();
    }
}

