/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.ws.RealWebSocket$$ExternalSyntheticLambda0;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final List<Protocol> ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    private boolean awaitingPong;
    private Call call;
    private ScheduledFuture<?> cancelFuture;
    private boolean enqueuedClose;
    private ScheduledExecutorService executor;
    private boolean failed;
    private final String key;
    final WebSocketListener listener;
    private final ArrayDeque<Object> messageAndCloseQueue;
    private final Request originalRequest;
    private final long pingIntervalMillis;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private long queueSize;
    private final Random random;
    private WebSocketReader reader;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private int receivedPingCount;
    private int receivedPongCount;
    private int sentPingCount;
    private Streams streams;
    private WebSocketWriter writer;
    private final Runnable writerRunnable;

    public RealWebSocket(Request object, WebSocketListener object2, Random random, long l) {
        this.messageAndCloseQueue = new ArrayDeque();
        if ("GET".equals(((Request)object).method())) {
            this.originalRequest = object;
            this.listener = object2;
            this.random = random;
            this.pingIntervalMillis = l;
            object = new byte[16];
            random.nextBytes((byte[])object);
            this.key = ByteString.of((byte[])object).base64();
            this.writerRunnable = new RealWebSocket$$ExternalSyntheticLambda0(this);
            return;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Request must be GET: ");
        ((StringBuilder)object2).append(((Request)object).method());
        throw new IllegalArgumentException(((StringBuilder)object2).toString());
    }

    private void runWriter() {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.execute(this.writerRunnable);
        }
    }

    private boolean send(ByteString byteString, int n) {
        synchronized (this) {
            if (!this.failed) {
                if (this.enqueuedClose) {
                } else {
                    if (this.queueSize + (long)byteString.size() > 0x1000000L) {
                        this.close(1001, null);
                        return false;
                    }
                    this.queueSize += (long)byteString.size();
                    ArrayDeque<Object> arrayDeque = this.messageAndCloseQueue;
                    Message message = new Message(n, byteString);
                    arrayDeque.add(message);
                    this.runWriter();
                    return true;
                }
            }
            return false;
        }
    }

    void awaitTermination(int n, TimeUnit timeUnit) throws InterruptedException {
        this.executor.awaitTermination(n, timeUnit);
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    void checkUpgradeSuccess(Response object, @Nullable Exchange object2) throws IOException {
        if (((Response)object).code() == 101) {
            CharSequence charSequence = ((Response)object).header("Connection");
            if ("Upgrade".equalsIgnoreCase((String)charSequence)) {
                charSequence = ((Response)object).header("Upgrade");
                if ("websocket".equalsIgnoreCase((String)charSequence)) {
                    object = ((Response)object).header("Sec-WebSocket-Accept");
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(this.key);
                    ((StringBuilder)charSequence).append("258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
                    charSequence = ByteString.encodeUtf8(((StringBuilder)charSequence).toString()).sha1().base64();
                    if (((String)charSequence).equals(object)) {
                        if (object2 != null) {
                            return;
                        }
                        throw new ProtocolException("Web Socket exchange missing: bad interceptor?");
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Expected 'Sec-WebSocket-Accept' header value '");
                    ((StringBuilder)object2).append((String)charSequence);
                    ((StringBuilder)object2).append("' but was '");
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append("'");
                    throw new ProtocolException(((StringBuilder)object2).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Expected 'Upgrade' header value 'websocket' but was '");
                ((StringBuilder)object).append((String)charSequence);
                ((StringBuilder)object).append("'");
                throw new ProtocolException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Expected 'Connection' header value 'Upgrade' but was '");
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append("'");
            throw new ProtocolException(((StringBuilder)object).toString());
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Expected HTTP 101 response but was '");
        ((StringBuilder)object2).append(((Response)object).code());
        ((StringBuilder)object2).append(" ");
        ((StringBuilder)object2).append(((Response)object).message());
        ((StringBuilder)object2).append("'");
        throw new ProtocolException(((StringBuilder)object2).toString());
    }

    @Override
    public boolean close(int n, String string2) {
        return this.close(n, string2, 60000L);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean close(int n, String object, long l) {
        synchronized (this) {
            ByteString byteString;
            WebSocketProtocol.validateCloseCode(n);
            Object var5_4 = null;
            if (object != null && (long)(byteString = ByteString.encodeUtf8((String)object)).size() > 123L) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("reason.size() > 123: ");
                stringBuilder.append((String)object);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
                throw illegalArgumentException;
            }
            if (!this.failed && !this.enqueuedClose) {
                void var3_3;
                void var5_7;
                this.enqueuedClose = true;
                ArrayDeque<Object> arrayDeque = this.messageAndCloseQueue;
                object = new Close(n, (ByteString)var5_7, (long)var3_3);
                arrayDeque.add(object);
                this.runWriter();
                return true;
            }
            return false;
        }
    }

    public void connect(OkHttpClient object) {
        Cloneable cloneable = ((OkHttpClient)object).newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        object = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        cloneable = Internal.instance.newWebSocketCall((OkHttpClient)cloneable, (Request)object);
        this.call = cloneable;
        cloneable.enqueue(new Callback((Request)object){
            final /* synthetic */ Request val$request;
            {
                this.val$request = request;
            }

            @Override
            public void onFailure(Call call, IOException iOException) {
                RealWebSocket.this.failWebSocket(iOException, null);
            }

            @Override
            public void onResponse(Call object, Response response) {
                Object object2 = Internal.instance.exchange(response);
                try {
                    RealWebSocket.this.checkUpgradeSuccess(response, (Exchange)object2);
                    object = ((Exchange)object2).newWebSocketStreams();
                }
                catch (IOException iOException) {
                    if (object2 != null) {
                        ((Exchange)object2).webSocketUpgradeFailed();
                    }
                    RealWebSocket.this.failWebSocket(iOException, response);
                    Util.closeQuietly(response);
                    return;
                }
                try {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("OkHttp WebSocket ");
                    ((StringBuilder)object2).append(this.val$request.url().redact());
                    object2 = ((StringBuilder)object2).toString();
                    RealWebSocket.this.initReaderAndWriter((String)object2, (Streams)object);
                    RealWebSocket.this.listener.onOpen(RealWebSocket.this, response);
                    RealWebSocket.this.loopReader();
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failWebSocket(Exception exception, @Nullable Response response) {
        Streams streams;
        synchronized (this) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streams = this.streams;
            this.streams = null;
            ScheduledFuture<?> scheduledFuture = this.cancelFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            if ((scheduledFuture = this.executor) != null) {
                scheduledFuture.shutdown();
            }
        }
        try {
            this.listener.onFailure(this, exception, response);
            return;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initReaderAndWriter(String object, Streams streams) throws IOException {
        synchronized (this) {
            this.streams = streams;
            Object object2 = new WebSocketWriter(streams.client, streams.sink, this.random);
            this.writer = object2;
            this.executor = object2 = new ScheduledThreadPoolExecutor(1, Util.threadFactory((String)object, false));
            if (this.pingIntervalMillis != 0L) {
                object = new PingRunnable();
                long l = this.pingIntervalMillis;
                object2.scheduleAtFixedRate((Runnable)object, l, l, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.client, streams.source, this);
    }

    public /* synthetic */ void lambda$new$0$okhttp3-internal-ws-RealWebSocket() {
        while (true) {
            try {
                boolean bl = this.writeOneFrame();
                if (!bl) break;
            }
            catch (IOException iOException) {
                this.failWebSocket(iOException, null);
                break;
            }
        }
    }

    public void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReadClose(int n, String object) {
        Streams streams;
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        synchronized (this) {
            if (this.receivedCloseCode != -1) {
                object = new IllegalStateException("already closed");
                throw object;
            }
            this.receivedCloseCode = n;
            this.receivedCloseReason = object;
            boolean bl = this.enqueuedClose;
            ScheduledFuture<?> scheduledFuture = null;
            streams = scheduledFuture;
            if (bl) {
                streams = scheduledFuture;
                if (this.messageAndCloseQueue.isEmpty()) {
                    streams = this.streams;
                    this.streams = null;
                    scheduledFuture = this.cancelFuture;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(false);
                    }
                    this.executor.shutdown();
                }
            }
        }
        try {
            this.listener.onClosing(this, n, (String)object);
            if (streams != null) {
                this.listener.onClosed(this, n, (String)object);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(streams);
            throw throwable;
        }
        Util.closeQuietly(streams);
    }

    @Override
    public void onReadMessage(String string2) throws IOException {
        this.listener.onMessage((WebSocket)this, string2);
    }

    @Override
    public void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public void onReadPing(ByteString byteString) {
        synchronized (this) {
            if (!(this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty())) {
                this.pongQueue.add(byteString);
                this.runWriter();
                ++this.receivedPingCount;
                return;
            }
            return;
        }
    }

    @Override
    public void onReadPong(ByteString byteString) {
        synchronized (this) {
            ++this.receivedPongCount;
            this.awaitingPong = false;
            return;
        }
    }

    boolean pong(ByteString byteString) {
        synchronized (this) {
            if (!this.failed) {
                if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                } else {
                    this.pongQueue.add(byteString);
                    this.runWriter();
                    return true;
                }
            }
            return false;
        }
    }

    boolean processNextFrame() throws IOException {
        boolean bl = false;
        try {
            this.reader.processNextFrame();
            int n = this.receivedCloseCode;
            if (n == -1) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    @Override
    public long queueSize() {
        synchronized (this) {
            long l = this.queueSize;
            return l;
        }
    }

    int receivedPingCount() {
        synchronized (this) {
            int n = this.receivedPingCount;
            return n;
        }
    }

    int receivedPongCount() {
        synchronized (this) {
            int n = this.receivedPongCount;
            return n;
        }
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public boolean send(String string2) {
        Objects.requireNonNull(string2, "text == null");
        return this.send(ByteString.encodeUtf8(string2), 1);
    }

    @Override
    public boolean send(ByteString byteString) {
        Objects.requireNonNull(byteString, "bytes == null");
        return this.send(byteString, 2);
    }

    int sentPingCount() {
        synchronized (this) {
            int n = this.sentPingCount;
            return n;
        }
    }

    void tearDown() throws InterruptedException {
        ScheduledFuture<?> scheduledFuture = this.cancelFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeOneFrame() throws IOException {
        block12: {
            block13: {
                synchronized (this) {
                    block17: {
                        block14: {
                            block18: {
                                block15: {
                                    block16: {
                                        if (this.failed) {
                                            return false;
                                        }
                                        var1_1 = this.writer;
                                        var2_2 = this.pongQueue.poll();
                                        var3_3 = -1;
                                        var4_4 = null;
                                        if (var2_2 != null) break block14;
                                        var5_6 = this.messageAndCloseQueue.poll();
                                        if (!(var5_6 instanceof Close)) break block15;
                                        var3_3 = this.receivedCloseCode;
                                        var6_7 = this.receivedCloseReason;
                                        if (var3_3 == -1) break block16;
                                        var7_8 = this.streams;
                                        this.streams = null;
                                        this.executor.shutdown();
                                        var4_4 = var5_6;
                                        var5_6 = var7_8;
                                        break block17;
                                    }
                                    var4_4 = this.executor;
                                    var7_9 = new CancelRunnable();
                                    this.cancelFuture = var4_4.schedule(var7_9, ((Close)var5_6).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
                                    break block18;
                                }
                                if (var5_6 == null) {
                                    return false;
                                }
                                var6_7 = null;
                            }
                            var7_9 = null;
                            var4_4 = var5_6;
                            var5_6 = var7_9;
                            break block17;
                        }
                        var6_7 = var5_6 = null;
                    }
                    if (var2_2 == null) ** GOTO lbl41
                }
                try {
                    var1_1.writePong(var2_2);
                    break block12;
lbl41:
                    // 1 sources

                    if (!(var4_4 instanceof Message)) break block13;
                    var6_7 = ((Message)var4_4).data;
                    var4_4 = Okio.buffer(var1_1.newMessageSink(((Message)var4_4).formatOpcode, var6_7.size()));
                    var4_4.write((ByteString)var6_7);
                    var4_4.close();
                    synchronized (this) {
                    }
                }
                catch (Throwable var4_5) {
                    Util.closeQuietly((Closeable)var5_6);
                    throw var4_5;
                }
                {
                    this.queueSize -= (long)var6_7.size();
                    break block12;
                }
            }
            if (!(var4_4 instanceof Close)) ** GOTO lbl-1000
            var4_4 = (Close)var4_4;
            var1_1.writeClose(var4_4.code, var4_4.reason);
            if (var5_6 != null) {
                this.listener.onClosed(this, var3_3, (String)var6_7);
            }
        }
        Util.closeQuietly((Closeable)var5_6);
        return true;
lbl-1000:
        // 1 sources

        {
            var4_4 = new AssertionError();
            throw var4_4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void writePingFrame() {
        // MONITORENTER : this
        if (this.failed) {
            // MONITOREXIT : this
            return;
        }
        Object object = this.writer;
        int n = this.awaitingPong ? this.sentPingCount : -1;
        ++this.sentPingCount;
        this.awaitingPong = true;
        // MONITOREXIT : this
        if (n != -1) {
            object = new StringBuilder();
            ((StringBuilder)object).append("sent ping but didn't receive pong within ");
            ((StringBuilder)object).append(this.pingIntervalMillis);
            ((StringBuilder)object).append("ms (after ");
            ((StringBuilder)object).append(n - 1);
            ((StringBuilder)object).append(" successful ping/pongs)");
            this.failWebSocket(new SocketTimeoutException(((StringBuilder)object).toString()), null);
            return;
        }
        try {
            ((WebSocketWriter)object).writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException iOException) {
            this.failWebSocket(iOException, null);
        }
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.cancel();
        }
    }

    static final class Close {
        final long cancelAfterCloseMillis;
        final int code;
        final ByteString reason;

        Close(int n, ByteString byteString, long l) {
            this.code = n;
            this.reason = byteString;
            this.cancelAfterCloseMillis = l;
        }
    }

    static final class Message {
        final ByteString data;
        final int formatOpcode;

        Message(int n, ByteString byteString) {
            this.formatOpcode = n;
            this.data = byteString;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.writePingFrame();
        }
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSink sink;
        public final BufferedSource source;

        public Streams(boolean bl, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.client = bl;
            this.source = bufferedSource;
            this.sink = bufferedSink;
        }
    }
}

