/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

final class WebSocketReader {
    boolean closed;
    private final Buffer controlFrameBuffer = new Buffer();
    final FrameCallback frameCallback;
    long frameLength;
    final boolean isClient;
    boolean isControlFrame;
    boolean isFinalFrame;
    private final Buffer.UnsafeCursor maskCursor;
    private final byte[] maskKey;
    private final Buffer messageFrameBuffer = new Buffer();
    int opcode;
    final BufferedSource source;

    WebSocketReader(boolean bl, BufferedSource object, FrameCallback frameCallback) {
        Objects.requireNonNull(object, "source == null");
        Objects.requireNonNull(frameCallback, "frameCallback == null");
        this.isClient = bl;
        this.source = object;
        this.frameCallback = frameCallback;
        frameCallback = null;
        object = bl ? null : (Object)new byte[4];
        this.maskKey = (byte[])object;
        object = bl ? frameCallback : new Buffer.UnsafeCursor();
        this.maskCursor = object;
    }

    private void readControlFrame() throws IOException {
        block10: {
            long l = this.frameLength;
            if (l > 0L) {
                this.source.readFully(this.controlFrameBuffer, l);
                if (!this.isClient) {
                    this.controlFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    this.maskCursor.seek(0L);
                    WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                    this.maskCursor.close();
                }
            }
            switch (this.opcode) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unknown control opcode: ");
                    stringBuilder.append(Integer.toHexString(this.opcode));
                    throw new ProtocolException(stringBuilder.toString());
                }
                case 10: {
                    this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                    break;
                }
                case 9: {
                    this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                    break;
                }
                case 8: {
                    String string2;
                    int n = 1005;
                    l = this.controlFrameBuffer.size();
                    if (l == 1L) break block10;
                    if (l != 0L) {
                        n = this.controlFrameBuffer.readShort();
                        string2 = this.controlFrameBuffer.readUtf8();
                        String string3 = WebSocketProtocol.closeCodeExceptionMessage(n);
                        if (string3 != null) {
                            throw new ProtocolException(string3);
                        }
                    } else {
                        string2 = "";
                    }
                    this.frameCallback.onReadClose(n, string2);
                    this.closed = true;
                }
            }
            return;
        }
        throw new ProtocolException("Malformed close payload length of 1.");
    }

    private void readHeader() throws IOException {
        if (!this.closed) {
            int n;
            int n2;
            long l = this.source.timeout().timeoutNanos();
            this.source.timeout().clearTimeout();
            try {
                n2 = this.source.readByte();
                n = n2 & 0xFF;
                this.source.timeout().timeout(l, TimeUnit.NANOSECONDS);
            }
            catch (Throwable throwable) {
                this.source.timeout().timeout(l, TimeUnit.NANOSECONDS);
                throw throwable;
            }
            this.opcode = n & 0xF;
            boolean bl = true;
            boolean bl2 = (n & 0x80) != 0;
            this.isFinalFrame = bl2;
            boolean bl3 = (n & 8) != 0;
            this.isControlFrame = bl3;
            if (bl3 && !bl2) {
                throw new ProtocolException("Control frames must be final.");
            }
            n2 = (n & 0x40) != 0 ? 1 : 0;
            boolean bl4 = (n & 0x20) != 0;
            n = (n & 0x10) != 0 ? 1 : 0;
            if (n2 == 0 && !bl4 && n == 0) {
                n2 = this.source.readByte() & 0xFF;
                bl2 = (n2 & 0x80) != 0 ? bl : false;
                if (bl2 == this.isClient) {
                    String string2 = this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.";
                    throw new ProtocolException(string2);
                }
                this.frameLength = l = (long)(n2 & 0x7F);
                if (l == 126L) {
                    this.frameLength = (long)this.source.readShort() & 0xFFFFL;
                } else if (l == 127L) {
                    this.frameLength = l = this.source.readLong();
                    if (l < 0L) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Frame length 0x");
                        stringBuilder.append(Long.toHexString(this.frameLength));
                        stringBuilder.append(" > 0x7FFFFFFFFFFFFFFF");
                        throw new ProtocolException(stringBuilder.toString());
                    }
                }
                if (this.isControlFrame && this.frameLength > 125L) {
                    throw new ProtocolException("Control frame must be less than 125B.");
                }
                if (bl2) {
                    this.source.readFully(this.maskKey);
                }
                return;
            }
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        throw new IOException("closed");
    }

    private void readMessage() throws IOException {
        while (!this.closed) {
            long l = this.frameLength;
            if (l > 0L) {
                this.source.readFully(this.messageFrameBuffer, l);
                if (!this.isClient) {
                    this.messageFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                    WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                    this.maskCursor.close();
                }
            }
            if (this.isFinalFrame) {
                return;
            }
            this.readUntilNonControlFrame();
            if (this.opcode == 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected continuation opcode. Got: ");
            stringBuilder.append(Integer.toHexString(this.opcode));
            throw new ProtocolException(stringBuilder.toString());
        }
        throw new IOException("closed");
    }

    private void readMessageFrame() throws IOException {
        int n = this.opcode;
        if (n != 1 && n != 2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unknown opcode: ");
            stringBuilder.append(Integer.toHexString(n));
            throw new ProtocolException(stringBuilder.toString());
        }
        this.readMessage();
        if (n == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
        }
    }

    private void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    public static interface FrameCallback {
        public void onReadClose(int var1, String var2);

        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);
    }
}

