/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;
import okio.Timeout;

final class WebSocketWriter {
    boolean activeWriter;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink();
    final boolean isClient;
    private final Buffer.UnsafeCursor maskCursor;
    private final byte[] maskKey;
    final Random random;
    final BufferedSink sink;
    final Buffer sinkBuffer;
    boolean writerClosed;

    WebSocketWriter(boolean bl, BufferedSink object, Random random) {
        Objects.requireNonNull(object, "sink == null");
        Objects.requireNonNull(random, "random == null");
        this.isClient = bl;
        this.sink = object;
        this.sinkBuffer = object.buffer();
        this.random = random;
        random = null;
        object = bl ? (Object)new byte[4] : null;
        this.maskKey = (byte[])object;
        object = random;
        if (bl) {
            object = new Buffer.UnsafeCursor();
        }
        this.maskCursor = object;
    }

    private void writeControlFrame(int n, ByteString byteString) throws IOException {
        if (!this.writerClosed) {
            int n2 = byteString.size();
            if ((long)n2 <= 125L) {
                this.sinkBuffer.writeByte(n | 0x80);
                if (this.isClient) {
                    this.sinkBuffer.writeByte(n2 | 0x80);
                    this.random.nextBytes(this.maskKey);
                    this.sinkBuffer.write(this.maskKey);
                    if (n2 > 0) {
                        long l = this.sinkBuffer.size();
                        this.sinkBuffer.write(byteString);
                        this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                        this.maskCursor.seek(l);
                        WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                        this.maskCursor.close();
                    }
                } else {
                    this.sinkBuffer.writeByte(n2);
                    this.sinkBuffer.write(byteString);
                }
                this.sink.flush();
                return;
            }
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        throw new IOException("closed");
    }

    Sink newMessageSink(int n, long l) {
        if (!this.activeWriter) {
            this.activeWriter = true;
            this.frameSink.formatOpcode = n;
            this.frameSink.contentLength = l;
            this.frameSink.isFirstFrame = true;
            this.frameSink.closed = false;
            return this.frameSink;
        }
        throw new IllegalStateException("Another message writer is active. Did you call close()?");
    }

    void writeClose(int n, ByteString byteString) throws IOException {
        Object object = ByteString.EMPTY;
        if (n != 0 || byteString != null) {
            if (n != 0) {
                WebSocketProtocol.validateCloseCode(n);
            }
            object = new Buffer();
            ((Buffer)object).writeShort(n);
            if (byteString != null) {
                ((Buffer)object).write(byteString);
            }
            object = ((Buffer)object).readByteString();
        }
        try {
            this.writeControlFrame(8, (ByteString)object);
            return;
        }
        finally {
            this.writerClosed = true;
        }
    }

    void writeMessageFrame(int n, long l, boolean bl, boolean bl2) throws IOException {
        if (!this.writerClosed) {
            int n2 = 0;
            if (!bl) {
                n = 0;
            }
            int n3 = n;
            if (bl2) {
                n3 = n | 0x80;
            }
            this.sinkBuffer.writeByte(n3);
            n = n2;
            if (this.isClient) {
                n = 128;
            }
            if (l <= 125L) {
                n3 = (int)l;
                this.sinkBuffer.writeByte(n3 | n);
            } else if (l <= 65535L) {
                this.sinkBuffer.writeByte(n | 0x7E);
                this.sinkBuffer.writeShort((int)l);
            } else {
                this.sinkBuffer.writeByte(n | 0x7F);
                this.sinkBuffer.writeLong(l);
            }
            if (this.isClient) {
                this.random.nextBytes(this.maskKey);
                this.sinkBuffer.write(this.maskKey);
                if (l > 0L) {
                    long l2 = this.sinkBuffer.size();
                    this.sinkBuffer.write(this.buffer, l);
                    this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                    this.maskCursor.seek(l2);
                    WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                    this.maskCursor.close();
                }
            } else {
                this.sinkBuffer.write(this.buffer, l);
            }
            this.sink.emit();
            return;
        }
        throw new IOException("closed");
    }

    void writePing(ByteString byteString) throws IOException {
        this.writeControlFrame(9, byteString);
    }

    void writePong(ByteString byteString) throws IOException {
        this.writeControlFrame(10, byteString);
    }

    final class FrameSink
    implements Sink {
        boolean closed;
        long contentLength;
        int formatOpcode;
        boolean isFirstFrame;

        FrameSink() {
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                webSocketWriter.writeMessageFrame(this.formatOpcode, webSocketWriter.buffer.size(), this.isFirstFrame, true);
                this.closed = true;
                WebSocketWriter.this.activeWriter = false;
                return;
            }
            throw new IOException("closed");
        }

        @Override
        public void flush() throws IOException {
            if (!this.closed) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                webSocketWriter.writeMessageFrame(this.formatOpcode, webSocketWriter.buffer.size(), this.isFirstFrame, false);
                this.isFirstFrame = false;
                return;
            }
            throw new IOException("closed");
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (!this.closed) {
                WebSocketWriter.this.buffer.write(buffer, l);
                boolean bl = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
                l = WebSocketWriter.this.buffer.completeSegmentByteCount();
                if (l > 0L && !bl) {
                    WebSocketWriter.this.writeMessageFrame(this.formatOpcode, l, this.isFirstFrame, false);
                    this.isFirstFrame = false;
                }
                return;
            }
            throw new IOException("closed");
        }
    }
}

