/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.logging;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSource;
import okio.Source;

public final class HttpLoggingInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private volatile Set<String> headersToRedact = Collections.emptySet();
    private volatile Level level = Level.NONE;
    private final Logger logger;

    public HttpLoggingInterceptor() {
        this(Logger.DEFAULT);
    }

    public HttpLoggingInterceptor(Logger logger) {
        this.logger = logger;
    }

    private static boolean bodyHasUnknownEncoding(Headers object) {
        boolean bl = (object = ((Headers)object).get("Content-Encoding")) != null && !((String)object).equalsIgnoreCase("identity") && !((String)object).equalsIgnoreCase("gzip");
        return bl;
    }

    static boolean isPlaintext(Buffer buffer) {
        Buffer buffer2 = new Buffer();
        long l = buffer.size() < 64L ? buffer.size() : 64L;
        try {
            buffer.copyTo(buffer2, 0L, l);
        }
        catch (EOFException eOFException) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            boolean bl;
            if (buffer2.exhausted()) break;
            int n = buffer2.readUtf8CodePoint();
            if (!Character.isISOControl(n) || (bl = Character.isWhitespace(n))) continue;
            return false;
        }
        return true;
    }

    private void logHeader(Headers headers, int n) {
        String string2 = this.headersToRedact.contains(headers.name(n)) ? "\u2588\u2588" : headers.value(n);
        Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(headers.name(n));
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        logger.log(stringBuilder.toString());
    }

    public Level getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response intercept(Interceptor.Chain object) throws IOException {
        Object object2;
        block37: {
            long l;
            Object object4;
            Object object5;
            Object object6;
            Object object3;
            block38: {
                long l2;
                int n;
                boolean bl;
                int n2;
                block36: {
                    block33: {
                        block32: {
                            block35: {
                                object3 = this.level;
                                object6 = object.request();
                                if (object3 == Level.NONE) {
                                    return object.proceed((Request)object6);
                                }
                                object5 = Level.BODY;
                                n2 = 1;
                                bl = object3 == object5;
                                n = !bl && object3 != Level.HEADERS ? 0 : 1;
                                object2 = ((Request)object6).body();
                                if (object2 == null) {
                                    n2 = 0;
                                }
                                object4 = object.connection();
                                object5 = new StringBuilder();
                                ((StringBuilder)object5).append("--> ");
                                ((StringBuilder)object5).append(((Request)object6).method());
                                ((StringBuilder)object5).append(' ');
                                ((StringBuilder)object5).append(((Request)object6).url());
                                if (object4 != null) {
                                    object3 = new StringBuilder();
                                    ((StringBuilder)object3).append(" ");
                                    ((StringBuilder)object3).append((Object)object4.protocol());
                                    object3 = ((StringBuilder)object3).toString();
                                } else {
                                    object3 = "";
                                }
                                ((StringBuilder)object5).append((String)object3);
                                object3 = object5 = ((StringBuilder)object5).toString();
                                if (n == 0) {
                                    object3 = object5;
                                    if (n2 != 0) {
                                        object3 = new StringBuilder();
                                        ((StringBuilder)object3).append((String)object5);
                                        ((StringBuilder)object3).append(" (");
                                        ((StringBuilder)object3).append(((RequestBody)object2).contentLength());
                                        ((StringBuilder)object3).append("-byte body)");
                                        object3 = ((StringBuilder)object3).toString();
                                    }
                                }
                                this.logger.log((String)object3);
                                if (n == 0) break block32;
                                if (n2 != 0) {
                                    if (((RequestBody)object2).contentType() != null) {
                                        object5 = this.logger;
                                        object3 = new StringBuilder();
                                        ((StringBuilder)object3).append("Content-Type: ");
                                        ((StringBuilder)object3).append(((RequestBody)object2).contentType());
                                        object5.log(((StringBuilder)object3).toString());
                                    }
                                    if (((RequestBody)object2).contentLength() != -1L) {
                                        object3 = this.logger;
                                        object5 = new StringBuilder();
                                        ((StringBuilder)object5).append("Content-Length: ");
                                        ((StringBuilder)object5).append(((RequestBody)object2).contentLength());
                                        object3.log(((StringBuilder)object5).toString());
                                    }
                                }
                                object3 = ((Request)object6).headers();
                                int n3 = ((Headers)object3).size();
                                for (int i = 0; i < n3; ++i) {
                                    object5 = ((Headers)object3).name(i);
                                    if ("Content-Type".equalsIgnoreCase((String)object5) || "Content-Length".equalsIgnoreCase((String)object5)) continue;
                                    this.logHeader((Headers)object3, i);
                                }
                                if (!bl || n2 == 0) break block35;
                                if (HttpLoggingInterceptor.bodyHasUnknownEncoding(((Request)object6).headers())) {
                                    object5 = this.logger;
                                    object3 = new StringBuilder();
                                    ((StringBuilder)object3).append("--> END ");
                                    ((StringBuilder)object3).append(((Request)object6).method());
                                    ((StringBuilder)object3).append(" (encoded body omitted)");
                                    object5.log(((StringBuilder)object3).toString());
                                    break block32;
                                } else {
                                    object4 = new Buffer();
                                    ((RequestBody)object2).writeTo((BufferedSink)object4);
                                    object5 = UTF8;
                                    MediaType mediaType = ((RequestBody)object2).contentType();
                                    object3 = object5;
                                    if (mediaType != null) {
                                        object3 = mediaType.charset((Charset)object5);
                                    }
                                    this.logger.log("");
                                    if (HttpLoggingInterceptor.isPlaintext((Buffer)object4)) {
                                        this.logger.log(((Buffer)object4).readString((Charset)object3));
                                        object3 = this.logger;
                                        object5 = new StringBuilder();
                                        ((StringBuilder)object5).append("--> END ");
                                        ((StringBuilder)object5).append(((Request)object6).method());
                                        ((StringBuilder)object5).append(" (");
                                        ((StringBuilder)object5).append(((RequestBody)object2).contentLength());
                                        ((StringBuilder)object5).append("-byte body)");
                                        object3.log(((StringBuilder)object5).toString());
                                        break block32;
                                    } else {
                                        object5 = this.logger;
                                        object3 = new StringBuilder();
                                        ((StringBuilder)object3).append("--> END ");
                                        ((StringBuilder)object3).append(((Request)object6).method());
                                        ((StringBuilder)object3).append(" (binary ");
                                        ((StringBuilder)object3).append(((RequestBody)object2).contentLength());
                                        ((StringBuilder)object3).append("-byte body omitted)");
                                        object5.log(((StringBuilder)object3).toString());
                                    }
                                }
                                break block32;
                            }
                            object5 = this.logger;
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("--> END ");
                            ((StringBuilder)object3).append(((Request)object6).method());
                            object5.log(((StringBuilder)object3).toString());
                        }
                        l = System.nanoTime();
                        try {
                            object2 = object.proceed((Request)object6);
                            l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
                            object4 = ((Response)object2).body();
                            l = ((ResponseBody)object4).contentLength();
                            if (l == -1L) break block33;
                            object = new StringBuilder();
                            ((StringBuilder)object).append(l);
                        }
                        catch (Exception exception) {
                            object = this.logger;
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("<-- HTTP FAILED: ");
                            ((StringBuilder)object3).append(exception);
                            object.log(((StringBuilder)object3).toString());
                            throw exception;
                        }
                        ((StringBuilder)object).append("-byte");
                        object = ((StringBuilder)object).toString();
                        break block36;
                    }
                    object = "unknown-length";
                }
                object6 = this.logger;
                object5 = new StringBuilder();
                ((StringBuilder)object5).append("<-- ");
                ((StringBuilder)object5).append(((Response)object2).code());
                if (((Response)object2).message().isEmpty()) {
                    object3 = "";
                } else {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append(' ');
                    ((StringBuilder)object3).append(((Response)object2).message());
                    object3 = ((StringBuilder)object3).toString();
                }
                ((StringBuilder)object5).append((String)object3);
                ((StringBuilder)object5).append(' ');
                ((StringBuilder)object5).append(((Response)object2).request().url());
                ((StringBuilder)object5).append(" (");
                ((StringBuilder)object5).append(l2);
                ((StringBuilder)object5).append("ms");
                if (n == 0) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append(", ");
                    ((StringBuilder)object3).append((String)object);
                    ((StringBuilder)object3).append(" body");
                    object = ((StringBuilder)object3).toString();
                } else {
                    object = "";
                }
                ((StringBuilder)object5).append((String)object);
                ((StringBuilder)object5).append(')');
                object6.log(((StringBuilder)object5).toString());
                if (n == 0) return object2;
                object = ((Response)object2).headers();
                n2 = ((Headers)object).size();
                for (n = 0; n < n2; ++n) {
                    this.logHeader((Headers)object, n);
                }
                if (!bl || !HttpHeaders.hasBody((Response)object2)) break block37;
                if (HttpLoggingInterceptor.bodyHasUnknownEncoding(((Response)object2).headers())) {
                    this.logger.log("<-- END HTTP (encoded body omitted)");
                    return object2;
                }
                object3 = ((ResponseBody)object4).source();
                object3.request(Long.MAX_VALUE);
                object6 = object3.buffer();
                bl = "gzip".equalsIgnoreCase(((Headers)object).get("Content-Encoding"));
                object3 = null;
                object5 = null;
                object = object6;
                if (bl) {
                    void var2_5;
                    block34: {
                        l2 = ((Buffer)object6).size();
                        try {
                            object = new GzipSource((Source)((Buffer)object6).clone());
                        }
                        catch (Throwable throwable) {
                            object = object5;
                            break block34;
                        }
                        try {
                            object5 = new Buffer();
                            ((Buffer)object5).writeAll((Source)object);
                        }
                        catch (Throwable throwable) {
                            break block34;
                        }
                        ((GzipSource)object).close();
                        object3 = l2;
                        object = object5;
                        break block38;
                    }
                    if (object == null) throw var2_5;
                    ((GzipSource)object).close();
                    throw var2_5;
                }
            }
            object6 = UTF8;
            object4 = ((ResponseBody)object4).contentType();
            object5 = object6;
            if (object4 != null) {
                object5 = ((MediaType)object4).charset((Charset)object6);
            }
            if (!HttpLoggingInterceptor.isPlaintext((Buffer)object)) {
                this.logger.log("");
                object3 = this.logger;
                object5 = new StringBuilder();
                ((StringBuilder)object5).append("<-- END HTTP (binary ");
                ((StringBuilder)object5).append(((Buffer)object).size());
                ((StringBuilder)object5).append("-byte body omitted)");
                object3.log(((StringBuilder)object5).toString());
                return object2;
            }
            if (l != 0L) {
                this.logger.log("");
                this.logger.log(((Buffer)((Buffer)object).clone()).readString((Charset)object5));
            }
            if (object3 != null) {
                object6 = this.logger;
                object5 = new StringBuilder();
                ((StringBuilder)object5).append("<-- END HTTP (");
                ((StringBuilder)object5).append(((Buffer)object).size());
                ((StringBuilder)object5).append("-byte, ");
                ((StringBuilder)object5).append(object3);
                ((StringBuilder)object5).append("-gzipped-byte body)");
                object6.log(((StringBuilder)object5).toString());
                return object2;
            }
            object3 = this.logger;
            object5 = new StringBuilder();
            ((StringBuilder)object5).append("<-- END HTTP (");
            ((StringBuilder)object5).append(((Buffer)object).size());
            ((StringBuilder)object5).append("-byte body)");
            object3.log(((StringBuilder)object5).toString());
            return object2;
        }
        this.logger.log("<-- END HTTP");
        return object2;
    }

    public void redactHeader(String string2) {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(this.headersToRedact);
        treeSet.add(string2);
        this.headersToRedact = treeSet;
    }

    public HttpLoggingInterceptor setLevel(Level level) {
        Objects.requireNonNull(level, "level == null. Use Level.NONE instead.");
        this.level = level;
        return this;
    }

    public static final class Level
    extends Enum<Level> {
        private static final /* synthetic */ Level[] $VALUES;
        public static final /* enum */ Level BASIC;
        public static final /* enum */ Level BODY;
        public static final /* enum */ Level HEADERS;
        public static final /* enum */ Level NONE;

        static {
            Level level;
            Level level2;
            Level level3;
            Level level4;
            NONE = level4 = new Level();
            BASIC = level3 = new Level();
            HEADERS = level2 = new Level();
            BODY = level = new Level();
            $VALUES = new Level[]{level4, level3, level2, level};
        }

        public static Level valueOf(String string2) {
            return Enum.valueOf(Level.class, string2);
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }
    }

    public static interface Logger {
        public static final Logger DEFAULT = new Logger(){

            @Override
            public void log(String string2) {
                Platform.get().log(4, string2, null);
            }
        };

        public void log(String var1);
    }
}

