/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.logging;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public final class LoggingEventListener
extends EventListener {
    private final HttpLoggingInterceptor.Logger logger;
    private long startNs;

    private LoggingEventListener(HttpLoggingInterceptor.Logger logger) {
        this.logger = logger;
    }

    private void logWithTime(String string2) {
        long l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
        HttpLoggingInterceptor.Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(l);
        stringBuilder.append(" ms] ");
        stringBuilder.append(string2);
        logger.log(stringBuilder.toString());
    }

    @Override
    public void callEnd(Call call) {
        this.logWithTime("callEnd");
    }

    @Override
    public void callFailed(Call object, IOException iOException) {
        object = new StringBuilder();
        ((StringBuilder)object).append("callFailed: ");
        ((StringBuilder)object).append(iOException);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void callStart(Call call) {
        this.startNs = System.nanoTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("callStart: ");
        stringBuilder.append(call.request());
        this.logWithTime(stringBuilder.toString());
    }

    @Override
    public void connectEnd(Call object, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        object = new StringBuilder();
        ((StringBuilder)object).append("connectEnd: ");
        ((StringBuilder)object).append((Object)protocol);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void connectFailed(Call object, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException iOException) {
        object = new StringBuilder();
        ((StringBuilder)object).append("connectFailed: ");
        ((StringBuilder)object).append((Object)protocol);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(iOException);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void connectStart(Call object, InetSocketAddress inetSocketAddress, Proxy proxy) {
        object = new StringBuilder();
        ((StringBuilder)object).append("connectStart: ");
        ((StringBuilder)object).append(inetSocketAddress);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(proxy);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void connectionAcquired(Call object, Connection connection) {
        object = new StringBuilder();
        ((StringBuilder)object).append("connectionAcquired: ");
        ((StringBuilder)object).append(connection);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void connectionReleased(Call call, Connection connection) {
        this.logWithTime("connectionReleased");
    }

    @Override
    public void dnsEnd(Call object, String string2, List<InetAddress> list) {
        object = new StringBuilder();
        ((StringBuilder)object).append("dnsEnd: ");
        ((StringBuilder)object).append(list);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void dnsStart(Call object, String string2) {
        object = new StringBuilder();
        ((StringBuilder)object).append("dnsStart: ");
        ((StringBuilder)object).append(string2);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void requestBodyEnd(Call object, long l) {
        object = new StringBuilder();
        ((StringBuilder)object).append("requestBodyEnd: byteCount=");
        ((StringBuilder)object).append(l);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void requestBodyStart(Call call) {
        this.logWithTime("requestBodyStart");
    }

    @Override
    public void requestHeadersEnd(Call call, Request request) {
        this.logWithTime("requestHeadersEnd");
    }

    @Override
    public void requestHeadersStart(Call call) {
        this.logWithTime("requestHeadersStart");
    }

    @Override
    public void responseBodyEnd(Call object, long l) {
        object = new StringBuilder();
        ((StringBuilder)object).append("responseBodyEnd: byteCount=");
        ((StringBuilder)object).append(l);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void responseBodyStart(Call call) {
        this.logWithTime("responseBodyStart");
    }

    @Override
    public void responseHeadersEnd(Call object, Response response) {
        object = new StringBuilder();
        ((StringBuilder)object).append("responseHeadersEnd: ");
        ((StringBuilder)object).append(response);
        this.logWithTime(((StringBuilder)object).toString());
    }

    @Override
    public void responseHeadersStart(Call call) {
        this.logWithTime("responseHeadersStart");
    }

    @Override
    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        this.logWithTime("secureConnectEnd");
    }

    @Override
    public void secureConnectStart(Call call) {
        this.logWithTime("secureConnectStart");
    }

    public static class Factory
    implements EventListener.Factory {
        private final HttpLoggingInterceptor.Logger logger;

        public Factory() {
            this(HttpLoggingInterceptor.Logger.DEFAULT);
        }

        public Factory(HttpLoggingInterceptor.Logger logger) {
            this.logger = logger;
        }

        @Override
        public EventListener create(Call call) {
            return new LoggingEventListener(this.logger);
        }
    }
}

