/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public class AsyncTimeout
extends Timeout {
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    @Nullable
    static AsyncTimeout head;
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;

    static {
        long l;
        IDLE_TIMEOUT_MILLIS = l = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(l);
    }

    @Nullable
    static AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        Object var1_1 = null;
        if (asyncTimeout == null) {
            long l = System.nanoTime();
            AsyncTimeout.class.wait(IDLE_TIMEOUT_MILLIS);
            asyncTimeout = var1_1;
            if (AsyncTimeout.head.next == null) {
                asyncTimeout = var1_1;
                if (System.nanoTime() - l >= IDLE_TIMEOUT_NANOS) {
                    asyncTimeout = head;
                }
            }
            return asyncTimeout;
        }
        long l = asyncTimeout.remainingNanos(System.nanoTime());
        if (l > 0L) {
            long l2 = l / 1000000L;
            AsyncTimeout.class.wait(l2, (int)(l - 1000000L * l2));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    private static boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        synchronized (AsyncTimeout.class) {
            AsyncTimeout asyncTimeout2;
            try {
                asyncTimeout2 = head;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
            while (asyncTimeout2 != null) {
                AsyncTimeout asyncTimeout3;
                block7: {
                    asyncTimeout3 = asyncTimeout2.next;
                    if (asyncTimeout3 != asyncTimeout) break block7;
                    asyncTimeout2.next = asyncTimeout.next;
                    asyncTimeout.next = null;
                    return false;
                }
                asyncTimeout2 = asyncTimeout3;
            }
            return true;
        }
    }

    private long remainingNanos(long l) {
        return this.timeoutAt - l;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void scheduleTimeout(AsyncTimeout object, long l, boolean bl) {
        synchronized (AsyncTimeout.class) {
            AsyncTimeout asyncTimeout;
            void var3_2;
            long l2;
            Object object2;
            if (head == null) {
                object2 = new AsyncTimeout();
                head = object2;
                object2 = new Watchdog();
                ((Thread)object2).start();
            }
            long l3 = System.nanoTime();
            long l4 = l2 - 0L;
            int n = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            if (n != 0 && var3_2 != false) {
                ((AsyncTimeout)object).timeoutAt = Math.min(l2, ((Timeout)object).deadlineNanoTime() - l3) + l3;
            } else if (n != 0) {
                ((AsyncTimeout)object).timeoutAt = l2 + l3;
            } else {
                if (var3_2 == false) {
                    object = new AssertionError();
                    throw object;
                }
                ((AsyncTimeout)object).timeoutAt = ((Timeout)object).deadlineNanoTime();
            }
            l2 = super.remainingNanos(l3);
            object2 = head;
            while ((asyncTimeout = ((AsyncTimeout)object2).next) != null && l2 >= asyncTimeout.remainingNanos(l3)) {
                object2 = ((AsyncTimeout)object2).next;
            }
            ((AsyncTimeout)object).next = ((AsyncTimeout)object2).next;
            ((AsyncTimeout)object2).next = object;
            if (object2 == head) {
                AsyncTimeout.class.notify();
            }
            return;
        }
    }

    public final void enter() {
        if (!this.inQueue) {
            long l = this.timeoutNanos();
            boolean bl = this.hasDeadline();
            if (l == 0L && !bl) {
                return;
            }
            this.inQueue = true;
            AsyncTimeout.scheduleTimeout(this, l, bl);
            return;
        }
        throw new IllegalStateException("Unbalanced enter/exit");
    }

    final IOException exit(IOException iOException) throws IOException {
        if (!this.exit()) {
            return iOException;
        }
        return this.newTimeoutException(iOException);
    }

    final void exit(boolean bl) throws IOException {
        if (this.exit() && bl) {
            throw this.newTimeoutException(null);
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    protected IOException newTimeoutException(@Nullable IOException iOException) {
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    public final Sink sink(final Sink sink) {
        return new Sink(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void close() throws IOException {
                Throwable throwable2222222;
                block4: {
                    AsyncTimeout.this.enter();
                    sink.close();
                    {
                        catch (Throwable throwable2222222) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                    return;
                }
                AsyncTimeout.this.exit(false);
                throw throwable2222222;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void flush() throws IOException {
                Throwable throwable2222222;
                block4: {
                    AsyncTimeout.this.enter();
                    sink.flush();
                    {
                        catch (Throwable throwable2222222) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                    return;
                }
                AsyncTimeout.this.exit(false);
                throw throwable2222222;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("AsyncTimeout.sink(");
                stringBuilder.append(sink);
                stringBuilder.append(")");
                return stringBuilder.toString();
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void write(Buffer buffer, long l) throws IOException {
                Throwable throwable2222222;
                Util.checkOffsetAndCount(buffer.size, 0L, l);
                while (true) {
                    long l2;
                    long l3 = 0L;
                    if (l <= 0L) {
                        return;
                    }
                    Segment segment = buffer.head;
                    while (true) {
                        l2 = l3;
                        if (l3 >= 65536L) break;
                        if ((l3 += (long)(segment.limit - segment.pos)) >= l) {
                            l2 = l;
                            break;
                        }
                        segment = segment.next;
                    }
                    AsyncTimeout.this.enter();
                    sink.write(buffer, l2);
                    l -= l2;
                    {
                        catch (Throwable throwable2222222) {
                            break;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                }
                AsyncTimeout.this.exit(false);
                throw throwable2222222;
            }
        };
    }

    public final Source source(final Source source) {
        return new Source(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void close() throws IOException {
                Throwable throwable2222222;
                block4: {
                    AsyncTimeout.this.enter();
                    source.close();
                    {
                        catch (Throwable throwable2222222) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                    return;
                }
                AsyncTimeout.this.exit(false);
                throw throwable2222222;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public long read(Buffer buffer, long l) throws IOException {
                Throwable throwable2222222;
                block4: {
                    AsyncTimeout.this.enter();
                    l = source.read(buffer, l);
                    {
                        catch (Throwable throwable2222222) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                    return l;
                }
                AsyncTimeout.this.exit(false);
                throw throwable2222222;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("AsyncTimeout.source(");
                stringBuilder.append(source);
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
        };
    }

    protected void timedOut() {
    }

    private static final class Watchdog
    extends Thread {
        Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                AsyncTimeout asyncTimeout;
                try {
                    synchronized (AsyncTimeout.class) {
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                {
                    asyncTimeout = AsyncTimeout.awaitTimeout();
                    if (asyncTimeout == null) {
                        continue;
                    }
                    if (asyncTimeout == head) {
                        head = null;
                        return;
                    }
                }
                {
                    asyncTimeout.timedOut();
                    continue;
                }
                break;
            }
        }
    }
}

