/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.PeekSource;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public final class Buffer
implements BufferedSource,
BufferedSink,
Cloneable,
ByteChannel {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    @Nullable
    Segment head;
    long size;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteString digest(String object) {
        MessageDigest messageDigest = MessageDigest.getInstance((String)object);
        object = this.head;
        if (object == null) return ByteString.of(messageDigest.digest());
        try {
            messageDigest.update(((Segment)object).data, this.head.pos, this.head.limit - this.head.pos);
            object = this.head;
            while ((object = ((Segment)object).next) != this.head) {
                messageDigest.update(((Segment)object).data, ((Segment)object).pos, ((Segment)object).limit - ((Segment)object).pos);
            }
            return ByteString.of(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteString hmac(String object, ByteString byteString) {
        Mac mac = Mac.getInstance((String)object);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byteString.toByteArray(), (String)object);
        mac.init(secretKeySpec);
        object = this.head;
        if (object == null) return ByteString.of(mac.doFinal());
        try {
            mac.update(((Segment)object).data, this.head.pos, this.head.limit - this.head.pos);
            object = this.head;
            while ((object = ((Segment)object).next) != this.head) {
                mac.update(((Segment)object).data, ((Segment)object).pos, ((Segment)object).limit - ((Segment)object).pos);
            }
            return ByteString.of(mac.doFinal());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private boolean rangeEquals(Segment object, int n, ByteString byteString, int n2, int n3) {
        int n4 = ((Segment)object).limit;
        Object object2 = ((Segment)object).data;
        while (n2 < n3) {
            int n5 = n4;
            Segment segment = object;
            int n6 = n;
            if (n == n4) {
                segment = ((Segment)object).next;
                object = segment.data;
                n6 = segment.pos;
                n5 = segment.limit;
                object2 = object;
            }
            if (object2[n6] != byteString.getByte(n2)) {
                return false;
            }
            n = n6 + 1;
            ++n2;
            n4 = n5;
            object = segment;
        }
        return true;
    }

    private void readFrom(InputStream inputStream, long l, boolean bl) throws IOException {
        if (inputStream != null) {
            while (true) {
                if (l <= 0L && !bl) {
                    return;
                }
                Segment segment = this.writableSegment(1);
                int n = (int)Math.min(l, (long)(8192 - segment.limit));
                if ((n = inputStream.read(segment.data, segment.limit, n)) == -1) {
                    if (bl) {
                        return;
                    }
                    throw new EOFException();
                }
                segment.limit += n;
                long l2 = this.size;
                long l3 = n;
                this.size = l2 + l3;
                l -= l3;
            }
        }
        throw new IllegalArgumentException("in == null");
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    public final void clear() {
        try {
            this.skip(this.size);
            return;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    public Buffer clone() {
        Segment segment;
        Buffer buffer = new Buffer();
        if (this.size == 0L) {
            return buffer;
        }
        buffer.head = segment = this.head.sharedCopy();
        segment.prev = segment;
        segment.next = segment;
        segment = this.head;
        while ((segment = segment.next) != this.head) {
            buffer.head.prev.push(segment.sharedCopy());
        }
        buffer.size = this.size;
        return buffer;
    }

    @Override
    public void close() {
    }

    public final long completeSegmentByteCount() {
        long l = this.size;
        if (l == 0L) {
            return 0L;
        }
        Segment segment = this.head.prev;
        long l2 = l;
        if (segment.limit < 8192) {
            l2 = l;
            if (segment.owner) {
                l2 = l - (long)(segment.limit - segment.pos);
            }
        }
        return l2;
    }

    public final Buffer copyTo(OutputStream outputStream) throws IOException {
        return this.copyTo(outputStream, 0L, this.size);
    }

    public final Buffer copyTo(OutputStream outputStream, long l, long l2) throws IOException {
        if (outputStream != null) {
            int n;
            long l3;
            Segment segment;
            Util.checkOffsetAndCount(this.size, l, l2);
            if (l2 == 0L) {
                return this;
            }
            Segment segment2 = this.head;
            while (true) {
                segment = segment2;
                l3 = l;
                if (l < (long)(segment2.limit - segment2.pos)) break;
                l -= (long)(segment2.limit - segment2.pos);
                segment2 = segment2.next;
            }
            for (long i = l2; i > 0L; i -= (long)n) {
                int n2 = (int)((long)segment.pos + l3);
                n = (int)Math.min((long)(segment.limit - n2), i);
                outputStream.write(segment.data, n2, n);
                segment = segment.next;
                l3 = 0L;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer copyTo(Buffer buffer, long l, long l2) {
        if (buffer != null) {
            long l3;
            Segment segment;
            Util.checkOffsetAndCount(this.size, l, l2);
            if (l2 == 0L) {
                return this;
            }
            buffer.size += l2;
            Segment segment2 = this.head;
            while (true) {
                segment = segment2;
                l3 = l;
                if (l < (long)(segment2.limit - segment2.pos)) break;
                l -= (long)(segment2.limit - segment2.pos);
                segment2 = segment2.next;
            }
            for (long i = l2; i > 0L; i -= (long)(segment2.limit - segment2.pos)) {
                segment2 = segment.sharedCopy();
                segment2.pos = (int)((long)segment2.pos + l3);
                segment2.limit = Math.min(segment2.pos + (int)i, segment2.limit);
                Segment segment3 = buffer.head;
                if (segment3 == null) {
                    segment2.prev = segment2;
                    segment2.next = segment2;
                    buffer.head = segment2;
                } else {
                    segment3.prev.push(segment2);
                }
                segment = segment.next;
                l3 = 0L;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    @Override
    public BufferedSink emit() {
        return this;
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        object = (Buffer)object;
        long l = this.size;
        if (l != ((Buffer)object).size) {
            return false;
        }
        if (l == 0L) {
            return true;
        }
        Segment segment = this.head;
        object = ((Buffer)object).head;
        int n = segment.pos;
        int n2 = ((Segment)object).pos;
        for (long i = 0L; i < this.size; i += l) {
            l = Math.min(segment.limit - n, ((Segment)object).limit - n2);
            int n3 = 0;
            while ((long)n3 < l) {
                if (segment.data[n] != ((Segment)object).data[n2]) {
                    return false;
                }
                ++n3;
                ++n;
                ++n2;
            }
            Segment segment2 = segment;
            n3 = n;
            if (n == segment.limit) {
                segment2 = segment.next;
                n3 = segment2.pos;
            }
            int n4 = n2;
            Object object2 = object;
            if (n2 == ((Segment)object).limit) {
                object2 = ((Segment)object).next;
                n4 = ((Segment)object2).pos;
            }
            segment = segment2;
            n = n3;
            n2 = n4;
            object = object2;
        }
        return true;
    }

    @Override
    public boolean exhausted() {
        boolean bl = this.size == 0L;
        return bl;
    }

    @Override
    public void flush() {
    }

    @Override
    public Buffer getBuffer() {
        return this;
    }

    public final byte getByte(long l) {
        Segment segment;
        Util.checkOffsetAndCount(this.size, l, 1L);
        long l2 = this.size;
        if (l2 - l > l) {
            Segment segment2 = this.head;
            while (true) {
                if (l < (l2 = (long)(segment2.limit - segment2.pos))) {
                    return segment2.data[segment2.pos + (int)l];
                }
                l -= l2;
                segment2 = segment2.next;
            }
        }
        l -= l2;
        Segment segment3 = this.head;
        do {
            segment = segment3.prev;
            l2 = l + (long)(segment.limit - segment.pos);
            segment3 = segment;
            l = l2;
        } while (l2 < 0L);
        return segment.data[segment.pos + (int)l2];
    }

    public int hashCode() {
        int n;
        Segment segment;
        Segment segment2 = this.head;
        if (segment2 == null) {
            return 0;
        }
        int n2 = 1;
        do {
            int n3 = segment2.limit;
            n = n2;
            for (int i = segment2.pos; i < n3; ++i) {
                n = n * 31 + segment2.data[i];
            }
            segment2 = segment = segment2.next;
            n2 = n;
        } while (segment != this.head);
        return n;
    }

    public final ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public final ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public final ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l) {
        return this.indexOf(by, l, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l, long l2) {
        long l3 = 0L;
        if (l >= 0L && l2 >= l) {
            long l4 = this.size;
            long l5 = l2 > l4 ? l4 : l2;
            if (l == l5) {
                return -1L;
            }
            Object object = this.head;
            if (object == null) {
                return -1L;
            }
            l2 = l3;
            Segment segment = object;
            if (l4 - l < l) {
                while (true) {
                    l2 = l4;
                    segment = object;
                    if (l4 > l) {
                        object = ((Segment)object).prev;
                        l4 -= (long)(((Segment)object).limit - ((Segment)object).pos);
                        continue;
                    }
                    break;
                }
            } else {
                while ((l4 = (long)(segment.limit - segment.pos) + l2) < l) {
                    segment = segment.next;
                    l2 = l4;
                }
            }
            while (l2 < l5) {
                object = segment.data;
                int n = (int)Math.min((long)segment.limit, (long)segment.pos + l5 - l2);
                for (int i = (int)((long)segment.pos + l - l2); i < n; ++i) {
                    if (object[i] != by) continue;
                    return (long)(i - segment.pos) + l2;
                }
                segment = segment.next;
                l = l2 += (long)(segment.limit - segment.pos);
            }
            return -1L;
        }
        throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", this.size, l, l2));
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l) throws IOException {
        if (byteString.size() != 0) {
            long l2 = 0L;
            if (l >= 0L) {
                Object object = this.head;
                if (object == null) {
                    return -1L;
                }
                long l3 = this.size;
                Segment segment = object;
                if (l3 - l < l) {
                    segment = object;
                    while (true) {
                        object = segment;
                        l2 = l3;
                        if (l3 > l) {
                            segment = segment.prev;
                            l3 -= (long)(segment.limit - segment.pos);
                            continue;
                        }
                        break;
                    }
                } else {
                    while ((l3 = (long)(segment.limit - segment.pos) + l2) < l) {
                        segment = segment.next;
                        l2 = l3;
                    }
                    object = segment;
                }
                byte by = byteString.getByte(0);
                int n = byteString.size();
                l3 = 1L + (this.size - (long)n);
                segment = object;
                while (l2 < l3) {
                    object = segment.data;
                    int n2 = (int)Math.min((long)segment.limit, (long)segment.pos + l3 - l2);
                    for (int i = (int)((long)segment.pos + l - l2); i < n2; ++i) {
                        if (object[i] != by || !this.rangeEquals(segment, i + 1, byteString, 1, n)) continue;
                        return (long)(i - segment.pos) + l2;
                    }
                    segment = segment.next;
                    l = l2 += (long)(segment.limit - segment.pos);
                }
                return -1L;
            }
            throw new IllegalArgumentException("fromIndex < 0");
        }
        throw new IllegalArgumentException("bytes is empty");
    }

    @Override
    public long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long indexOfElement(ByteString object, long l) {
        int n;
        int n2;
        long l2 = 0L;
        if (l < 0L) throw new IllegalArgumentException("fromIndex < 0");
        Object object2 = this.head;
        if (object2 == null) {
            return -1L;
        }
        long l3 = this.size;
        Segment segment = object2;
        if (l3 - l < l) {
            while (true) {
                segment = object2;
                l2 = l3;
                if (l3 > l) {
                    object2 = ((Segment)object2).prev;
                    l3 -= (long)(((Segment)object2).limit - ((Segment)object2).pos);
                    continue;
                }
                break;
            }
        } else {
            while ((l3 = (long)(segment.limit - segment.pos) + l2) < l) {
                segment = segment.next;
                l2 = l3;
            }
        }
        if (((ByteString)object).size() == 2) {
            byte by = ((ByteString)object).getByte(0);
            n2 = ((ByteString)object).getByte(1);
            while (l2 < this.size) {
                object = segment.data;
                int n3 = segment.limit;
                for (n = (int)((long)segment.pos + l - l2); n < n3; ++n) {
                    Object object3 = object[n];
                    if (object3 != by && object3 != n2) {
                        continue;
                    }
                    n2 = segment.pos;
                    return (long)(n - n2) + l2;
                }
                segment = segment.next;
                l = l2 += (long)(segment.limit - segment.pos);
            }
            return -1L;
        } else {
            object = ((ByteString)object).internalArray();
            while (l2 < this.size) {
                object2 = segment.data;
                int n4 = segment.limit;
                for (n = (int)((long)segment.pos + l - l2); n < n4; ++n) {
                    Object object4 = object2[n];
                    int n5 = ((Object)object).length;
                    for (n2 = 0; n2 < n5; ++n2) {
                        if (object4 != object[n2]) continue;
                        n2 = segment.pos;
                        return (long)(n - n2) + l2;
                    }
                }
                segment = segment.next;
                l = l2 += (long)(segment.limit - segment.pos);
            }
        }
        return -1L;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int available() {
                return (int)Math.min(Buffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            @Override
            public int read() {
                if (Buffer.this.size > 0L) {
                    return Buffer.this.readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) {
                return Buffer.this.read(byArray, n, n2);
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Buffer.this);
                stringBuilder.append(".inputStream()");
                return stringBuilder.toString();
            }
        };
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    public final ByteString md5() {
        return this.digest("MD5");
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Buffer.this);
                stringBuilder.append(".outputStream()");
                return stringBuilder.toString();
            }

            @Override
            public void write(int n) {
                Buffer.this.writeByte((byte)n);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                Buffer.this.write(byArray, n, n2);
            }
        };
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString) {
        return this.rangeEquals(l, byteString, 0, byteString.size());
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString, int n, int n2) {
        if (l >= 0L && n >= 0 && n2 >= 0 && this.size - l >= (long)n2 && byteString.size() - n >= n2) {
            for (int i = 0; i < n2; ++i) {
                if (this.getByte((long)i + l) == byteString.getByte(n + i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        int n = Math.min(byteBuffer.remaining(), segment.limit - segment.pos);
        byteBuffer.put(segment.data, segment.pos, n);
        segment.pos += n;
        this.size -= (long)n;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        Util.checkOffsetAndCount(byArray.length, n, n2);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        n2 = Math.min(n2, segment.limit - segment.pos);
        System.arraycopy(segment.data, segment.pos, byArray, n, n2);
        segment.pos += n2;
        this.size -= (long)n2;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n2;
    }

    @Override
    public long read(Buffer object, long l) {
        if (object != null) {
            if (l >= 0L) {
                long l2 = this.size;
                if (l2 == 0L) {
                    return -1L;
                }
                long l3 = l;
                if (l > l2) {
                    l3 = l2;
                }
                ((Buffer)object).write(this, l3);
                return l3;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        long l = this.size;
        if (l > 0L) {
            sink.write(this, l);
        }
        return l;
    }

    public final UnsafeCursor readAndWriteUnsafe() {
        return this.readAndWriteUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readAndWriteUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer == null) {
            unsafeCursor.buffer = this;
            unsafeCursor.readWrite = true;
            return unsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer");
    }

    @Override
    public byte readByte() {
        if (this.size != 0L) {
            Segment segment = this.head;
            int n = segment.pos;
            int n2 = segment.limit;
            byte[] byArray = segment.data;
            int n3 = n + 1;
            byte by = byArray[n];
            --this.size;
            if (n3 == n2) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n3;
            }
            return by;
        }
        throw new IllegalStateException("size == 0");
    }

    @Override
    public byte[] readByteArray() {
        try {
            byte[] byArray = this.readByteArray(this.size);
            return byArray;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public byte[] readByteArray(long l) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l);
        if (l <= Integer.MAX_VALUE) {
            byte[] byArray = new byte[(int)l];
            this.readFully(byArray);
            return byArray;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("byteCount > Integer.MAX_VALUE: ");
        stringBuilder.append(l);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public ByteString readByteString(long l) throws EOFException {
        return new ByteString(this.readByteArray(l));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long readDecimalLong() {
        long l = this.size;
        long l2 = 0L;
        if (l == 0L) throw new IllegalStateException("size == 0");
        l = -7L;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            int n5;
            Object object;
            block9: {
                byte by;
                object = this.head;
                Object object2 = ((Segment)object).data;
                n5 = ((Segment)object).pos;
                n4 = ((Segment)object).limit;
                while (true) {
                    block10: {
                        n3 = n2;
                        if (n5 >= n4) break block9;
                        by = object2[n5];
                        if (by >= 48 && by <= 57) {
                            n3 = 48 - by;
                            long l3 = l2 - -922337203685477580L;
                            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                            if (l4 >= 0 && (l4 != false || (long)n3 >= l)) {
                                l2 = l2 * 10L + (long)n3;
                                break block10;
                            } else {
                                object = new Buffer().writeDecimalLong(l2).writeByte(by);
                                if (!bl) {
                                    ((Buffer)object).readByte();
                                }
                                object2 = new StringBuilder();
                                ((StringBuilder)object2).append("Number too large: ");
                                ((StringBuilder)object2).append(((Buffer)object).readUtf8());
                                throw new NumberFormatException(((StringBuilder)object2).toString());
                            }
                        }
                        if (by != 45 || n != 0) break;
                        --l;
                        bl = true;
                    }
                    ++n5;
                    ++n;
                }
                if (n == 0) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Expected leading [0-9] or '-' character but was 0x");
                    ((StringBuilder)object2).append(Integer.toHexString(by));
                    throw new NumberFormatException(((StringBuilder)object2).toString());
                }
                n3 = 1;
            }
            if (n5 == n4) {
                this.head = ((Segment)object).pop();
                SegmentPool.recycle((Segment)object);
            } else {
                ((Segment)object).pos = n5;
            }
            if (n3 != 0 || this.head == null) break;
            n2 = n3;
        }
        this.size -= (long)n;
        if (!bl) return -l2;
        return l2;
    }

    public final Buffer readFrom(InputStream inputStream) throws IOException {
        this.readFrom(inputStream, Long.MAX_VALUE, true);
        return this;
    }

    public final Buffer readFrom(InputStream object, long l) throws IOException {
        if (l >= 0L) {
            this.readFrom((InputStream)object, l, false);
            return this;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("byteCount < 0: ");
        ((StringBuilder)object).append(l);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public void readFully(Buffer buffer, long l) throws EOFException {
        long l2 = this.size;
        if (l2 >= l) {
            buffer.write(this, l);
            return;
        }
        buffer.write(this, l2);
        throw new EOFException();
    }

    @Override
    public void readFully(byte[] byArray) throws EOFException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = this.read(byArray, i, byArray.length - i);
            if (n != -1) {
                continue;
            }
            throw new EOFException();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long readHexadecimalUnsignedLong() {
        int n;
        long l;
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        int n2 = 0;
        long l2 = 0L;
        byte by = 0;
        do {
            byte by2;
            int n3;
            int n4;
            Object object;
            block11: {
                object = this.head;
                Object object2 = ((Segment)object).data;
                n4 = ((Segment)object).pos;
                n3 = ((Segment)object).limit;
                l = l2;
                n = n2;
                while (true) {
                    by2 = by;
                    if (n4 >= n3) break block11;
                    by2 = object2[n4];
                    if (by2 >= 48 && by2 <= 57) {
                        n2 = by2 - 48;
                    } else {
                        if (by2 >= 97 && by2 <= 102) {
                            n2 = by2 - 97;
                        } else {
                            if (by2 < 65 || by2 > 70) break;
                            n2 = by2 - 65;
                        }
                        n2 += 10;
                    }
                    if ((0xF000000000000000L & l) != 0L) {
                        object2 = new Buffer().writeHexadecimalUnsignedLong(l).writeByte(by2);
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Number too large: ");
                        ((StringBuilder)object).append(((Buffer)object2).readUtf8());
                        throw new NumberFormatException(((StringBuilder)object).toString());
                    }
                    l = l << 4 | (long)n2;
                    ++n4;
                    ++n;
                }
                if (n == 0) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Expected leading [0-9a-fA-F] character but was 0x");
                    ((StringBuilder)object2).append(Integer.toHexString(by2));
                    throw new NumberFormatException(((StringBuilder)object2).toString());
                }
                by2 = 1;
            }
            if (n4 == n3) {
                this.head = ((Segment)object).pop();
                SegmentPool.recycle((Segment)object);
            } else {
                ((Segment)object).pos = n4;
            }
            if (by2 != 0) break;
            n2 = n;
            by = by2;
            l2 = l;
        } while (this.head != null);
        this.size -= (long)n;
        return l;
    }

    @Override
    public int readInt() {
        if (this.size >= 4L) {
            Segment segment = this.head;
            int n = segment.limit;
            int n2 = segment.pos;
            if (n - n2 < 4) {
                return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            }
            byte[] byArray = segment.data;
            int n3 = n2 + 1;
            n2 = byArray[n2];
            int n4 = n3 + 1;
            n3 = byArray[n3];
            int n5 = n4 + 1;
            n4 = byArray[n4];
            int n6 = n5 + 1;
            n5 = byArray[n5];
            this.size -= 4L;
            if (n6 == n) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n6;
            }
            return (n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n5 & 0xFF;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size < 4: ");
        stringBuilder.append(this.size);
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLong() {
        if (this.size >= 8L) {
            Segment segment = this.head;
            int n = segment.limit;
            int n2 = segment.pos;
            if (n - n2 < 8) {
                return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL & (long)this.readInt();
            }
            byte[] byArray = segment.data;
            int n3 = n2 + 1;
            long l = byArray[n2];
            n2 = n3 + 1;
            long l2 = byArray[n3];
            n3 = n2 + 1;
            long l3 = byArray[n2];
            n2 = n3 + 1;
            long l4 = byArray[n3];
            n3 = n2 + 1;
            long l5 = byArray[n2];
            n2 = n3 + 1;
            long l6 = byArray[n3];
            n3 = n2 + 1;
            long l7 = byArray[n2];
            n2 = n3 + 1;
            long l8 = byArray[n3];
            this.size -= 8L;
            if (n2 == n) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n2;
            }
            return l8 & 0xFFL | ((l & 0xFFL) << 56 | (l2 & 0xFFL) << 48 | (l3 & 0xFFL) << 40 | (l4 & 0xFFL) << 32 | (l5 & 0xFFL) << 24 | (l6 & 0xFFL) << 16 | (l7 & 0xFFL) << 8);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size < 8: ");
        stringBuilder.append(this.size);
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public short readShort() {
        if (this.size >= 2L) {
            Segment segment = this.head;
            int n = segment.limit;
            int n2 = segment.pos;
            if (n - n2 < 2) {
                return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            }
            byte[] byArray = segment.data;
            int n3 = n2 + 1;
            byte by = byArray[n2];
            n2 = n3 + 1;
            n3 = byArray[n3];
            this.size -= 2L;
            if (n2 == n) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n2;
            }
            return (short)((by & 0xFF) << 8 | n3 & 0xFF);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size < 2: ");
        stringBuilder.append(this.size);
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public String readString(long l, Charset object) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l);
        if (object != null) {
            if (l <= Integer.MAX_VALUE) {
                if (l == 0L) {
                    return "";
                }
                Segment segment = this.head;
                if ((long)segment.pos + l > (long)segment.limit) {
                    return new String(this.readByteArray(l), (Charset)object);
                }
                object = new String(segment.data, segment.pos, (int)l, (Charset)object);
                segment.pos = (int)((long)segment.pos + l);
                this.size -= l;
                if (segment.pos == segment.limit) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount > Integer.MAX_VALUE: ");
            ((StringBuilder)object).append(l);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    public String readString(Charset object) {
        try {
            object = this.readString(this.size, (Charset)object);
            return object;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    public final UnsafeCursor readUnsafe() {
        return this.readUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer == null) {
            unsafeCursor.buffer = this;
            unsafeCursor.readWrite = false;
            return unsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer");
    }

    @Override
    public String readUtf8() {
        try {
            String string2 = this.readString(this.size, Util.UTF_8);
            return string2;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readUtf8(long l) throws EOFException {
        return this.readString(l, Util.UTF_8);
    }

    @Override
    public int readUtf8CodePoint() throws EOFException {
        block9: {
            block14: {
                int n;
                int n2;
                int n3;
                int n4;
                byte by;
                block11: {
                    block13: {
                        block12: {
                            block10: {
                                if (this.size == 0L) break block9;
                                by = this.getByte(0L);
                                n4 = 1;
                                if ((by & 0x80) != 0) break block10;
                                n3 = by & 0x7F;
                                n2 = 1;
                                n = 0;
                                break block11;
                            }
                            if ((by & 0xE0) != 192) break block12;
                            n3 = by & 0x1F;
                            n2 = 2;
                            n = 128;
                            break block11;
                        }
                        if ((by & 0xF0) != 224) break block13;
                        n3 = by & 0xF;
                        n2 = 3;
                        n = 2048;
                        break block11;
                    }
                    if ((by & 0xF8) != 240) break block14;
                    n3 = by & 7;
                    n2 = 4;
                    n = 65536;
                }
                long l = this.size;
                long l2 = n2;
                if (l >= l2) {
                    while (n4 < n2) {
                        l = n4;
                        by = this.getByte(l);
                        if ((by & 0xC0) == 128) {
                            n3 = n3 << 6 | by & 0x3F;
                            ++n4;
                            continue;
                        }
                        this.skip(l);
                        return 65533;
                    }
                    this.skip(l2);
                    if (n3 > 0x10FFFF) {
                        return 65533;
                    }
                    if (n3 >= 55296 && n3 <= 57343) {
                        return 65533;
                    }
                    if (n3 < n) {
                        return 65533;
                    }
                    return n3;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("size < ");
                stringBuilder.append(n2);
                stringBuilder.append(": ");
                stringBuilder.append(this.size);
                stringBuilder.append(" (to read code point prefixed 0x");
                stringBuilder.append(Integer.toHexString(by));
                stringBuilder.append(")");
                throw new EOFException(stringBuilder.toString());
            }
            this.skip(1L);
            return 65533;
        }
        throw new EOFException();
    }

    @Override
    @Nullable
    public String readUtf8Line() throws EOFException {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            l = this.size;
            String string2 = l != 0L ? this.readUtf8(l) : null;
            return string2;
        }
        return this.readUtf8Line(l);
    }

    String readUtf8Line(long l) throws EOFException {
        long l2;
        if (l > 0L && this.getByte(l2 = l - 1L) == 13) {
            String string2 = this.readUtf8(l2);
            this.skip(2L);
            return string2;
        }
        String string3 = this.readUtf8(l);
        this.skip(1L);
        return string3;
    }

    @Override
    public String readUtf8LineStrict() throws EOFException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l) throws EOFException {
        if (l >= 0L) {
            long l2 = Long.MAX_VALUE;
            if (l != Long.MAX_VALUE) {
                l2 = l + 1L;
            }
            long l3 = this.indexOf((byte)10, 0L, l2);
            if (l3 != -1L) {
                return this.readUtf8Line(l3);
            }
            if (l2 < this.size() && this.getByte(l2 - 1L) == 13 && this.getByte(l2) == 10) {
                return this.readUtf8Line(l2);
            }
            Buffer buffer = new Buffer();
            this.copyTo(buffer, 0L, Math.min(32L, this.size()));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\\n not found: limit=");
            stringBuilder.append(Math.min(this.size(), l));
            stringBuilder.append(" content=");
            stringBuilder.append(buffer.readByteString().hex());
            stringBuilder.append('\u2026');
            throw new EOFException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("limit < 0: ");
        stringBuilder.append(l);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public boolean request(long l) {
        boolean bl = this.size >= l;
        return bl;
    }

    @Override
    public void require(long l) throws EOFException {
        if (this.size >= l) {
            return;
        }
        throw new EOFException();
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.head.limit - this.head.pos);
        Segment segment = this.head;
        while ((segment = segment.next) != this.head) {
            arrayList.add(segment.limit - segment.pos);
        }
        return arrayList;
    }

    @Override
    public int select(Options options) {
        int n = this.selectPrefix(options, false);
        if (n == -1) {
            return -1;
        }
        long l = options.byteStrings[n].size();
        try {
            this.skip(l);
            return n;
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
    }

    /*
     * Unable to fully structure code
     */
    int selectPrefix(Options var1_1, boolean var2_2) {
        var3_3 = this.head;
        if (var3_3 == null) {
            if (var2_2) {
                return -2;
            }
            return var1_1.indexOf(ByteString.EMPTY);
        }
        var4_4 = var3_3.data;
        var5_5 = var3_3.pos;
        var6_6 = var3_3.limit;
        var7_7 = var1_1.trie;
        var1_1 = var3_3;
        var8_8 = 0;
        var9_9 = -1;
        block0: while (true) {
            block22: {
                var10_10 = var8_8 + 1;
                var11_11 = var7_7[var8_8];
                var12_12 = var10_10 + 1;
                var8_8 = var7_7[var10_10];
                if (var8_8 != -1) {
                    var9_9 = var8_8;
                }
                if (var1_1 == null) ** GOTO lbl37
                if (var11_11 >= 0) break block22;
                var8_8 = var12_12;
                while (true) {
                    block26: {
                        block24: {
                            block23: {
                                block25: {
                                    var13_13 = var5_5 + 1;
                                    var5_5 = var4_4[var5_5];
                                    var10_10 = var8_8 + 1;
                                    if ((var5_5 & 255) != var7_7[var8_8]) {
                                        return var9_9;
                                    }
                                    var8_8 = var10_10 == var12_12 + var11_11 * -1 ? 1 : 0;
                                    if (var13_13 != var6_6) break block23;
                                    var1_1 = var1_1.next;
                                    var5_5 = var1_1.pos;
                                    var4_4 = var1_1.data;
                                    var6_6 = var1_1.limit;
                                    if (var1_1 != var3_3) break block24;
                                    if (var8_8 != 0) break block25;
lbl37:
                                    // 2 sources

                                    if (var2_2) {
                                        return -2;
                                    }
                                    return var9_9;
                                }
                                var1_1 = null;
                                break block24;
                            }
                            var5_5 = var13_13;
                        }
                        if (var8_8 == 0) break block26;
                        var12_12 = var7_7[var10_10];
                        var8_8 = var6_6;
                        var6_6 = var5_5;
                        var5_5 = var12_12;
                        ** GOTO lbl85
                    }
                    var8_8 = var10_10;
                }
            }
            var8_8 = var5_5 + 1;
            var10_10 = var4_4[var5_5];
            var5_5 = var12_12;
            while (true) {
                block27: {
                    if (var5_5 == var12_12 + var11_11) {
                        return var9_9;
                    }
                    if ((var10_10 & 255) != var7_7[var5_5]) break block27;
                    var10_10 = var7_7[var5_5 + var11_11];
                    if (var8_8 == var6_6) {
                        var14_14 = var1_1.next;
                        var13_13 = var14_14.pos;
                        var15_15 = var14_14.data;
                        var12_12 = var14_14.limit;
                        var6_6 = var13_13;
                        var4_4 = var15_15;
                        var5_5 = var10_10;
                        var8_8 = var12_12;
                        var1_1 = var14_14;
                        if (var14_14 == var3_3) {
                            var1_1 = null;
                            var6_6 = var13_13;
                            var4_4 = var15_15;
                            var5_5 = var10_10;
                            var8_8 = var12_12;
                        }
                    } else {
                        var12_12 = var8_8;
                        var8_8 = var6_6;
                        var5_5 = var10_10;
                        var6_6 = var12_12;
                    }
lbl85:
                    // 3 sources

                    if (var5_5 >= 0) {
                        return var5_5;
                    }
                    var12_12 = -var5_5;
                    var5_5 = var6_6;
                    var6_6 = var8_8;
                    var8_8 = var12_12;
                    continue block0;
                }
                ++var5_5;
            }
            break;
        }
    }

    public final ByteString sha1() {
        return this.digest("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest("SHA-256");
    }

    public final ByteString sha512() {
        return this.digest("SHA-512");
    }

    public final long size() {
        return this.size;
    }

    @Override
    public void skip(long l) throws EOFException {
        while (l > 0L) {
            Segment segment = this.head;
            if (segment != null) {
                int n = (int)Math.min(l, (long)(segment.limit - this.head.pos));
                long l2 = this.size;
                long l3 = n;
                this.size = l2 - l3;
                l2 = l - l3;
                segment = this.head;
                segment.pos += n;
                l = l2;
                if (this.head.pos != this.head.limit) continue;
                segment = this.head;
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                l = l2;
                continue;
            }
            throw new EOFException();
        }
    }

    public final ByteString snapshot() {
        long l = this.size;
        if (l <= Integer.MAX_VALUE) {
            return this.snapshot((int)l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size > Integer.MAX_VALUE: ");
        stringBuilder.append(this.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public final ByteString snapshot(int n) {
        if (n == 0) {
            return ByteString.EMPTY;
        }
        return new SegmentedByteString(this, n);
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    Segment writableSegment(int n) {
        block4: {
            Segment segment;
            block6: {
                Segment segment2;
                block5: {
                    if (n < 1 || n > 8192) break block4;
                    segment = this.head;
                    if (segment == null) {
                        this.head = segment = SegmentPool.take();
                        segment.prev = segment;
                        segment.next = segment;
                        return segment;
                    }
                    segment2 = segment.prev;
                    if (segment2.limit + n > 8192) break block5;
                    segment = segment2;
                    if (segment2.owner) break block6;
                }
                segment = segment2.push(SegmentPool.take());
            }
            return segment;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            int n;
            int n2 = n = byteBuffer.remaining();
            while (n2 > 0) {
                Segment segment = this.writableSegment(1);
                int n3 = Math.min(n2, 8192 - segment.limit);
                byteBuffer.get(segment.data, segment.limit, n3);
                n2 -= n3;
                segment.limit += n3;
            }
            this.size += (long)n;
            return n;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public Buffer write(ByteString byteString) {
        if (byteString != null) {
            byteString.write(this);
            return this;
        }
        throw new IllegalArgumentException("byteString == null");
    }

    @Override
    public Buffer write(byte[] byArray) {
        if (byArray != null) {
            return this.write(byArray, 0, byArray.length);
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public Buffer write(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            long l = byArray.length;
            long l2 = n;
            long l3 = n2;
            Util.checkOffsetAndCount(l, l2, l3);
            n2 += n;
            while (n < n2) {
                Segment segment = this.writableSegment(1);
                int n3 = Math.min(n2 - n, 8192 - segment.limit);
                System.arraycopy(byArray, n, segment.data, segment.limit, n3);
                n += n3;
                segment.limit += n3;
            }
            this.size += l3;
            return this;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public BufferedSink write(Source source, long l) throws IOException {
        while (l > 0L) {
            long l2 = source.read(this, l);
            if (l2 != -1L) {
                l -= l2;
                continue;
            }
            throw new EOFException();
        }
        return this;
    }

    @Override
    public void write(Buffer buffer, long l) {
        if (buffer != null) {
            if (buffer != this) {
                Util.checkOffsetAndCount(buffer.size, 0L, l);
                while (l > 0L) {
                    long l2;
                    Segment segment;
                    if (l < (long)(buffer.head.limit - buffer.head.pos)) {
                        int n;
                        segment = this.head;
                        segment = segment != null ? segment.prev : null;
                        if (segment != null && segment.owner && (l2 = (long)segment.limit) + l - (long)(n = segment.shared ? 0 : segment.pos) <= 8192L) {
                            buffer.head.writeTo(segment, (int)l);
                            buffer.size -= l;
                            this.size += l;
                            return;
                        }
                        buffer.head = buffer.head.split((int)l);
                    }
                    segment = buffer.head;
                    l2 = segment.limit - segment.pos;
                    buffer.head = segment.pop();
                    Segment segment2 = this.head;
                    if (segment2 == null) {
                        this.head = segment;
                        segment.prev = segment;
                        segment.next = segment;
                    } else {
                        segment2.prev.push(segment).compact();
                    }
                    buffer.size -= l2;
                    this.size += l2;
                    l -= l2;
                }
                return;
            }
            throw new IllegalArgumentException("source == this");
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public long writeAll(Source source) throws IOException {
        if (source != null) {
            long l;
            long l2 = 0L;
            while ((l = source.read(this, 8192L)) != -1L) {
                l2 += l;
            }
            return l2;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public Buffer writeByte(int n) {
        Segment segment = this.writableSegment(1);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        segment.limit = n2 + 1;
        byArray[n2] = (byte)n;
        ++this.size;
        return this;
    }

    @Override
    public Buffer writeDecimalLong(long l) {
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 == false) {
            return this.writeByte(48);
        }
        boolean bl = false;
        int n = 1;
        long l4 = l;
        if (l3 < 0) {
            l4 = -l;
            if (l4 < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            bl = true;
        }
        if (l4 < 100000000L) {
            if (l4 < 10000L) {
                if (l4 < 100L) {
                    if (l4 >= 10L) {
                        n = 2;
                    }
                } else {
                    n = l4 < 1000L ? 3 : 4;
                }
            } else {
                n = l4 < 1000000L ? (l4 < 100000L ? 5 : 6) : (l4 < 10000000L ? 7 : 8);
            }
        } else {
            n = l4 < 1000000000000L ? (l4 < 10000000000L ? (l4 < 1000000000L ? 9 : 10) : (l4 < 100000000000L ? 11 : 12)) : (l4 < 1000000000000000L ? (l4 < 10000000000000L ? 13 : (l4 < 100000000000000L ? 14 : 15)) : (l4 < 100000000000000000L ? (l4 < 10000000000000000L ? 16 : 17) : (l4 < 1000000000000000000L ? 18 : 19)));
        }
        l3 = n;
        if (bl) {
            l3 = n + 1;
        }
        Segment segment = this.writableSegment((int)l3);
        byte[] byArray = segment.data;
        n = segment.limit + l3;
        while (l4 != 0L) {
            int n2 = (int)(l4 % 10L);
            byArray[--n] = DIGITS[n2];
            l4 /= 10L;
        }
        if (bl) {
            byArray[n - 1] = (byte)45;
        }
        segment.limit += l3;
        this.size += (long)l3;
        return this;
    }

    @Override
    public Buffer writeHexadecimalUnsignedLong(long l) {
        if (l == 0L) {
            return this.writeByte(48);
        }
        int n = Long.numberOfTrailingZeros(Long.highestOneBit(l)) / 4 + 1;
        Segment segment = this.writableSegment(n);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        for (int i = segment.limit + n - 1; i >= n2; --i) {
            byArray[i] = DIGITS[(int)(0xFL & l)];
            l >>>= 4;
        }
        segment.limit += n;
        this.size += (long)n;
        return this;
    }

    @Override
    public Buffer writeInt(int n) {
        Segment segment = this.writableSegment(4);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        int n3 = n2 + 1;
        byArray[n2] = (byte)(n >>> 24 & 0xFF);
        n2 = n3 + 1;
        byArray[n3] = (byte)(n >>> 16 & 0xFF);
        n3 = n2 + 1;
        byArray[n2] = (byte)(n >>> 8 & 0xFF);
        byArray[n3] = (byte)(n & 0xFF);
        segment.limit = n3 + 1;
        this.size += 4L;
        return this;
    }

    @Override
    public Buffer writeIntLe(int n) {
        return this.writeInt(Util.reverseBytesInt(n));
    }

    @Override
    public Buffer writeLong(long l) {
        Segment segment = this.writableSegment(8);
        byte[] byArray = segment.data;
        int n = segment.limit;
        int n2 = n + 1;
        byArray[n] = (byte)(l >>> 56 & 0xFFL);
        n = n2 + 1;
        byArray[n2] = (byte)(l >>> 48 & 0xFFL);
        n2 = n + 1;
        byArray[n] = (byte)(l >>> 40 & 0xFFL);
        n = n2 + 1;
        byArray[n2] = (byte)(l >>> 32 & 0xFFL);
        n2 = n + 1;
        byArray[n] = (byte)(l >>> 24 & 0xFFL);
        n = n2 + 1;
        byArray[n2] = (byte)(l >>> 16 & 0xFFL);
        n2 = n + 1;
        byArray[n] = (byte)(l >>> 8 & 0xFFL);
        byArray[n2] = (byte)(l & 0xFFL);
        segment.limit = n2 + 1;
        this.size += 8L;
        return this;
    }

    @Override
    public Buffer writeLongLe(long l) {
        return this.writeLong(Util.reverseBytesLong(l));
    }

    @Override
    public Buffer writeShort(int n) {
        Segment segment = this.writableSegment(2);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        int n3 = n2 + 1;
        byArray[n2] = (byte)(n >>> 8 & 0xFF);
        byArray[n3] = (byte)(n & 0xFF);
        segment.limit = n3 + 1;
        this.size += 2L;
        return this;
    }

    @Override
    public Buffer writeShortLe(int n) {
        return this.writeShort(Util.reverseBytesShort((short)n));
    }

    @Override
    public Buffer writeString(String object, int n, int n2, Charset comparable) {
        if (object != null) {
            if (n >= 0) {
                if (n2 >= n) {
                    if (n2 <= ((String)object).length()) {
                        if (comparable != null) {
                            if (((Charset)comparable).equals(Util.UTF_8)) {
                                return this.writeUtf8((String)object, n, n2);
                            }
                            object = ((String)object).substring(n, n2).getBytes((Charset)comparable);
                            return this.write((byte[])object, 0, ((Object)object).length);
                        }
                        throw new IllegalArgumentException("charset == null");
                    }
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("endIndex > string.length: ");
                    ((StringBuilder)comparable).append(n2);
                    ((StringBuilder)comparable).append(" > ");
                    ((StringBuilder)comparable).append(((String)object).length());
                    throw new IllegalArgumentException(((StringBuilder)comparable).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("endIndex < beginIndex: ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append(" < ");
                ((StringBuilder)object).append(n);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("beginIndex < 0: ");
            ((StringBuilder)object).append(n);
            throw new IllegalAccessError(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("string == null");
    }

    @Override
    public Buffer writeString(String string2, Charset charset) {
        return this.writeString(string2, 0, string2.length(), charset);
    }

    public final Buffer writeTo(OutputStream outputStream) throws IOException {
        return this.writeTo(outputStream, this.size);
    }

    public final Buffer writeTo(OutputStream outputStream, long l) throws IOException {
        if (outputStream != null) {
            Util.checkOffsetAndCount(this.size, 0L, l);
            Segment segment = this.head;
            while (l > 0L) {
                Segment segment2;
                int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
                outputStream.write(segment.data, segment.pos, n);
                segment.pos += n;
                long l2 = this.size;
                long l3 = n;
                this.size = l2 - l3;
                l = l2 = l - l3;
                if (segment.pos != segment.limit) continue;
                this.head = segment2 = segment.pop();
                SegmentPool.recycle(segment);
                segment = segment2;
                l = l2;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    @Override
    public Buffer writeUtf8(String string2) {
        return this.writeUtf8(string2, 0, string2.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Buffer writeUtf8(String charSequence, int n, int n2) {
        if (charSequence == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("beginIndex < 0: ");
            ((StringBuilder)charSequence).append(n);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        if (n2 < n) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("endIndex < beginIndex: ");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append(" < ");
            ((StringBuilder)charSequence).append(n);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        if (n2 > ((String)charSequence).length()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("endIndex > string.length: ");
            stringBuilder.append(n2);
            stringBuilder.append(" > ");
            stringBuilder.append(((String)charSequence).length());
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        while (n < n2) {
            int n3;
            int n4;
            int n5;
            Segment segment;
            char c = ((String)charSequence).charAt(n);
            if (c < '\u0080') {
                segment = this.writableSegment(1);
                byte[] byArray = segment.data;
                n5 = segment.limit - n;
                n4 = Math.min(n2, 8192 - n5);
                n3 = n + 1;
                byArray[n + n5] = (byte)c;
            } else {
                if (c < '\u0800') {
                    this.writeByte(c >> 6 | 0xC0);
                    this.writeByte(c & 0x3F | 0x80);
                } else {
                    if (c >= '\ud800' && c <= '\udfff') {
                        n4 = n + 1;
                        n3 = n4 < n2 ? ((String)charSequence).charAt(n4) : 0;
                        if (c <= '\udbff' && n3 >= 56320 && n3 <= 57343) {
                            n3 = ((c & 0xFFFF27FF) << 10 | 0xFFFF23FF & n3) + 65536;
                            this.writeByte(n3 >> 18 | 0xF0);
                            this.writeByte(n3 >> 12 & 0x3F | 0x80);
                            this.writeByte(n3 >> 6 & 0x3F | 0x80);
                            this.writeByte(n3 & 0x3F | 0x80);
                            n += 2;
                            continue;
                        }
                        this.writeByte(63);
                        n = n4;
                        continue;
                    }
                    this.writeByte(c >> 12 | 0xE0);
                    this.writeByte(c >> 6 & 0x3F | 0x80);
                    this.writeByte(c & 0x3F | 0x80);
                }
                ++n;
                continue;
            }
            for (n = n3; n < n4 && (n3 = (int)((String)charSequence).charAt(n)) < 128; ++n) {
                byArray[n + n5] = (byte)n3;
            }
            n3 = n5 + n - segment.limit;
            segment.limit += n3;
            this.size += (long)n3;
        }
        return this;
    }

    @Override
    public Buffer writeUtf8CodePoint(int n) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (n >= 128) break block5;
                            this.writeByte(n);
                            break block6;
                        }
                        if (n >= 2048) break block7;
                        this.writeByte(n >> 6 | 0xC0);
                        this.writeByte(n & 0x3F | 0x80);
                        break block6;
                    }
                    if (n >= 65536) break block8;
                    if (n >= 55296 && n <= 57343) {
                        this.writeByte(63);
                    } else {
                        this.writeByte(n >> 12 | 0xE0);
                        this.writeByte(n >> 6 & 0x3F | 0x80);
                        this.writeByte(n & 0x3F | 0x80);
                    }
                    break block6;
                }
                if (n > 0x10FFFF) break block9;
                this.writeByte(n >> 18 | 0xF0);
                this.writeByte(n >> 12 & 0x3F | 0x80);
                this.writeByte(n >> 6 & 0x3F | 0x80);
                this.writeByte(n & 0x3F | 0x80);
            }
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unexpected code point: ");
        stringBuilder.append(Integer.toHexString(n));
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static final class UnsafeCursor
    implements Closeable {
        public Buffer buffer;
        public byte[] data;
        public int end = -1;
        public long offset = -1L;
        public boolean readWrite;
        private Segment segment;
        public int start = -1;

        @Override
        public void close() {
            if (this.buffer != null) {
                this.buffer = null;
                this.segment = null;
                this.offset = -1L;
                this.data = null;
                this.start = -1;
                this.end = -1;
                return;
            }
            throw new IllegalStateException("not attached to a buffer");
        }

        public final long expandBuffer(int n) {
            if (n > 0) {
                if (n <= 8192) {
                    Buffer buffer = this.buffer;
                    if (buffer != null) {
                        if (this.readWrite) {
                            long l = buffer.size;
                            Segment segment = this.buffer.writableSegment(n);
                            n = 8192 - segment.limit;
                            segment.limit = 8192;
                            buffer = this.buffer;
                            long l2 = n;
                            buffer.size = l + l2;
                            this.segment = segment;
                            this.offset = l;
                            this.data = segment.data;
                            this.start = 8192 - n;
                            this.end = 8192;
                            return l2;
                        }
                        throw new IllegalStateException("expandBuffer() only permitted for read/write buffers");
                    }
                    throw new IllegalStateException("not attached to a buffer");
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("minByteCount > Segment.SIZE: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("minByteCount <= 0: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public final int next() {
            if (this.offset != this.buffer.size) {
                long l = this.offset;
                if (l == -1L) {
                    return this.seek(0L);
                }
                return this.seek(l + (long)(this.end - this.start));
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled aggressive block sorting
         */
        public final long resizeBuffer(long l) {
            Object object = this.buffer;
            if (object == null) {
                throw new IllegalStateException("not attached to a buffer");
            }
            if (!this.readWrite) {
                throw new IllegalStateException("resizeBuffer() only permitted for read/write buffers");
            }
            long l2 = ((Buffer)object).size;
            long l3 = l - l2;
            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
            if (l4 <= 0) {
                long l5;
                if (l < 0L) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("newSize < 0: ");
                    ((StringBuilder)object).append(l);
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                for (long i = l2 - l; i > 0L; i -= l5) {
                    object = this.buffer.head.prev;
                    l5 = ((Segment)object).limit - ((Segment)object).pos;
                    if (l5 <= i) {
                        this.buffer.head = ((Segment)object).pop();
                        SegmentPool.recycle((Segment)object);
                        continue;
                    }
                    ((Segment)object).limit = (int)((long)((Segment)object).limit - i);
                    break;
                }
                this.segment = null;
                this.offset = l;
                this.data = null;
                this.start = -1;
                this.end = -1;
            } else if (l4 > 0) {
                long l6 = l - l2;
                l4 = 1;
                while (l6 > 0L) {
                    long l7;
                    object = this.buffer.writableSegment(1);
                    int n = (int)Math.min(l6, (long)(8192 - ((Segment)object).limit));
                    ((Segment)object).limit += n;
                    l6 = l7 = l6 - (long)n;
                    if (l4 == false) continue;
                    this.segment = object;
                    this.offset = l2;
                    this.data = ((Segment)object).data;
                    this.start = ((Segment)object).limit - n;
                    this.end = ((Segment)object).limit;
                    l4 = 0;
                    l6 = l7;
                }
            }
            this.buffer.size = l;
            return l2;
        }

        public final int seek(long l) {
            long l2 = l - -1L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            if (l3 >= 0 && l <= this.buffer.size) {
                if (l3 != false && l != this.buffer.size) {
                    long l4 = 0L;
                    long l5 = this.buffer.size;
                    Segment segment = this.buffer.head;
                    Segment segment2 = this.buffer.head;
                    Segment segment3 = this.segment;
                    long l6 = l4;
                    long l7 = l5;
                    Segment segment4 = segment;
                    Segment segment5 = segment2;
                    if (segment3 != null) {
                        l6 = this.offset - (long)(this.start - segment3.pos);
                        if (l6 > l) {
                            segment5 = this.segment;
                            l7 = l6;
                            l6 = l4;
                            segment4 = segment;
                        } else {
                            segment4 = this.segment;
                            segment5 = segment2;
                            l7 = l5;
                        }
                    }
                    if (l7 - l > l - l6) {
                        segment5 = segment4;
                        while (true) {
                            l7 = l6;
                            segment4 = segment5;
                            if (l >= (long)(segment5.limit - segment5.pos) + l6) {
                                l6 += (long)(segment5.limit - segment5.pos);
                                segment5 = segment5.next;
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (l4 = l7; l4 > l; l4 -= (long)(segment5.limit - segment5.pos)) {
                            segment5 = segment5.prev;
                        }
                        l7 = l4;
                        segment4 = segment5;
                    }
                    segment5 = segment4;
                    if (this.readWrite) {
                        segment5 = segment4;
                        if (segment4.shared) {
                            segment5 = segment4.unsharedCopy();
                            if (this.buffer.head == segment4) {
                                this.buffer.head = segment5;
                            }
                            segment5 = segment4.push(segment5);
                            segment5.prev.pop();
                        }
                    }
                    this.segment = segment5;
                    this.offset = l;
                    this.data = segment5.data;
                    this.start = segment5.pos + (int)(l - l7);
                    l3 = segment5.limit;
                    this.end = (int)l3;
                    return (int)(l3 - this.start);
                }
                this.segment = null;
                this.offset = l;
                this.data = null;
                this.start = -1;
                this.end = -1;
                return -1;
            }
            throw new ArrayIndexOutOfBoundsException(String.format("offset=%s > size=%s", l, this.buffer.size));
        }
    }
}

