/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Base64;
import okio.Buffer;
import okio.Util;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    public static final ByteString EMPTY;
    static final char[] HEX_DIGITS;
    private static final long serialVersionUID = 1L;
    final byte[] data;
    transient int hashCode;
    transient String utf8;

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        EMPTY = ByteString.of(new byte[0]);
    }

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    static int codePointIndexToCharIndex(String string2, int n) {
        int n2;
        int n3 = string2.length();
        int n4 = 0;
        for (int i = 0; i < n3; i += Character.charCount(n2)) {
            if (n4 == n) {
                return i;
            }
            n2 = string2.codePointAt(i);
            if (Character.isISOControl(n2) && n2 != 10 && n2 != 13 || n2 == 65533) {
                return -1;
            }
            ++n4;
        }
        return string2.length();
    }

    @Nullable
    public static ByteString decodeBase64(String object) {
        if (object != null) {
            object = (object = (Object)Base64.decode((String)object)) != null ? new ByteString((byte[])object) : null;
            return object;
        }
        throw new IllegalArgumentException("base64 == null");
    }

    public static ByteString decodeHex(String string2) {
        if (string2 != null) {
            if (string2.length() % 2 == 0) {
                int n = string2.length() / 2;
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = i * 2;
                    byArray[i] = (byte)((ByteString.decodeHexDigit(string2.charAt(n2)) << 4) + ByteString.decodeHexDigit(string2.charAt(n2 + 1)));
                }
                return ByteString.of(byArray);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected hex string: ");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        throw new IllegalArgumentException("hex == null");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        int n = 97;
        if (c >= 'a' && c <= 'f') {
            return c - n + 10;
        }
        n = 65;
        if (c >= 'A' && c <= 'F') {
            return c - n + 10;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unexpected hex digit: ");
        stringBuilder.append(c);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private ByteString digest(String object) {
        try {
            object = ByteString.of(MessageDigest.getInstance((String)object).digest(this.data));
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public static ByteString encodeString(String string2, Charset charset) {
        if (string2 != null) {
            if (charset != null) {
                return new ByteString(string2.getBytes(charset));
            }
            throw new IllegalArgumentException("charset == null");
        }
        throw new IllegalArgumentException("s == null");
    }

    public static ByteString encodeUtf8(String string2) {
        if (string2 != null) {
            ByteString byteString = new ByteString(string2.getBytes(Util.UTF_8));
            byteString.utf8 = string2;
            return byteString;
        }
        throw new IllegalArgumentException("s == null");
    }

    private ByteString hmac(String object, ByteString byteString) {
        try {
            Mac mac = Mac.getInstance((String)object);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byteString.toByteArray(), (String)object);
            mac.init(secretKeySpec);
            object = ByteString.of(mac.doFinal(this.data));
            return object;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public static ByteString of(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return new ByteString(byArray);
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString of(byte ... byArray) {
        if (byArray != null) {
            return new ByteString((byte[])byArray.clone());
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString of(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            Util.checkOffsetAndCount(byArray.length, n, n2);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return new ByteString(byArray2);
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString read(InputStream object, int n) throws IOException {
        if (object != null) {
            if (n >= 0) {
                int n2;
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; i += n2) {
                    n2 = ((InputStream)object).read(byArray, i, n - i);
                    if (n2 != -1) {
                        continue;
                    }
                    throw new EOFException();
                }
                return new ByteString(byArray);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(n);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("in == null");
    }

    private void readObject(ObjectInputStream object) throws IOException {
        object = ByteString.read((InputStream)object, ((ObjectInputStream)object).readInt());
        try {
            Field field = ByteString.class.getDeclaredField("data");
            field.setAccessible(true);
            field.set(this, ((ByteString)object).data);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n;
        int n2;
        int n3;
        block4: {
            int n4;
            int n5;
            n3 = this.size();
            n2 = byteString.size();
            int n6 = Math.min(n3, n2);
            int n7 = 0;
            while (true) {
                n = -1;
                if (n7 >= n6) break block4;
                n5 = this.getByte(n7) & 0xFF;
                if (n5 != (n4 = byteString.getByte(n7) & 0xFF)) break;
                ++n7;
            }
            if (n5 >= n4) {
                n = 1;
            }
            return n;
        }
        if (n3 == n2) {
            return 0;
        }
        if (n3 >= n2) {
            n = 1;
        }
        return n;
    }

    public final boolean endsWith(ByteString byteString) {
        return this.rangeEquals(this.size() - byteString.size(), byteString, 0, byteString.size());
    }

    public final boolean endsWith(byte[] byArray) {
        return this.rangeEquals(this.size() - byArray.length, byArray, 0, byArray.length);
    }

    public boolean equals(Object object) {
        byte[] byArray;
        int n;
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString) || (n = ((ByteString)(object = (ByteString)object)).size()) != (byArray = this.data).length || !((ByteString)object).rangeEquals(0, byArray, 0, byArray.length)) {
            bl = false;
        }
        return bl;
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            this.hashCode = n = Arrays.hashCode(this.data);
        }
        return n;
    }

    public String hex() {
        byte[] byArray = this.data;
        char[] cArray = new char[byArray.length * 2];
        int n = byArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            int n3 = n2 + 1;
            char[] cArray2 = HEX_DIGITS;
            cArray[n2] = cArray2[by >> 4 & 0xF];
            n2 = n3 + 1;
            cArray[n3] = cArray2[by & 0xF];
        }
        return new String(cArray);
    }

    public ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    public final int indexOf(ByteString byteString) {
        return this.indexOf(byteString.internalArray(), 0);
    }

    public final int indexOf(ByteString byteString, int n) {
        return this.indexOf(byteString.internalArray(), n);
    }

    public final int indexOf(byte[] byArray) {
        return this.indexOf(byArray, 0);
    }

    public int indexOf(byte[] byArray, int n) {
        int n2 = this.data.length;
        int n3 = byArray.length;
        for (n = Math.max(n, 0); n <= n2 - n3; ++n) {
            if (!Util.arrayRangeEquals(this.data, n, byArray, 0, byArray.length)) continue;
            return n;
        }
        return -1;
    }

    byte[] internalArray() {
        return this.data;
    }

    public final int lastIndexOf(ByteString byteString) {
        return this.lastIndexOf(byteString.internalArray(), this.size());
    }

    public final int lastIndexOf(ByteString byteString, int n) {
        return this.lastIndexOf(byteString.internalArray(), n);
    }

    public final int lastIndexOf(byte[] byArray) {
        return this.lastIndexOf(byArray, this.size());
    }

    public int lastIndexOf(byte[] byArray, int n) {
        for (n = Math.min(n, this.data.length - byArray.length); n >= 0; --n) {
            if (!Util.arrayRangeEquals(this.data, n, byArray, 0, byArray.length)) continue;
            return n;
        }
        return -1;
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public boolean rangeEquals(int n, ByteString byteString, int n2, int n3) {
        return byteString.rangeEquals(n2, this.data, n, n3);
    }

    public boolean rangeEquals(int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        boolean bl = n >= 0 && n <= (byArray2 = this.data).length - n3 && n2 >= 0 && n2 <= byArray.length - n3 && Util.arrayRangeEquals(byArray2, n, byArray, n2, n3);
        return bl;
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    public int size() {
        return this.data.length;
    }

    public final boolean startsWith(ByteString byteString) {
        return this.rangeEquals(0, byteString, 0, byteString.size());
    }

    public final boolean startsWith(byte[] byArray) {
        return this.rangeEquals(0, byArray, 0, byArray.length);
    }

    public String string(Charset charset) {
        if (charset != null) {
            return new String(this.data, charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    public ByteString substring(int n) {
        return this.substring(n, this.data.length);
    }

    public ByteString substring(int n, int n2) {
        if (n >= 0) {
            Object object = this.data;
            if (n2 <= ((byte[])object).length) {
                int n3 = n2 - n;
                if (n3 >= 0) {
                    if (n == 0 && n2 == ((Object)object).length) {
                        return this;
                    }
                    byte[] byArray = new byte[n3];
                    System.arraycopy(object, n, byArray, 0, n3);
                    return new ByteString(byArray);
                }
                throw new IllegalArgumentException("endIndex < beginIndex");
            }
            object = new StringBuilder();
            object.append("endIndex > length(");
            object.append(this.data.length);
            object.append(")");
            throw new IllegalArgumentException(object.toString());
        }
        throw new IllegalArgumentException("beginIndex < 0");
    }

    public ByteString toAsciiLowercase() {
        byte[] byArray;
        for (int i = 0; i < (byArray = this.data).length; ++i) {
            byte by = byArray[i];
            if (by < 65 || by > 90) continue;
            byArray = (byte[])byArray.clone();
            int n = i + 1;
            byArray[i] = (byte)(by + 32);
            for (i = n; i < byArray.length; ++i) {
                n = byArray[i];
                if (n < 65 || n > 90) continue;
                byArray[i] = (byte)(n + 32);
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        byte[] byArray;
        for (int i = 0; i < (byArray = this.data).length; ++i) {
            byte by = byArray[i];
            if (by < 97 || by > 122) continue;
            byArray = (byte[])byArray.clone();
            int n = i + 1;
            byArray[i] = (byte)(by - 32);
            for (i = n; i < byArray.length; ++i) {
                n = byArray[i];
                if (n < 97 || n > 122) continue;
                byArray[i] = (byte)(n - 32);
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[size=0]";
        }
        CharSequence charSequence = this.utf8();
        int n = ByteString.codePointIndexToCharIndex((String)charSequence, 64);
        if (n == -1) {
            CharSequence charSequence2;
            if (this.data.length <= 64) {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append("[hex=");
                ((StringBuilder)charSequence2).append(this.hex());
                ((StringBuilder)charSequence2).append("]");
                charSequence2 = ((StringBuilder)charSequence2).toString();
            } else {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append("[size=");
                ((StringBuilder)charSequence2).append(this.data.length);
                ((StringBuilder)charSequence2).append(" hex=");
                ((StringBuilder)charSequence2).append(this.substring(0, 64).hex());
                ((StringBuilder)charSequence2).append("\u2026]");
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
            return charSequence2;
        }
        String string2 = ((String)charSequence).substring(0, n).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        if (n < ((String)charSequence).length()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("[size=");
            ((StringBuilder)charSequence).append(this.data.length);
            ((StringBuilder)charSequence).append(" text=");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append("\u2026]");
            string2 = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("[text=");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append("]");
            string2 = ((StringBuilder)charSequence).toString();
        }
        return string2;
    }

    public String utf8() {
        String string2 = this.utf8;
        if (string2 == null) {
            this.utf8 = string2 = new String(this.data, Util.UTF_8);
        }
        return string2;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            outputStream.write(this.data);
            return;
        }
        throw new IllegalArgumentException("out == null");
    }

    void write(Buffer buffer) {
        byte[] byArray = this.data;
        buffer.write(byArray, 0, byArray.length);
    }
}

