/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import okio.Buffer;
import okio.BufferedSource;
import okio.InflaterSource;
import okio.Okio;
import okio.Segment;
import okio.Source;
import okio.Timeout;

public final class GzipSource
implements Source {
    private static final byte FCOMMENT = 4;
    private static final byte FEXTRA = 2;
    private static final byte FHCRC = 1;
    private static final byte FNAME = 3;
    private static final byte SECTION_BODY = 1;
    private static final byte SECTION_DONE = 3;
    private static final byte SECTION_HEADER = 0;
    private static final byte SECTION_TRAILER = 2;
    private final CRC32 crc = new CRC32();
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private int section = 0;
    private final BufferedSource source;

    public GzipSource(Source source) {
        if (source != null) {
            Inflater inflater;
            this.inflater = inflater = new Inflater(true);
            source = Okio.buffer(source);
            this.source = source;
            this.inflaterSource = new InflaterSource((BufferedSource)source, inflater);
            return;
        }
        throw new IllegalArgumentException("source == null");
    }

    private void checkEqual(String string2, int n, int n2) throws IOException {
        if (n2 == n) {
            return;
        }
        throw new IOException(String.format("%s: actual 0x%08x != expected 0x%08x", string2, n2, n));
    }

    private void consumeHeader() throws IOException {
        long l;
        this.source.require(10L);
        byte by = this.source.buffer().getByte(3L);
        boolean bl = (by >> 1 & 1) == 1;
        if (bl) {
            this.updateCrc(this.source.buffer(), 0L, 10L);
        }
        this.checkEqual("ID1ID2", 8075, this.source.readShort());
        this.source.skip(8L);
        if ((by >> 2 & 1) == 1) {
            this.source.require(2L);
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, 2L);
            }
            short s = this.source.buffer().readShortLe();
            BufferedSource bufferedSource = this.source;
            l = s;
            bufferedSource.require(l);
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, l);
            }
            this.source.skip(l);
        }
        if ((by >> 3 & 1) == 1) {
            l = this.source.indexOf((byte)0);
            if (l != -1L) {
                if (bl) {
                    this.updateCrc(this.source.buffer(), 0L, l + 1L);
                }
                this.source.skip(l + 1L);
            } else {
                throw new EOFException();
            }
        }
        if ((by >> 4 & 1) == 1) {
            l = this.source.indexOf((byte)0);
            if (l != -1L) {
                if (bl) {
                    this.updateCrc(this.source.buffer(), 0L, l + 1L);
                }
                this.source.skip(l + 1L);
            } else {
                throw new EOFException();
            }
        }
        if (bl) {
            this.checkEqual("FHCRC", this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private void consumeTrailer() throws IOException {
        this.checkEqual("CRC", this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual("ISIZE", this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    private void updateCrc(Buffer object, long l, long l2) {
        object = ((Buffer)object).head;
        while (l >= (long)(((Segment)object).limit - ((Segment)object).pos)) {
            l -= (long)(((Segment)object).limit - ((Segment)object).pos);
            object = ((Segment)object).next;
        }
        while (l2 > 0L) {
            int n = (int)((long)((Segment)object).pos + l);
            int n2 = (int)Math.min((long)(((Segment)object).limit - n), l2);
            this.crc.update(((Segment)object).data, n, n2);
            l2 -= (long)n2;
            object = ((Segment)object).next;
            l = 0L;
        }
    }

    @Override
    public void close() throws IOException {
        this.inflaterSource.close();
    }

    @Override
    public long read(Buffer object, long l) throws IOException {
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 >= 0) {
            if (l3 == false) {
                return 0L;
            }
            if (this.section == 0) {
                this.consumeHeader();
                this.section = 1;
            }
            if (this.section == 1) {
                long l4 = ((Buffer)object).size;
                if ((l = this.inflaterSource.read((Buffer)object, l)) != -1L) {
                    this.updateCrc((Buffer)object, l4, l);
                    return l;
                }
                this.section = 2;
            }
            if (this.section == 2) {
                this.consumeTrailer();
                this.section = 3;
                if (!this.source.exhausted()) {
                    throw new IOException("gzip finished without exhausting source");
                }
            }
            return -1L;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("byteCount < 0: ");
        ((StringBuilder)object).append(l);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }
}

