/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.Segment;
import okio.Sink;
import okio.Util;

public final class HashingSink
extends ForwardingSink {
    @Nullable
    private final Mac mac;
    @Nullable
    private final MessageDigest messageDigest;

    private HashingSink(Sink sink, String string2) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(string2);
            this.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSink(Sink object, ByteString byteString, String string2) {
        super((Sink)object);
        try {
            Mac mac;
            this.mac = mac = Mac.getInstance(string2);
            object = new SecretKeySpec(byteString.toByteArray(), string2);
            mac.init((Key)object);
            this.messageDigest = null;
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public static HashingSink hmacSha1(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA1");
    }

    public static HashingSink hmacSha256(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA256");
    }

    public static HashingSink hmacSha512(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA512");
    }

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    public static HashingSink sha512(Sink sink) {
        return new HashingSink(sink, "SHA-512");
    }

    public final ByteString hash() {
        Object object = this.messageDigest;
        object = object != null ? (Object)((MessageDigest)object).digest() : (Object)this.mac.doFinal();
        return ByteString.of((byte[])object);
    }

    @Override
    public void write(Buffer buffer, long l) throws IOException {
        int n;
        Util.checkOffsetAndCount(buffer.size, 0L, l);
        Segment segment = buffer.head;
        for (long i = 0L; i < l; i += (long)n) {
            n = (int)Math.min(l - i, (long)(segment.limit - segment.pos));
            MessageDigest messageDigest = this.messageDigest;
            if (messageDigest != null) {
                messageDigest.update(segment.data, segment.pos, n);
            } else {
                this.mac.update(segment.data, segment.pos, n);
            }
            segment = segment.next;
        }
        super.write(buffer, l);
    }
}

