/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Segment;
import okio.Source;

public final class HashingSource
extends ForwardingSource {
    private final Mac mac;
    private final MessageDigest messageDigest;

    private HashingSource(Source source, String string2) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(string2);
            this.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSource(Source object, ByteString byteString, String string2) {
        super((Source)object);
        try {
            this.mac = object = Mac.getInstance(string2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byteString.toByteArray(), string2);
            ((Mac)object).init(secretKeySpec);
            this.messageDigest = null;
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public static HashingSource hmacSha1(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA1");
    }

    public static HashingSource hmacSha256(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA256");
    }

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    public final ByteString hash() {
        Object object = this.messageDigest;
        object = object != null ? (Object)((MessageDigest)object).digest() : (Object)this.mac.doFinal();
        return ByteString.of((byte[])object);
    }

    @Override
    public long read(Buffer buffer, long l) throws IOException {
        long l2 = super.read(buffer, l);
        if (l2 != -1L) {
            Segment segment;
            long l3;
            long l4;
            long l5 = buffer.size - l2;
            l = buffer.size;
            Object object = buffer.head;
            while (true) {
                l4 = l5;
                l3 = l;
                segment = object;
                if (l <= l5) break;
                object = ((Segment)object).prev;
                l -= (long)(((Segment)object).limit - ((Segment)object).pos);
            }
            while (l3 < buffer.size) {
                int n = (int)((long)segment.pos + l4 - l3);
                object = this.messageDigest;
                if (object != null) {
                    ((MessageDigest)object).update(segment.data, n, segment.limit - n);
                } else {
                    this.mac.update(segment.data, n, segment.limit - n);
                }
                segment = segment.next;
                l4 = l3 += (long)(segment.limit - segment.pos);
            }
        }
        return l2;
    }
}

