/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.sink(new FileOutputStream(file, true));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public void write(Buffer buffer, long l) throws IOException {
                buffer.skip(l);
            }
        };
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        boolean bl = ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
        return bl;
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.sink(new FileOutputStream(file));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(final OutputStream outputStream, final Timeout timeout) {
        if (outputStream != null) {
            if (timeout != null) {
                return new Sink(){

                    @Override
                    public void close() throws IOException {
                        outputStream.close();
                    }

                    @Override
                    public void flush() throws IOException {
                        outputStream.flush();
                    }

                    @Override
                    public Timeout timeout() {
                        return timeout;
                    }

                    public String toString() {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("sink(");
                        stringBuilder.append(outputStream);
                        stringBuilder.append(")");
                        return stringBuilder.toString();
                    }

                    @Override
                    public void write(Buffer buffer, long l) throws IOException {
                        Util.checkOffsetAndCount(buffer.size, 0L, l);
                        while (l > 0L) {
                            timeout.throwIfReached();
                            Segment segment = buffer.head;
                            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
                            outputStream.write(segment.data, segment.pos, n);
                            segment.pos += n;
                            long l2 = n;
                            long l3 = l - l2;
                            buffer.size -= l2;
                            l = l3;
                            if (segment.pos != segment.limit) continue;
                            buffer.head = segment.pop();
                            SegmentPool.recycle(segment);
                            l = l3;
                        }
                    }
                };
            }
            throw new IllegalArgumentException("timeout == null");
        }
        throw new IllegalArgumentException("out == null");
    }

    public static Sink sink(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.getOutputStream() != null) {
                AsyncTimeout asyncTimeout = Okio.timeout(socket);
                return asyncTimeout.sink(Okio.sink(socket.getOutputStream(), asyncTimeout));
            }
            throw new IOException("socket's output stream == null");
        }
        throw new IllegalArgumentException("socket == null");
    }

    public static Sink sink(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path != null) {
            return Okio.sink(Files.newOutputStream(path, openOptionArray));
        }
        throw new IllegalArgumentException("path == null");
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.source(new FileInputStream(file));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(final InputStream inputStream, final Timeout timeout) {
        if (inputStream != null) {
            if (timeout != null) {
                return new Source(){

                    @Override
                    public void close() throws IOException {
                        inputStream.close();
                    }

                    @Override
                    public long read(Buffer object, long l) throws IOException {
                        long l2 = l - 0L;
                        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                        if (l3 >= 0) {
                            block7: {
                                if (l3 == false) {
                                    return 0L;
                                }
                                try {
                                    timeout.throwIfReached();
                                    Segment segment = ((Buffer)object).writableSegment(1);
                                    l3 = (int)Math.min(l, (long)(8192 - segment.limit));
                                    l3 = inputStream.read(segment.data, segment.limit, (int)l3);
                                    if (l3 != -1) break block7;
                                    return -1L;
                                }
                                catch (AssertionError assertionError) {
                                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                                        throw new IOException((Throwable)((Object)assertionError));
                                    }
                                    throw assertionError;
                                }
                            }
                            segment.limit += l3;
                            long l4 = ((Buffer)object).size;
                            l = l3;
                            ((Buffer)object).size = l4 + l;
                            return l;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("byteCount < 0: ");
                        ((StringBuilder)object).append(l);
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }

                    @Override
                    public Timeout timeout() {
                        return timeout;
                    }

                    public String toString() {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("source(");
                        stringBuilder.append(inputStream);
                        stringBuilder.append(")");
                        return stringBuilder.toString();
                    }
                };
            }
            throw new IllegalArgumentException("timeout == null");
        }
        throw new IllegalArgumentException("in == null");
    }

    public static Source source(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.getInputStream() != null) {
                AsyncTimeout asyncTimeout = Okio.timeout(socket);
                return asyncTimeout.source(Okio.source(socket.getInputStream(), asyncTimeout));
            }
            throw new IOException("socket's input stream == null");
        }
        throw new IllegalArgumentException("socket == null");
    }

    public static Source source(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path != null) {
            return Okio.source(Files.newInputStream(path, openOptionArray));
        }
        throw new IllegalArgumentException("path == null");
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected IOException newTimeoutException(@Nullable IOException iOException) {
                SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
                if (iOException != null) {
                    socketTimeoutException.initCause(iOException);
                }
                return socketTimeoutException;
            }

            @Override
            protected void timedOut() {
                try {
                    socket.close();
                }
                catch (AssertionError assertionError) {
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        Logger logger = Okio.logger;
                        Level level = Level.WARNING;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Failed to close timed out socket ");
                        stringBuilder.append(socket);
                        logger.log(level, stringBuilder.toString(), (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                catch (Exception exception) {
                    Logger logger = Okio.logger;
                    Level level = Level.WARNING;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed to close timed out socket ");
                    stringBuilder.append(socket);
                    logger.log(level, stringBuilder.toString(), exception);
                }
            }
        };
    }
}

