/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import okio.Buffer;
import okio.ByteString;

public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    final ByteString[] byteStrings;
    final int[] trie;

    private Options(ByteString[] byteStringArray, int[] nArray) {
        this.byteStrings = byteStringArray;
        this.trie = nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void buildTrieRecursive(long l, Buffer buffer, int n, List<ByteString> list, int n2, int n3, List<Integer> list2) {
        int n4;
        int n5;
        int n6 = n2;
        if (n6 >= n3) throw new AssertionError();
        for (n5 = n6; n5 < n3; ++n5) {
            if (list.get(n5).size() < n) throw new AssertionError();
        }
        ByteString byteString = list.get(n2);
        ByteString byteString2 = list.get(n3 - 1);
        n5 = -1;
        n2 = n6;
        Object object = byteString;
        if (n == byteString.size()) {
            n5 = list2.get(n6);
            n2 = n6 + 1;
            object = list.get(n2);
        }
        if (((ByteString)object).getByte(n) != byteString2.getByte(n)) {
            int n7;
            n6 = 1;
            for (int i = n2 + 1; i < n3; ++i) {
                n7 = n6;
                if (list.get(i - 1).getByte(n) != list.get(i).getByte(n)) {
                    n7 = n6 + 1;
                }
                n6 = n7;
            }
            l = l + (long)Options.intCount(buffer) + 2L + (long)(n6 * 2);
            buffer.writeInt(n6);
            buffer.writeInt(n5);
            for (n6 = n2; n6 < n3; ++n6) {
                n5 = list.get(n6).getByte(n);
                if (n6 != n2 && n5 == list.get(n6 - 1).getByte(n)) continue;
                buffer.writeInt(n5 & 0xFF);
            }
            object = new Buffer();
            n6 = n2;
            while (n6 < n3) {
                block15: {
                    n7 = list.get(n6).getByte(n);
                    for (n2 = n5 = n6 + 1; n2 < n3; ++n2) {
                        if (n7 == list.get(n2).getByte(n)) {
                            continue;
                        }
                        break block15;
                    }
                    n2 = n3;
                }
                if (n5 == n2 && n + 1 == list.get(n6).size()) {
                    buffer.writeInt(list2.get(n6));
                } else {
                    buffer.writeInt((int)(((long)Options.intCount((Buffer)object) + l) * -1L));
                    Options.buildTrieRecursive(l, (Buffer)object, n + 1, list, n6, n2, list2);
                }
                n6 = n2;
            }
            buffer.write((Buffer)object, ((Buffer)object).size());
            return;
        }
        n6 = 0;
        int n8 = Math.min(((ByteString)object).size(), byteString2.size());
        for (n4 = n; n4 < n8 && ((ByteString)object).getByte(n4) == byteString2.getByte(n4); ++n4) {
            ++n6;
        }
        l = 1L + (l + (long)Options.intCount(buffer) + 2L + (long)n6);
        buffer.writeInt(-n6);
        buffer.writeInt(n5);
        for (n5 = n; n5 < (n4 = n + n6); ++n5) {
            buffer.writeInt(((ByteString)object).getByte(n5) & 0xFF);
        }
        if (n2 + 1 == n3) {
            if (n4 != list.get(n2).size()) throw new AssertionError();
            buffer.writeInt(list2.get(n2));
            return;
        } else {
            object = new Buffer();
            buffer.writeInt((int)(((long)Options.intCount((Buffer)object) + l) * -1L));
            Options.buildTrieRecursive(l, (Buffer)object, n4, list, n2, n3, list2);
            buffer.write((Buffer)object, ((Buffer)object).size());
        }
    }

    private static int intCount(Buffer buffer) {
        return (int)(buffer.size() / 4L);
    }

    public static Options of(ByteString ... object) {
        int n = ((ByteString[])object).length;
        int n2 = 0;
        if (n == 0) {
            return new Options(new ByteString[0], new int[]{0, -1});
        }
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(Arrays.asList(object));
        Collections.sort(arrayList);
        Object object2 = new ArrayList<Integer>();
        for (n = 0; n < arrayList.size(); ++n) {
            object2.add(-1);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object2.set(Collections.binarySearch(arrayList, object[n]), n);
        }
        if (((ByteString)arrayList.get(0)).size() != 0) {
            Object object3;
            int n3;
            n = 0;
            while (n < arrayList.size()) {
                ByteString byteString = (ByteString)arrayList.get(n);
                int n4 = n3 = n + 1;
                while (n4 < arrayList.size() && ((ByteString)(object3 = (ByteString)arrayList.get(n4))).startsWith(byteString)) {
                    if (((ByteString)object3).size() != byteString.size()) {
                        if ((Integer)object2.get(n4) > (Integer)object2.get(n)) {
                            arrayList.remove(n4);
                            object2.remove(n4);
                            continue;
                        }
                        ++n4;
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("duplicate option: ");
                    ((StringBuilder)object).append(object3);
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                n = n3;
            }
            object3 = new Buffer();
            Options.buildTrieRecursive(0L, (Buffer)object3, 0, arrayList, 0, arrayList.size(), object2);
            n3 = Options.intCount((Buffer)object3);
            object2 = new int[n3];
            for (n = n2; n < n3; ++n) {
                object2[n] = ((Buffer)object3).readInt();
            }
            if (((Buffer)object3).exhausted()) {
                return new Options((ByteString[])object.clone(), (int[])object2);
            }
            throw new AssertionError();
        }
        throw new IllegalArgumentException("the empty byte string is not a supported option");
    }

    @Override
    public ByteString get(int n) {
        return this.byteStrings[n];
    }

    @Override
    public final int size() {
        return this.byteStrings.length;
    }
}

