/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;

final class PeekSource
implements Source {
    private final Buffer buffer;
    private boolean closed;
    private int expectedPos;
    private Segment expectedSegment;
    private long pos;
    private final BufferedSource upstream;

    PeekSource(BufferedSource object) {
        this.upstream = object;
        object = object.buffer();
        this.buffer = object;
        this.expectedSegment = object = ((Buffer)object).head;
        int n = object != null ? ((Segment)object).pos : -1;
        this.expectedPos = n;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public long read(Buffer buffer, long l) throws IOException {
        if (!this.closed) {
            Segment segment = this.expectedSegment;
            if (segment != null && (segment != this.buffer.head || this.expectedPos != this.buffer.head.pos)) {
                throw new IllegalStateException("Peek source is invalid because upstream source was used");
            }
            this.upstream.request(this.pos + l);
            if (this.expectedSegment == null && this.buffer.head != null) {
                this.expectedSegment = this.buffer.head;
                this.expectedPos = this.buffer.head.pos;
            }
            if ((l = Math.min(l, this.buffer.size - this.pos)) <= 0L) {
                return -1L;
            }
            this.buffer.copyTo(buffer, this.pos, l);
            this.pos += l;
            return l;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public Timeout timeout() {
        return this.upstream.timeout();
    }
}

