/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.PushableTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Pipe {
    final Buffer buffer = new Buffer();
    @Nullable
    private Sink foldedSink;
    final long maxBufferSize;
    private final Sink sink = new PipeSink();
    boolean sinkClosed;
    private final Source source = new PipeSource();
    boolean sourceClosed;

    public Pipe(long l) {
        if (l >= 1L) {
            this.maxBufferSize = l;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("maxBufferSize < 1: ");
        stringBuilder.append(l);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fold(Sink object) throws IOException {
        while (true) {
            Buffer buffer;
            Buffer buffer2 = this.buffer;
            synchronized (buffer2) {
                if (this.foldedSink != null) {
                    object = new IllegalStateException("sink already folded");
                    throw object;
                }
                if (this.buffer.exhausted()) {
                    this.sourceClosed = true;
                    this.foldedSink = object;
                    return;
                }
                buffer = new Buffer();
                Buffer buffer3 = this.buffer;
                buffer.write(buffer3, buffer3.size);
                this.buffer.notifyAll();
            }
            try {
                object.write(buffer, buffer.size);
                object.flush();
            }
            catch (Throwable throwable) {
                object = this.buffer;
                synchronized (object) {
                    this.sourceClosed = true;
                    this.buffer.notifyAll();
                    throw throwable;
                }
            }
        }
    }

    public final Sink sink() {
        return this.sink;
    }

    public final Source source() {
        return this.source;
    }

    final class PipeSink
    implements Sink {
        final PushableTimeout timeout = new PushableTimeout();

        PipeSink() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            Sink sink;
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    return;
                }
                if (Pipe.this.foldedSink != null) {
                    sink = Pipe.this.foldedSink;
                } else {
                    if (Pipe.this.sourceClosed && Pipe.this.buffer.size() > 0L) {
                        IOException iOException = new IOException("source is closed");
                        throw iOException;
                    }
                    Pipe.this.sinkClosed = true;
                    Pipe.this.buffer.notifyAll();
                    sink = null;
                }
            }
            if (sink == null) return;
            this.timeout.push(sink.timeout());
            try {
                sink.close();
                return;
            }
            finally {
                this.timeout.pop();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void flush() throws IOException {
            Sink sink;
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    IllegalStateException illegalStateException = new IllegalStateException("closed");
                    throw illegalStateException;
                }
                if (Pipe.this.foldedSink != null) {
                    sink = Pipe.this.foldedSink;
                } else {
                    if (Pipe.this.sourceClosed && Pipe.this.buffer.size() > 0L) {
                        IOException iOException = new IOException("source is closed");
                        throw iOException;
                    }
                    sink = null;
                }
            }
            if (sink == null) return;
            this.timeout.push(sink.timeout());
            try {
                sink.flush();
                return;
            }
            finally {
                this.timeout.pop();
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(Buffer object, long l) throws IOException {
            Sink sink;
            block12: {
                Buffer buffer = Pipe.this.buffer;
                synchronized (buffer) {
                    if (Pipe.this.sinkClosed) {
                        object = new IllegalStateException("closed");
                        throw object;
                    }
                    while (l > 0L) {
                        if (Pipe.this.foldedSink != null) {
                            sink = Pipe.this.foldedSink;
                            break block12;
                        }
                        if (Pipe.this.sourceClosed) {
                            object = new IOException("source is closed");
                            throw object;
                        }
                        long l2 = Pipe.this.maxBufferSize - Pipe.this.buffer.size();
                        if (l2 == 0L) {
                            this.timeout.waitUntilNotified(Pipe.this.buffer);
                            continue;
                        }
                        l2 = Math.min(l2, l);
                        Pipe.this.buffer.write((Buffer)object, l2);
                        l -= l2;
                        Pipe.this.buffer.notifyAll();
                    }
                    sink = null;
                }
            }
            if (sink == null) return;
            this.timeout.push(sink.timeout());
            try {
                sink.write((Buffer)object, l);
                return;
            }
            finally {
                this.timeout.pop();
            }
        }
    }

    final class PipeSource
    implements Source {
        final Timeout timeout = new Timeout();

        PipeSource() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                Pipe.this.sourceClosed = true;
                Pipe.this.buffer.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long read(Buffer object, long l) throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sourceClosed) {
                    object = new IllegalStateException("closed");
                    throw object;
                }
                while (true) {
                    if (Pipe.this.buffer.size() != 0L) {
                        l = Pipe.this.buffer.read((Buffer)object, l);
                        Pipe.this.buffer.notifyAll();
                        return l;
                    }
                    if (Pipe.this.sinkClosed) {
                        return -1L;
                    }
                    this.timeout.waitUntilNotified(Pipe.this.buffer);
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }
}

