/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.PeekSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer = new Buffer();
    boolean closed;
    public final Source source;

    RealBufferedSource(Source source) {
        Objects.requireNonNull(source, "source == null");
        this.source = source;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public boolean exhausted() throws IOException {
        if (!this.closed) {
            boolean bl = this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
            return bl;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public long indexOf(byte by) throws IOException {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l) throws IOException {
        return this.indexOf(by, l, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l, long l2) throws IOException {
        if (!this.closed) {
            if (l >= 0L && l2 >= l) {
                while (l < l2) {
                    long l3 = this.buffer.indexOf(by, l, l2);
                    if (l3 != -1L) {
                        return l3;
                    }
                    l3 = this.buffer.size;
                    if (l3 >= l2 || this.source.read(this.buffer, 8192L) == -1L) break;
                    l = Math.max(l, l3);
                }
                return -1L;
            }
            throw new IllegalArgumentException(String.format("fromIndex=%s toIndex=%s", l, l2));
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l) throws IOException {
        if (!this.closed) {
            while (true) {
                long l2;
                if ((l2 = this.buffer.indexOf(byteString, l)) != -1L) {
                    return l2;
                }
                l2 = this.buffer.size;
                if (this.source.read(this.buffer, 8192L) == -1L) {
                    return -1L;
                }
                l = Math.max(l, l2 - (long)byteString.size() + 1L);
            }
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOfElement(ByteString byteString) throws IOException {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString byteString, long l) throws IOException {
        if (!this.closed) {
            while (true) {
                long l2;
                if ((l2 = this.buffer.indexOfElement(byteString, l)) != -1L) {
                    return l2;
                }
                l2 = this.buffer.size;
                if (this.source.read(this.buffer, 8192L) == -1L) {
                    return -1L;
                }
                l = Math.max(l, l2);
            }
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int available() throws IOException {
                if (!RealBufferedSource.this.closed) {
                    return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
                }
                throw new IOException("closed");
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            @Override
            public int read() throws IOException {
                if (!RealBufferedSource.this.closed) {
                    if (RealBufferedSource.this.buffer.size == 0L && RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L) == -1L) {
                        return -1;
                    }
                    return RealBufferedSource.this.buffer.readByte() & 0xFF;
                }
                throw new IOException("closed");
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (!RealBufferedSource.this.closed) {
                    Util.checkOffsetAndCount(byArray.length, n, n2);
                    if (RealBufferedSource.this.buffer.size == 0L && RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L) == -1L) {
                        return -1;
                    }
                    return RealBufferedSource.this.buffer.read(byArray, n, n2);
                }
                throw new IOException("closed");
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(RealBufferedSource.this);
                stringBuilder.append(".inputStream()");
                return stringBuilder.toString();
            }
        };
    }

    @Override
    public boolean isOpen() {
        return this.closed ^ true;
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString) throws IOException {
        return this.rangeEquals(l, byteString, 0, byteString.size());
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString, int n, int n2) throws IOException {
        if (!this.closed) {
            if (l >= 0L && n >= 0 && n2 >= 0 && byteString.size() - n >= n2) {
                for (int i = 0; i < n2; ++i) {
                    long l2 = (long)i + l;
                    if (!this.request(1L + l2)) {
                        return false;
                    }
                    if (this.buffer.getByte(l2) == byteString.getByte(n + i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
            return -1;
        }
        return this.buffer.read(byteBuffer);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l = byArray.length;
        long l2 = n;
        long l3 = n2;
        Util.checkOffsetAndCount(l, l2, l3);
        if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
            return -1;
        }
        n2 = (int)Math.min(l3, this.buffer.size);
        return this.buffer.read(byArray, n, n2);
    }

    @Override
    public long read(Buffer object, long l) throws IOException {
        if (object != null) {
            if (l >= 0L) {
                if (!this.closed) {
                    if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
                        return -1L;
                    }
                    l = Math.min(l, this.buffer.size);
                    return this.buffer.read((Buffer)object, l);
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        if (sink != null) {
            long l;
            long l2 = 0L;
            while (this.source.read(this.buffer, 8192L) != -1L) {
                l = this.buffer.completeSegmentByteCount();
                if (l <= 0L) continue;
                l2 += l;
                sink.write(this.buffer, l);
            }
            l = l2;
            if (this.buffer.size() > 0L) {
                l = l2 + this.buffer.size();
                Buffer buffer = this.buffer;
                sink.write(buffer, buffer.size());
            }
            return l;
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    public byte[] readByteArray(long l) throws IOException {
        this.require(l);
        return this.buffer.readByteArray(l);
    }

    @Override
    public ByteString readByteString() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    public ByteString readByteString(long l) throws IOException {
        this.require(l);
        return this.buffer.readByteString(l);
    }

    @Override
    public long readDecimalLong() throws IOException {
        int n;
        this.require(1L);
        int n2 = 0;
        while (this.request(n = n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            if (by >= 48 && by <= 57 || n2 == 0 && by == 45) {
                n2 = n;
                continue;
            }
            if (n2 != 0) break;
            throw new NumberFormatException(String.format("Expected leading [0-9] or '-' character but was %#x", by));
        }
        return this.buffer.readDecimalLong();
    }

    @Override
    public void readFully(Buffer buffer, long l) throws IOException {
        try {
            this.require(l);
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
        this.buffer.readFully(buffer, l);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        try {
            this.require(byArray.length);
        }
        catch (EOFException eOFException) {
            int n = 0;
            while (this.buffer.size > 0L) {
                Buffer buffer = this.buffer;
                int n2 = buffer.read(byArray, n, (int)buffer.size);
                if (n2 != -1) {
                    n += n2;
                    continue;
                }
                throw new AssertionError();
            }
            throw eOFException;
        }
        this.buffer.readFully(byArray);
    }

    @Override
    public long readHexadecimalUnsignedLong() throws IOException {
        int n;
        this.require(1L);
        int n2 = 0;
        while (this.request(n = n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            if (by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70) {
                n2 = n;
                continue;
            }
            if (n2 != 0) break;
            throw new NumberFormatException(String.format("Expected leading [0-9a-fA-F] character but was %#x", by));
        }
        return this.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() throws IOException {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() throws IOException {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public String readString(long l, Charset charset) throws IOException {
        this.require(l);
        if (charset != null) {
            return this.buffer.readString(l, charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    public String readString(Charset charset) throws IOException {
        if (charset != null) {
            this.buffer.writeAll(this.source);
            return this.buffer.readString(charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    public String readUtf8() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long l) throws IOException {
        this.require(l);
        return this.buffer.readUtf8(l);
    }

    @Override
    public int readUtf8CodePoint() throws IOException {
        this.require(1L);
        byte by = this.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    @Nullable
    public String readUtf8Line() throws IOException {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            String string2 = this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
            return string2;
        }
        return this.buffer.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l) throws IOException {
        if (l >= 0L) {
            long l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
            long l3 = this.indexOf((byte)10, 0L, l2);
            if (l3 != -1L) {
                return this.buffer.readUtf8Line(l3);
            }
            if (l2 < Long.MAX_VALUE && this.request(l2) && this.buffer.getByte(l2 - 1L) == 13 && this.request(1L + l2) && this.buffer.getByte(l2) == 10) {
                return this.buffer.readUtf8Line(l2);
            }
            Buffer buffer = new Buffer();
            Object object = this.buffer;
            ((Buffer)object).copyTo(buffer, 0L, Math.min(32L, ((Buffer)object).size()));
            object = new StringBuilder();
            ((StringBuilder)object).append("\\n not found: limit=");
            ((StringBuilder)object).append(Math.min(this.buffer.size(), l));
            ((StringBuilder)object).append(" content=");
            ((StringBuilder)object).append(buffer.readByteString().hex());
            ((StringBuilder)object).append('\u2026');
            throw new EOFException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("limit < 0: ");
        stringBuilder.append(l);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public boolean request(long l) throws IOException {
        if (l >= 0L) {
            if (!this.closed) {
                while (this.buffer.size < l) {
                    if (this.source.read(this.buffer, 8192L) != -1L) continue;
                    return false;
                }
                return true;
            }
            throw new IllegalStateException("closed");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("byteCount < 0: ");
        stringBuilder.append(l);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public void require(long l) throws IOException {
        if (this.request(l)) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public int select(Options options) throws IOException {
        if (!this.closed) {
            int n;
            block3: {
                do {
                    if ((n = this.buffer.selectPrefix(options, true)) == -1) {
                        return -1;
                    }
                    if (n != -2) break block3;
                } while (this.source.read(this.buffer, 8192L) != -1L);
                return -1;
            }
            int n2 = options.byteStrings[n].size();
            this.buffer.skip(n2);
            return n;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public void skip(long l) throws IOException {
        if (!this.closed) {
            while (l > 0L) {
                if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
                    throw new EOFException();
                }
                long l2 = Math.min(l, this.buffer.size());
                this.buffer.skip(l2);
                l -= l2;
            }
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("buffer(");
        stringBuilder.append(this.source);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

