/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout deadlineNanoTime(long l) {
            return this;
        }

        @Override
        public void throwIfReached() throws IOException {
        }

        @Override
        public Timeout timeout(long l, TimeUnit timeUnit) {
            return this;
        }
    };
    private long deadlineNanoTime;
    private boolean hasDeadline;
    private long timeoutNanos;

    static long minTimeout(long l, long l2) {
        if (l == 0L) {
            return l2;
        }
        if (l2 == 0L) {
            return l;
        }
        if (l < l2) {
            return l;
        }
        return l2;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public final Timeout deadline(long l, TimeUnit object) {
        if (l > 0L) {
            if (object != null) {
                return this.deadlineNanoTime(System.nanoTime() + ((TimeUnit)((Object)object)).toNanos(l));
            }
            throw new IllegalArgumentException("unit == null");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("duration <= 0: ");
        ((StringBuilder)object).append(l);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public long deadlineNanoTime() {
        if (this.hasDeadline) {
            return this.deadlineNanoTime;
        }
        throw new IllegalStateException("No deadline");
    }

    public Timeout deadlineNanoTime(long l) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l;
        return this;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public void throwIfReached() throws IOException {
        if (!Thread.interrupted()) {
            if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
                throw new InterruptedIOException("deadline reached");
            }
            return;
        }
        Thread.currentThread().interrupt();
        throw new InterruptedIOException("interrupted");
    }

    public Timeout timeout(long l, TimeUnit object) {
        if (l >= 0L) {
            if (object != null) {
                this.timeoutNanos = ((TimeUnit)((Object)object)).toNanos(l);
                return this;
            }
            throw new IllegalArgumentException("unit == null");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("timeout < 0: ");
        ((StringBuilder)object).append(l);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    /*
     * Unable to fully structure code
     */
    public final void waitUntilNotified(Object var1_1) throws InterruptedIOException {
        block12: {
            block11: {
                try {
                    var2_3 = this.hasDeadline();
                    var3_4 = this.timeoutNanos();
                    var5_5 = 0L;
                    if (var2_3 || var3_4 != 0L) ** GOTO lbl12
                }
                catch (InterruptedException var1_2) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("interrupted");
                }
                var1_1.wait();
                return;
lbl12:
                // 1 sources

                var7_6 = System.nanoTime();
                if (!var2_3 || var3_4 == 0L) break block11;
                var3_4 = Math.min(var3_4, this.deadlineNanoTime() - var7_6);
                break block12;
            }
            if (var2_3) {
                var3_4 = this.deadlineNanoTime() - var7_6;
            }
        }
        if (var3_4 > 0L) {
            var5_5 = var3_4 / 1000000L;
            Long.signum(var5_5);
            var9_7 = (int)(var3_4 - 1000000L * var5_5);
            var1_1.wait(var5_5, var9_7);
            var5_5 = System.nanoTime() - var7_6;
        }
        if (var5_5 < var3_4) {
            return;
        }
        var1_1 = new InterruptedIOException("timeout");
        throw var1_1;
    }
}

