/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import java.util.Objects;
import org.apache.html.dom.CollectionIndex;
import org.apache.html.dom.HTMLFormControl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLAppletElement;
import org.w3c.dom.html.HTMLAreaElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLObjectElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

class HTMLCollectionImpl
implements HTMLCollection {
    static final short ANCHOR = 1;
    static final short APPLET = 4;
    static final short AREA = -1;
    static final short CELL = -3;
    static final short ELEMENT = 8;
    static final short FORM = 2;
    static final short IMAGE = 3;
    static final short LINK = 5;
    static final short OPTION = 6;
    static final short ROW = 7;
    static final short TBODY = -2;
    private short _lookingFor;
    private Element _topLevel;

    HTMLCollectionImpl(HTMLElement hTMLElement, short s) {
        Objects.requireNonNull(hTMLElement, "HTM011 Argument 'topLevel' is null.");
        this._topLevel = hTMLElement;
        this._lookingFor = s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getLength(Element element) {
        synchronized (element) {
            int n = 0;
            Node node = element.getFirstChild();
            while (node != null) {
                int n2 = n;
                if (node instanceof Element) {
                    if (this.collectionMatch((Element)node, null)) {
                        n2 = n + 1;
                    } else {
                        n2 = n;
                        if (this.recurse()) {
                            n2 = n + this.getLength((Element)node);
                        }
                    }
                }
                node = node.getNextSibling();
                n = n2;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node item(Element element, CollectionIndex collectionIndex) {
        synchronized (element) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Node node2;
                    if (this.collectionMatch((Element)node, null)) {
                        if (collectionIndex.isZero()) {
                            return node;
                        }
                        collectionIndex.decrement();
                    } else if (this.recurse() && (node2 = this.item((Element)node, collectionIndex)) != null) {
                        return node2;
                    }
                }
                node = node.getNextSibling();
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node namedItem(Element element, String string2) {
        synchronized (element) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Node node2;
                    if (this.collectionMatch((Element)node, string2)) {
                        return node;
                    }
                    if (this.recurse() && (node2 = this.namedItem((Element)node, string2)) != null) {
                        return node2;
                    }
                }
                node = node.getNextSibling();
            }
            return node;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean collectionMatch(Element var1_1, String var2_2) {
        synchronized (var1_1) {
            block18: {
                var3_3 = this._lookingFor;
                var4_4 = false;
                switch (var3_3) {
                    default: {
                        var5_5 = var4_4;
                        break block18;
                    }
                    case 8: {
                        var5_5 = var1_1 instanceof HTMLFormControl;
                        break block18;
                    }
                    case 7: {
                        var5_5 = var1_1 instanceof HTMLTableRowElement;
                        break block18;
                    }
                    case 6: {
                        var5_5 = var1_1 instanceof HTMLOptionElement;
                        break block18;
                    }
                    case 5: {
                        if (var1_1 instanceof HTMLAnchorElement) ** GOTO lbl21
                        var5_5 = var4_4;
                        if (!(var1_1 instanceof HTMLAreaElement)) break block18;
lbl21:
                        // 2 sources

                        var5_5 = var4_4;
                        if (var1_1.getAttribute("href").length() <= 0) break block18;
                        ** GOTO lbl52
                    }
                    case 4: {
                        if (var1_1 instanceof HTMLAppletElement) ** GOTO lbl52
                        var5_5 = var4_4;
                        if (!(var1_1 instanceof HTMLObjectElement)) break block18;
                        if ("application/java".equals(var1_1.getAttribute("codetype"))) ** GOTO lbl52
                        var5_5 = var4_4;
                        if (!var1_1.getAttribute("classid").startsWith("java:")) break block18;
                        ** GOTO lbl52
                    }
                    case 3: {
                        var5_5 = var1_1 instanceof HTMLImageElement;
                        break block18;
                    }
                    case 2: {
                        var5_5 = var1_1 instanceof HTMLFormElement;
                        break block18;
                    }
                    case 1: {
                        var5_5 = var4_4;
                        if (!(var1_1 instanceof HTMLAnchorElement)) break block18;
                        var5_5 = var4_4;
                        if (var1_1.getAttribute("name").length() <= 0) break block18;
                        ** GOTO lbl52
                    }
                    case -1: {
                        var5_5 = var1_1 instanceof HTMLAreaElement;
                        break block18;
                    }
                    case -2: {
                        var5_5 = var4_4;
                        if (!(var1_1 instanceof HTMLTableSectionElement)) break block18;
                        var5_5 = var4_4;
                        if (!var1_1.getTagName().equals("tbody")) break block18;
lbl52:
                        // 6 sources

                        var5_5 = true;
                        break block18;
                    }
                    case -3: 
                }
                var5_5 = var1_1 instanceof HTMLTableCellElement;
            }
            var4_4 = var5_5;
            if (var5_5 == false) return var4_4;
            var4_4 = var5_5;
            if (var2_2 == null) return var4_4;
            if (var1_1 instanceof HTMLAnchorElement == false) return var2_2.equals(var1_1.getAttribute("id"));
            if (var2_2.equals(var1_1.getAttribute("name")) == false) return var2_2.equals(var1_1.getAttribute("id"));
            return true;
        }
    }

    @Override
    public final int getLength() {
        return this.getLength(this._topLevel);
    }

    @Override
    public final Node item(int n) {
        if (n >= 0) {
            return this.item(this._topLevel, new CollectionIndex(n));
        }
        throw new IllegalArgumentException("HTM012 Argument 'index' is negative.");
    }

    @Override
    public final Node namedItem(String string2) {
        Objects.requireNonNull(string2, "HTM013 Argument 'name' is null.");
        return this.namedItem(this._topLevel, string2);
    }

    protected boolean recurse() {
        boolean bl = this._lookingFor > 0;
        return bl;
    }
}

