/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLCollectionImpl;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.apache.html.dom.HTMLTableCaptionElementImpl;
import org.apache.html.dom.HTMLTableRowElementImpl;
import org.apache.html.dom.HTMLTableSectionElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableElementImpl
extends HTMLElementImpl
implements HTMLTableElement {
    private HTMLCollectionImpl _bodies;
    private HTMLCollectionImpl _rows;

    public HTMLTableElementImpl(HTMLDocumentImpl hTMLDocumentImpl, String string2) {
        super(hTMLDocumentImpl, string2);
    }

    @Override
    public HTMLElement createCaption() {
        synchronized (this) {
            HTMLTableCaptionElement hTMLTableCaptionElement;
            block4: {
                hTMLTableCaptionElement = this.getCaption();
                if (hTMLTableCaptionElement == null) break block4;
                return hTMLTableCaptionElement;
            }
            hTMLTableCaptionElement = new HTMLTableCaptionElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "CAPTION");
            this.appendChild(hTMLTableCaptionElement);
            return hTMLTableCaptionElement;
        }
    }

    @Override
    public HTMLElement createTFoot() {
        synchronized (this) {
            HTMLTableSectionElement hTMLTableSectionElement;
            block4: {
                hTMLTableSectionElement = this.getTFoot();
                if (hTMLTableSectionElement == null) break block4;
                return hTMLTableSectionElement;
            }
            hTMLTableSectionElement = new HTMLTableSectionElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TFOOT");
            this.appendChild(hTMLTableSectionElement);
            return hTMLTableSectionElement;
        }
    }

    @Override
    public HTMLElement createTHead() {
        synchronized (this) {
            HTMLTableSectionElement hTMLTableSectionElement;
            block4: {
                hTMLTableSectionElement = this.getTHead();
                if (hTMLTableSectionElement == null) break block4;
                return hTMLTableSectionElement;
            }
            hTMLTableSectionElement = new HTMLTableSectionElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "THEAD");
            this.appendChild(hTMLTableSectionElement);
            return hTMLTableSectionElement;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteCaption() {
        synchronized (this) {
            HTMLTableCaptionElement hTMLTableCaptionElement = this.getCaption();
            if (hTMLTableCaptionElement != null) {
                this.removeChild(hTMLTableCaptionElement);
            }
            return;
        }
    }

    @Override
    public void deleteRow(int n) {
        synchronized (this) {
            Node node = this.getFirstChild();
            int n2 = n;
            while (true) {
                if (node == null) {
                    return;
                }
                if (!(node instanceof HTMLTableRowElement)) break block9;
                n = n2;
                if (n2 != 0) break block10;
                break;
            }
            {
                block10: {
                    block9: {
                        this.removeChild(node);
                        return;
                    }
                    n = n2;
                    if (!(node instanceof HTMLTableSectionElementImpl)) break block10;
                    n = n2 = ((HTMLTableSectionElementImpl)node).deleteRowX(n2);
                    if (n2 >= 0) break block10;
                    return;
                }
                node = node.getNextSibling();
                n2 = n;
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteTFoot() {
        synchronized (this) {
            HTMLTableSectionElement hTMLTableSectionElement = this.getTFoot();
            if (hTMLTableSectionElement != null) {
                this.removeChild(hTMLTableSectionElement);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteTHead() {
        synchronized (this) {
            HTMLTableSectionElement hTMLTableSectionElement = this.getTHead();
            if (hTMLTableSectionElement != null) {
                this.removeChild(hTMLTableSectionElement);
            }
            return;
        }
    }

    @Override
    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    @Override
    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    @Override
    public String getBorder() {
        return this.getAttribute("border");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HTMLTableCaptionElement getCaption() {
        synchronized (this) {
            Node node = this.getFirstChild();
            while (node != null) {
                if (node instanceof HTMLTableCaptionElement && node.getNodeName().equals("CAPTION")) {
                    return (HTMLTableCaptionElement)node;
                }
                node = node.getNextSibling();
            }
            return null;
        }
    }

    @Override
    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    @Override
    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    @Override
    public String getFrame() {
        return this.capitalize(this.getAttribute("frame"));
    }

    @Override
    public HTMLCollection getRows() {
        if (this._rows == null) {
            this._rows = new HTMLCollectionImpl(this, 7);
        }
        return this._rows;
    }

    @Override
    public String getRules() {
        return this.capitalize(this.getAttribute("rules"));
    }

    @Override
    public String getSummary() {
        return this.getAttribute("summary");
    }

    @Override
    public HTMLCollection getTBodies() {
        if (this._bodies == null) {
            this._bodies = new HTMLCollectionImpl(this, -2);
        }
        return this._bodies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HTMLTableSectionElement getTFoot() {
        synchronized (this) {
            Node node = this.getFirstChild();
            while (node != null) {
                if (node instanceof HTMLTableSectionElement && node.getNodeName().equals("TFOOT")) {
                    return (HTMLTableSectionElement)node;
                }
                node = node.getNextSibling();
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HTMLTableSectionElement getTHead() {
        synchronized (this) {
            Node node = this.getFirstChild();
            while (node != null) {
                if (node instanceof HTMLTableSectionElement && node.getNodeName().equals("THEAD")) {
                    return (HTMLTableSectionElement)node;
                }
                node = node.getNextSibling();
            }
            return null;
        }
    }

    @Override
    public String getWidth() {
        return this.getAttribute("width");
    }

    @Override
    public HTMLElement insertRow(int n) {
        HTMLTableRowElementImpl hTMLTableRowElementImpl = new HTMLTableRowElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TR");
        this.insertRowX(n, hTMLTableRowElementImpl);
        return hTMLTableRowElementImpl;
    }

    void insertRowX(int n, HTMLTableRowElementImpl hTMLTableRowElementImpl) {
        Node node = this.getFirstChild();
        Node node2 = null;
        int n2 = n;
        while (true) {
            if (node == null) {
                if (node2 != null) {
                    node2.appendChild(hTMLTableRowElementImpl);
                } else {
                    this.appendChild(hTMLTableRowElementImpl);
                }
                return;
            }
            if (node instanceof HTMLTableRowElement) {
                n = n2;
                if (n2 == 0) {
                    this.insertBefore(hTMLTableRowElementImpl, node);
                    return;
                }
            } else {
                n = n2;
                if (node instanceof HTMLTableSectionElementImpl) {
                    n = ((HTMLTableSectionElementImpl)node).insertRowX(n2, hTMLTableRowElementImpl);
                    if (n < 0) {
                        return;
                    }
                    node2 = node;
                }
            }
            node = node.getNextSibling();
            n2 = n;
        }
    }

    @Override
    public void setAlign(String string2) {
        this.setAttribute("align", string2);
    }

    @Override
    public void setBgColor(String string2) {
        this.setAttribute("bgcolor", string2);
    }

    @Override
    public void setBorder(String string2) {
        this.setAttribute("border", string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setCaption(HTMLTableCaptionElement object) {
        synchronized (this) {
            if (object != null && !object.getTagName().equals("CAPTION")) {
                object = new IllegalArgumentException("HTM016 Argument 'caption' is not an element of type <CAPTION>.");
                throw object;
            }
            this.deleteCaption();
            if (object != null) {
                this.appendChild((Node)object);
            }
            return;
        }
    }

    @Override
    public void setCellPadding(String string2) {
        this.setAttribute("cellpadding", string2);
    }

    @Override
    public void setCellSpacing(String string2) {
        this.setAttribute("cellspacing", string2);
    }

    @Override
    public void setFrame(String string2) {
        this.setAttribute("frame", string2);
    }

    @Override
    public void setRules(String string2) {
        this.setAttribute("rules", string2);
    }

    @Override
    public void setSummary(String string2) {
        this.setAttribute("summary", string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setTFoot(HTMLTableSectionElement object) {
        synchronized (this) {
            if (object != null && !object.getTagName().equals("TFOOT")) {
                object = new IllegalArgumentException("HTM018 Argument 'tFoot' is not an element of type <TFOOT>.");
                throw object;
            }
            this.deleteTFoot();
            if (object != null) {
                this.appendChild((Node)object);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setTHead(HTMLTableSectionElement object) {
        synchronized (this) {
            if (object != null && !object.getTagName().equals("THEAD")) {
                object = new IllegalArgumentException("HTM017 Argument 'tHead' is not an element of type <THEAD>.");
                throw object;
            }
            this.deleteTHead();
            if (object != null) {
                this.appendChild((Node)object);
            }
            return;
        }
    }

    @Override
    public void setWidth(String string2) {
        this.setAttribute("width", string2);
    }
}

