/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import org.apache.http.entity.mime.Header;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.entity.mime.content.ContentBody;

public class FormBodyPart {
    private final ContentBody body;
    private final Header header;
    private final String name;

    public FormBodyPart(String string2, ContentBody contentBody) {
        if (string2 != null) {
            if (contentBody != null) {
                this.name = string2;
                this.body = contentBody;
                this.header = new Header();
                this.generateContentDisp(contentBody);
                this.generateContentType(contentBody);
                this.generateTransferEncoding(contentBody);
                return;
            }
            throw new IllegalArgumentException("Body may not be null");
        }
        throw new IllegalArgumentException("Name may not be null");
    }

    public void addField(String string2, String string3) {
        if (string2 != null) {
            this.header.addField(new MinimalField(string2, string3));
            return;
        }
        throw new IllegalArgumentException("Field name may not be null");
    }

    protected void generateContentDisp(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form-data; name=\"");
        stringBuilder.append(this.getName());
        stringBuilder.append("\"");
        if (contentBody.getFilename() != null) {
            stringBuilder.append("; filename=\"");
            stringBuilder.append(contentBody.getFilename());
            stringBuilder.append("\"");
        }
        this.addField("Content-Disposition", stringBuilder.toString());
    }

    protected void generateContentType(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(contentBody.getMimeType());
        if (contentBody.getCharset() != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(contentBody.getCharset());
        }
        this.addField("Content-Type", stringBuilder.toString());
    }

    protected void generateTransferEncoding(ContentBody contentBody) {
        this.addField("Content-Transfer-Encoding", contentBody.getTransferEncoding());
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getName() {
        return this.name;
    }
}

