/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.entity.mime.MinimalField;

public class Header
implements Iterable<MinimalField> {
    private final Map<String, List<MinimalField>> fieldMap;
    private final List<MinimalField> fields = new LinkedList<MinimalField>();

    public Header() {
        this.fieldMap = new HashMap<String, List<MinimalField>>();
    }

    public void addField(MinimalField minimalField) {
        List<MinimalField> list;
        if (minimalField == null) {
            return;
        }
        String string2 = minimalField.getName().toLowerCase(Locale.US);
        List<MinimalField> list2 = list = this.fieldMap.get(string2);
        if (list == null) {
            list2 = new LinkedList<MinimalField>();
            this.fieldMap.put(string2, list2);
        }
        list2.add(minimalField);
        this.fields.add(minimalField);
    }

    public MinimalField getField(String object) {
        if (object == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.US);
        if ((object = this.fieldMap.get(object)) != null && !object.isEmpty()) {
            return (MinimalField)object.get(0);
        }
        return null;
    }

    public List<MinimalField> getFields() {
        return new ArrayList<MinimalField>(this.fields);
    }

    public List<MinimalField> getFields(String object) {
        if (object == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.US);
        if ((object = this.fieldMap.get(object)) != null && !object.isEmpty()) {
            return new ArrayList<MinimalField>((Collection<MinimalField>)object);
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<MinimalField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public int removeFields(String object) {
        if (object == null) {
            return 0;
        }
        object = ((String)object).toLowerCase(Locale.US);
        if ((object = this.fieldMap.remove(object)) != null && !object.isEmpty()) {
            this.fields.removeAll((Collection<?>)object);
            return object.size();
        }
        return 0;
    }

    public void setField(MinimalField minimalField) {
        if (minimalField == null) {
            return;
        }
        Iterator<MinimalField> iterator2 = minimalField.getName().toLowerCase(Locale.US);
        if ((iterator2 = this.fieldMap.get(iterator2)) != null && !iterator2.isEmpty()) {
            iterator2.clear();
            iterator2.add(minimalField);
            int n = 0;
            iterator2 = this.fields.iterator();
            int n2 = -1;
            while (iterator2.hasNext()) {
                int n3 = n2;
                if (iterator2.next().getName().equalsIgnoreCase(minimalField.getName())) {
                    iterator2.remove();
                    n3 = n2;
                    if (n2 == -1) {
                        n3 = n;
                    }
                }
                ++n;
                n2 = n3;
            }
            this.fields.add(n2, minimalField);
            return;
        }
        this.addField(minimalField);
    }

    public String toString() {
        return this.fields.toString();
    }
}

