/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.Header;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.util.ByteArrayBuffer;

public class HttpMultipart {
    private static final ByteArrayBuffer CR_LF;
    private static final ByteArrayBuffer FIELD_SEP;
    private static final ByteArrayBuffer TWO_DASHES;
    private final String boundary;
    private final Charset charset;
    private final HttpMultipartMode mode;
    private final List<FormBodyPart> parts;
    private final String subType;

    static {
        FIELD_SEP = HttpMultipart.encode(MIME.DEFAULT_CHARSET, ": ");
        CR_LF = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "\r\n");
        TWO_DASHES = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "--");
    }

    public HttpMultipart(String string2, String string3) {
        this(string2, null, string3);
    }

    public HttpMultipart(String string2, Charset charset, String string3) {
        this(string2, charset, string3, HttpMultipartMode.STRICT);
    }

    public HttpMultipart(String string2, Charset charset, String string3, HttpMultipartMode httpMultipartMode) {
        if (string2 != null) {
            if (string3 != null) {
                this.subType = string2;
                if (charset == null) {
                    charset = MIME.DEFAULT_CHARSET;
                }
                this.charset = charset;
                this.boundary = string3;
                this.parts = new ArrayList<FormBodyPart>();
                this.mode = httpMultipartMode;
                return;
            }
            throw new IllegalArgumentException("Multipart boundary may not be null");
        }
        throw new IllegalArgumentException("Multipart subtype may not be null");
    }

    private void doWriteTo(HttpMultipartMode httpMultipartMode, OutputStream outputStream, boolean bl) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(this.charset, this.getBoundary());
        for (FormBodyPart formBodyPart : this.parts) {
            Object object;
            block4: {
                block3: {
                    HttpMultipart.writeBytes(TWO_DASHES, outputStream);
                    HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
                    HttpMultipart.writeBytes(CR_LF, outputStream);
                    object = formBodyPart.getHeader();
                    int n = 1.$SwitchMap$org$apache$http$entity$mime$HttpMultipartMode[httpMultipartMode.ordinal()];
                    if (n == 1) break block3;
                    if (n != 2) break block4;
                    HttpMultipart.writeField(formBodyPart.getHeader().getField("Content-Disposition"), this.charset, outputStream);
                    if (formBodyPart.getBody().getFilename() == null) break block4;
                    HttpMultipart.writeField(formBodyPart.getHeader().getField("Content-Type"), this.charset, outputStream);
                    break block4;
                }
                object = ((Header)object).iterator();
                while (object.hasNext()) {
                    HttpMultipart.writeField((MinimalField)object.next(), outputStream);
                }
            }
            object = CR_LF;
            HttpMultipart.writeBytes((ByteArrayBuffer)object, outputStream);
            if (bl) {
                formBodyPart.getBody().writeTo(outputStream);
            }
            HttpMultipart.writeBytes((ByteArrayBuffer)object, outputStream);
        }
        httpMultipartMode = TWO_DASHES;
        HttpMultipart.writeBytes((ByteArrayBuffer)httpMultipartMode, outputStream);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
        HttpMultipart.writeBytes((ByteArrayBuffer)httpMultipartMode, outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    private static ByteArrayBuffer encode(Charset charset, String object) {
        object = charset.encode(CharBuffer.wrap((CharSequence)object));
        charset = new ByteArrayBuffer(((Buffer)object).remaining());
        charset.append(((ByteBuffer)object).array(), ((Buffer)object).position(), ((Buffer)object).remaining());
        return charset;
    }

    private static void writeBytes(String string2, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(HttpMultipart.encode(MIME.DEFAULT_CHARSET, string2), outputStream);
    }

    private static void writeBytes(String string2, Charset charset, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(HttpMultipart.encode(charset, string2), outputStream);
    }

    private static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream) throws IOException {
        outputStream.write(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length());
    }

    private static void writeField(MinimalField minimalField, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), outputStream);
        HttpMultipart.writeBytes(FIELD_SEP, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    private static void writeField(MinimalField minimalField, Charset charset, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), charset, outputStream);
        HttpMultipart.writeBytes(FIELD_SEP, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), charset, outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    public void addBodyPart(FormBodyPart formBodyPart) {
        if (formBodyPart == null) {
            return;
        }
        this.parts.add(formBodyPart);
    }

    public List<FormBodyPart> getBodyParts() {
        return this.parts;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HttpMultipartMode getMode() {
        return this.mode;
    }

    public String getSubType() {
        return this.subType;
    }

    public long getTotalLength() {
        int n;
        Object object = this.parts.iterator();
        long l = 0L;
        while (object.hasNext()) {
            long l2 = object.next().getBody().getContentLength();
            if (l2 >= 0L) {
                l += l2;
                continue;
            }
            return -1L;
        }
        object = new ByteArrayOutputStream();
        try {
            this.doWriteTo(this.mode, (OutputStream)object, false);
            n = ((ByteArrayOutputStream)object).toByteArray().length;
        }
        catch (IOException iOException) {
            return -1L;
        }
        return l + (long)n;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.doWriteTo(this.mode, outputStream, true);
    }
}

