/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.message.BasicHeader;

public class MultipartEntity
implements HttpEntity {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final Header contentType;
    private volatile boolean dirty;
    private long length;
    private final HttpMultipart multipart;

    public MultipartEntity() {
        this(HttpMultipartMode.STRICT, null, null);
    }

    public MultipartEntity(HttpMultipartMode httpMultipartMode) {
        this(httpMultipartMode, null, null);
    }

    public MultipartEntity(HttpMultipartMode httpMultipartMode, String object, Charset charset) {
        String string2 = object;
        if (object == null) {
            string2 = this.generateBoundary();
        }
        object = httpMultipartMode;
        if (httpMultipartMode == null) {
            object = HttpMultipartMode.STRICT;
        }
        this.multipart = new HttpMultipart("form-data", charset, string2, (HttpMultipartMode)((Object)object));
        this.contentType = new BasicHeader("Content-Type", this.generateContentType(string2, charset));
        this.dirty = true;
    }

    public void addPart(String string2, ContentBody contentBody) {
        this.addPart(new FormBodyPart(string2, contentBody));
    }

    public void addPart(FormBodyPart formBodyPart) {
        this.multipart.addBodyPart(formBodyPart);
        this.dirty = true;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (!this.isStreaming()) {
            return;
        }
        throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
    }

    protected String generateBoundary() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        int n = random.nextInt(11);
        for (int i = 0; i < n + 30; ++i) {
            char[] cArray = MULTIPART_CHARS;
            stringBuilder.append(cArray[random.nextInt(cArray.length)]);
        }
        return stringBuilder.toString();
    }

    protected String generateContentType(String string2, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("multipart/form-data; boundary=");
        stringBuilder.append(string2);
        if (charset != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(charset.name());
        }
        return stringBuilder.toString();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Multipart form entity does not implement #getContent()");
    }

    public Header getContentEncoding() {
        return null;
    }

    public long getContentLength() {
        if (this.dirty) {
            this.length = this.multipart.getTotalLength();
            this.dirty = false;
        }
        return this.length;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public boolean isChunked() {
        return this.isRepeatable() ^ true;
    }

    public boolean isRepeatable() {
        Iterator<FormBodyPart> iterator2 = this.multipart.getBodyParts().iterator();
        while (iterator2.hasNext()) {
            if (iterator2.next().getBody().getContentLength() >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isStreaming() {
        return this.isRepeatable() ^ true;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.multipart.writeTo(outputStream);
    }
}

