/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class FileBody
extends AbstractContentBody {
    private final String charset;
    private final File file;
    private final String filename;

    public FileBody(File file) {
        this(file, "application/octet-stream");
    }

    public FileBody(File file, String string2) {
        this(file, string2, null);
    }

    public FileBody(File file, String string2, String string3) {
        this(file, null, string2, string3);
    }

    public FileBody(File file, String string2, String string3, String string4) {
        super(string3);
        if (file != null) {
            this.file = file;
            this.filename = string2 != null ? string2 : file.getName();
            this.charset = string4;
            return;
        }
        throw new IllegalArgumentException("File may not be null");
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.flush();
                return;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        throw new IllegalArgumentException("Output stream may not be null");
    }
}

